/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.pool;

import io.r2dbc.pool.Validation;
import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionMetadata;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.TransactionDefinition;
import io.r2dbc.spi.ValidationDepth;
import io.r2dbc.spi.Wrapped;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.pool.PooledRef;
import reactor.util.Logger;
import reactor.util.Loggers;

final class PooledConnection
implements Connection,
Wrapped<Connection> {
    private static final Logger logger = Loggers.getLogger(PooledConnection.class);
    private final PooledRef<Connection> ref;
    private final Connection connection;
    private final Mono<Void> release;
    private volatile boolean closed = false;
    private volatile boolean inTransaction = false;

    PooledConnection(PooledRef<Connection> ref) {
        this.ref = ref;
        this.connection = (Connection)ref.poolable();
        this.release = Mono.defer(() -> Validation.validate((Connection)this, ValidationDepth.LOCAL).then(Mono.defer(() -> {
            Mono cleanup = Mono.empty();
            if (this.inTransaction) {
                cleanup = this.rollbackTransaction().onErrorResume(throwable -> Mono.empty()).then();
            }
            return cleanup.doOnSubscribe(ignore -> {
                this.closed = true;
            }).then(this.ref.release());
        })).onErrorResume(throwable -> ref.invalidate()).doOnSubscribe(subscription -> logger.debug("Releasing connection")));
    }

    public Mono<Void> beginTransaction() {
        this.assertNotClosed();
        return Mono.from((Publisher)this.connection.beginTransaction()).doOnSubscribe(ignore -> {
            this.inTransaction = true;
        }).doOnError(e -> {
            this.inTransaction = false;
        });
    }

    public Mono<Void> beginTransaction(TransactionDefinition definition) {
        this.assertNotClosed();
        return Mono.from((Publisher)this.connection.beginTransaction(definition)).doOnSubscribe(ignore -> {
            this.inTransaction = true;
        }).doOnError(e -> {
            this.inTransaction = false;
        });
    }

    public Mono<Void> close() {
        this.assertNotClosed();
        return this.release;
    }

    public Mono<Void> commitTransaction() {
        this.assertNotClosed();
        return Mono.from((Publisher)this.connection.commitTransaction()).doOnSubscribe(ignore -> {
            this.inTransaction = false;
        });
    }

    public Batch createBatch() {
        this.assertNotClosed();
        return this.connection.createBatch();
    }

    public Publisher<Void> createSavepoint(String s) {
        this.assertNotClosed();
        return this.connection.createSavepoint(s);
    }

    public Statement createStatement(String s) {
        this.assertNotClosed();
        return this.connection.createStatement(s);
    }

    public boolean isAutoCommit() {
        this.assertNotClosed();
        return this.connection.isAutoCommit();
    }

    public ConnectionMetadata getMetadata() {
        this.assertNotClosed();
        return this.connection.getMetadata();
    }

    public IsolationLevel getTransactionIsolationLevel() {
        this.assertNotClosed();
        return this.connection.getTransactionIsolationLevel();
    }

    public Publisher<Void> releaseSavepoint(String s) {
        this.assertNotClosed();
        return this.connection.releaseSavepoint(s);
    }

    public Mono<Void> rollbackTransaction() {
        return Mono.from((Publisher)this.connection.rollbackTransaction()).doOnSubscribe(ignore -> {
            this.inTransaction = false;
        });
    }

    public Mono<Void> rollbackTransactionToSavepoint(String s) {
        return Mono.from((Publisher)this.connection.rollbackTransactionToSavepoint(s));
    }

    public Mono<Void> setAutoCommit(boolean autoCommit) {
        this.assertNotClosed();
        return Mono.from((Publisher)this.connection.setAutoCommit(autoCommit));
    }

    public Mono<Void> setTransactionIsolationLevel(IsolationLevel isolationLevel) {
        this.assertNotClosed();
        return Mono.from((Publisher)this.connection.setTransactionIsolationLevel(isolationLevel));
    }

    public Connection unwrap() {
        return this.connection;
    }

    public Publisher<Boolean> validate(ValidationDepth validationDepth) {
        return this.connection.validate(validationDepth);
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append(this.connection.toString());
        sb.append("]");
        return sb.toString();
    }
}

