/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.pool;

import io.r2dbc.pool.Assert;
import io.r2dbc.pool.SimplePoolMetricsRecorder;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ValidationDepth;
import java.time.Clock;
import java.time.Duration;
import java.util.function.Consumer;
import reactor.pool.PoolBuilder;
import reactor.pool.PoolConfig;
import reactor.pool.PoolMetricsRecorder;
import reactor.util.annotation.Nullable;

public final class ConnectionPoolConfiguration {
    public static final Duration NO_TIMEOUT = Duration.ofNanos(-1L);
    private final int acquireRetry;
    private final ConnectionFactory connectionFactory;
    private final Clock clock;
    private final Consumer<PoolBuilder<Connection, ? extends PoolConfig<? extends Connection>>> customizer;
    private final int initialSize;
    private final int maxSize;
    private final Duration maxIdleTime;
    private final Duration maxCreateConnectionTime;
    private final Duration maxAcquireTime;
    private final Duration maxLifeTime;
    private final PoolMetricsRecorder metricsRecorder;
    @Nullable
    private final String name;
    private final boolean registerJmx;
    private final ValidationDepth validationDepth;
    @Nullable
    private final String validationQuery;

    private ConnectionPoolConfiguration(int acquireRetry, ConnectionFactory connectionFactory, Clock clock, Consumer<PoolBuilder<Connection, ? extends PoolConfig<? extends Connection>>> customizer, int initialSize, int maxSize, Duration maxIdleTime, Duration maxCreateConnectionTime, Duration maxAcquireTime, Duration maxLifeTime, PoolMetricsRecorder metricsRecorder, @Nullable String name, boolean registerJmx, ValidationDepth validationDepth, @Nullable String validationQuery) {
        this.acquireRetry = acquireRetry;
        this.connectionFactory = Assert.requireNonNull(connectionFactory, "ConnectionFactory must not be null");
        this.clock = clock;
        this.customizer = customizer;
        this.initialSize = initialSize;
        this.maxSize = maxSize;
        this.maxIdleTime = maxIdleTime;
        this.maxCreateConnectionTime = maxCreateConnectionTime;
        this.maxAcquireTime = maxAcquireTime;
        this.maxLifeTime = maxLifeTime;
        this.metricsRecorder = metricsRecorder;
        this.name = name;
        this.registerJmx = registerJmx;
        this.validationDepth = validationDepth;
        this.validationQuery = validationQuery;
    }

    public static Builder builder(ConnectionFactory connectionFactory) {
        return new Builder().connectionFactory(connectionFactory);
    }

    public static Builder builder() {
        return new Builder();
    }

    int getAcquireRetry() {
        return this.acquireRetry;
    }

    ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    Clock getClock() {
        return this.clock;
    }

    Consumer<PoolBuilder<Connection, ? extends PoolConfig<? extends Connection>>> getCustomizer() {
        return this.customizer;
    }

    Duration getMaxIdleTime() {
        return this.maxIdleTime;
    }

    int getInitialSize() {
        return this.initialSize;
    }

    int getMaxSize() {
        return this.maxSize;
    }

    Duration getMaxCreateConnectionTime() {
        return this.maxCreateConnectionTime;
    }

    Duration getMaxAcquireTime() {
        return this.maxAcquireTime;
    }

    Duration getMaxLifeTime() {
        return this.maxLifeTime;
    }

    PoolMetricsRecorder getMetricsRecorder() {
        return this.metricsRecorder;
    }

    @Nullable
    String getName() {
        return this.name;
    }

    boolean isRegisterJmx() {
        return this.registerJmx;
    }

    ValidationDepth getValidationDepth() {
        return this.validationDepth;
    }

    @Nullable
    String getValidationQuery() {
        return this.validationQuery;
    }

    public static final class Builder {
        private static final int DEFAULT_SIZE = 10;
        private int acquireRetry = 1;
        private ConnectionFactory connectionFactory;
        private Clock clock = Clock.systemUTC();
        private Consumer<PoolBuilder<Connection, ? extends PoolConfig<? extends Connection>>> customizer = poolBuilder -> {};
        private Integer initialSize;
        private Integer maxSize;
        private Duration maxIdleTime = Duration.ofMinutes(30L);
        private Duration maxCreateConnectionTime = NO_TIMEOUT;
        private Duration maxAcquireTime = NO_TIMEOUT;
        private Duration maxLifeTime = NO_TIMEOUT;
        private PoolMetricsRecorder metricsRecorder = new SimplePoolMetricsRecorder();
        @Nullable
        private String name;
        private boolean registerJmx;
        @Nullable
        private String validationQuery;
        private ValidationDepth validationDepth = ValidationDepth.LOCAL;

        private Builder() {
        }

        public Builder acquireRetry(int retryAttempts) {
            if (retryAttempts < 0) {
                throw new IllegalArgumentException("retryAttempts must not be negative");
            }
            this.acquireRetry = retryAttempts;
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = Assert.requireNonNull(clock, "Clock must not be null");
            return this;
        }

        public Builder customizer(Consumer<PoolBuilder<Connection, ? extends PoolConfig<? extends Connection>>> customizer) {
            this.customizer = Assert.requireNonNull(customizer, "PoolBuilder customizer must not be null");
            return this;
        }

        public Builder initialSize(int initialSize) {
            if (initialSize < 0) {
                throw new IllegalArgumentException("Initial pool size must be equal greater zero");
            }
            this.initialSize = initialSize;
            return this;
        }

        public Builder maxSize(int maxSize) {
            if (maxSize < 1) {
                throw new IllegalArgumentException("Maximal pool size must be greater zero");
            }
            this.maxSize = maxSize;
            return this;
        }

        public Builder maxIdleTime(@Nullable Duration maxIdleTime) {
            this.maxIdleTime = Builder.applyDefault(maxIdleTime);
            return this;
        }

        public Builder maxCreateConnectionTime(@Nullable Duration maxCreateConnectionTime) {
            this.maxCreateConnectionTime = Builder.applyDefault(maxCreateConnectionTime);
            return this;
        }

        public Builder maxAcquireTime(@Nullable Duration maxAcquireTime) {
            this.maxAcquireTime = Builder.applyDefault(maxAcquireTime);
            return this;
        }

        public Builder maxLifeTime(Duration maxLifeTime) {
            this.maxLifeTime = Builder.applyDefault(maxLifeTime);
            return this;
        }

        public Builder metricsRecorder(PoolMetricsRecorder recorder) {
            this.metricsRecorder = Assert.requireNonNull(recorder, "PoolMetricsRecorder must not be null");
            return this;
        }

        public Builder name(String name) {
            this.name = Assert.requireNonNull(name, "name must not be null");
            return this;
        }

        public Builder registerJmx(boolean registerJmx) {
            this.registerJmx = registerJmx;
            return this;
        }

        public Builder validationDepth(ValidationDepth validationDepth) {
            this.validationDepth = Assert.requireNonNull(validationDepth, "ValidationQuery must not be null");
            return this;
        }

        public Builder connectionFactory(ConnectionFactory connectionFactory) {
            this.connectionFactory = Assert.requireNonNull(connectionFactory, "ConnectionFactory must not be null");
            return this;
        }

        public Builder validationQuery(String validationQuery) {
            this.validationQuery = Assert.requireNonNull(validationQuery, "ValidationQuery must not be null");
            return this;
        }

        public ConnectionPoolConfiguration build() {
            this.applyDefaults();
            this.validate();
            return new ConnectionPoolConfiguration(this.acquireRetry, this.connectionFactory, this.clock, this.customizer, this.initialSize, this.maxSize, this.maxIdleTime, this.maxCreateConnectionTime, this.maxAcquireTime, this.maxLifeTime, this.metricsRecorder, this.name, this.registerJmx, this.validationDepth, this.validationQuery);
        }

        private void applyDefaults() {
            if (this.initialSize == null && this.maxSize == null) {
                this.initialSize = 10;
                this.maxSize = 10;
            } else if (this.initialSize == null) {
                this.initialSize = Math.min(10, this.maxSize);
            } else if (this.maxSize == null) {
                this.maxSize = Math.max(10, this.initialSize);
            }
        }

        private void validate() {
            Assert.requireNonNull(this.connectionFactory, "connectionFactory must not be null");
            if (this.registerJmx) {
                Assert.requireNonNull(this.name, "name must not be null when registering to JMX");
            }
            if (0 > this.initialSize) {
                throw new IllegalArgumentException("initialSize must be non-negative");
            }
            if (this.initialSize > this.maxSize) {
                throw new IllegalArgumentException("maxSize must be greater than or equal to initialSize");
            }
        }

        public String toString() {
            return "Builder{acquireRetry='" + this.acquireRetry + '\'' + ", connectionFactory='" + this.connectionFactory + '\'' + ", clock='" + this.clock + '\'' + ", initialSize='" + this.initialSize + '\'' + ", maxSize='" + this.maxSize + '\'' + ", maxIdleTime='" + this.maxIdleTime + '\'' + ", maxCreateConnectionTime='" + this.maxCreateConnectionTime + '\'' + ", maxAcquireTime='" + this.maxAcquireTime + '\'' + ", maxLifeTime='" + this.maxLifeTime + '\'' + ", metricsRecorder='" + this.metricsRecorder + '\'' + ", name='" + this.name + '\'' + ", registerJmx='" + this.registerJmx + '\'' + ", validationDepth='" + this.validationDepth + '\'' + ", validationQuery='" + this.validationQuery + '\'' + '}';
        }

        private static Duration applyDefault(@Nullable Duration duration) {
            return duration == null ? NO_TIMEOUT : duration;
        }
    }
}

