/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.pool;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.ValidationDepth;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class Validation {
    Validation() {
    }

    static Mono<Void> validate(Connection connection, String validationQuery) {
        return Flux.from((Publisher)connection.createStatement(validationQuery).execute()).flatMap(it -> it.map((row, rowMetadata) -> Optional.ofNullable(row.get(0)))).then();
    }

    static Mono<Void> validate(Connection connection, ValidationDepth depth) {
        return Flux.from((Publisher)connection.validate(depth)).handle((state, sink) -> {
            if (state.booleanValue()) {
                sink.complete();
                return;
            }
            sink.error((Throwable)new R2dbcNonTransientResourceException("Connection validation failed"));
        }).then();
    }
}

