/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.util;

import io.r2dbc.mssql.util.Assert;

public class Version
implements Comparable<Version> {
    private static final String VERSION_PARSE_ERROR = "Invalid version string! Could not parse segment [%s] within [%s].";
    private final int major;
    private final int minor;
    private final int bugfix;
    private final int build;

    public Version(int ... parts) {
        Assert.notNull((Object)parts, "Parts must not be null!");
        Assert.isTrue(parts.length > 0 && parts.length < 5, "Parts must contain 1 to 5 segments!");
        this.major = parts[0];
        this.minor = parts.length > 1 ? parts[1] : 0;
        this.bugfix = parts.length > 2 ? parts[2] : 0;
        this.build = parts.length > 3 ? parts[3] : 0;
        Assert.isTrue(this.major >= 0, "Major version must be greater or equal zero!");
        Assert.isTrue(this.minor >= 0, "Minor version must be greater or equal zero!");
        Assert.isTrue(this.bugfix >= 0, "Bugfix version must be greater or equal zero!");
        Assert.isTrue(this.build >= 0, "Build version must be greater or equal zero!");
    }

    public static Version parse(String version) {
        String[] parts = version.trim().split("\\.");
        int[] intParts = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String input;
            String string = input = i == parts.length - 1 ? parts[i].replaceAll("\\D.*", "") : parts[i];
            if (input.isEmpty()) continue;
            try {
                intParts[i] = Integer.parseInt(input);
                continue;
            }
            catch (IllegalArgumentException o_O) {
                throw new IllegalArgumentException(String.format(VERSION_PARSE_ERROR, input, version), o_O);
            }
        }
        return new Version(intParts);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getBugfix() {
        return this.bugfix;
    }

    public boolean isGreaterThan(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean isGreaterThanOrEqualTo(Version version) {
        return this.compareTo(version) >= 0;
    }

    public boolean is(Version version) {
        return this.equals(version);
    }

    public boolean isLessThan(Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean isLessThanOrEqualTo(Version version) {
        return this.compareTo(version) <= 0;
    }

    @Override
    public int compareTo(Version that) {
        if (that == null) {
            return 1;
        }
        if (this.major != that.major) {
            return this.major - that.major;
        }
        if (this.minor != that.minor) {
            return this.minor - that.minor;
        }
        if (this.bugfix != that.bugfix) {
            return this.bugfix - that.bugfix;
        }
        if (this.build != that.build) {
            return this.build - that.build;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version that = (Version)obj;
        return this.major == that.major && this.minor == that.minor && this.bugfix == that.bugfix && this.build == that.build;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.major;
        result += 31 * this.minor;
        result += 31 * this.bugfix;
        return result += 31 * this.build;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.major).append(".").append(this.minor <= 9 ? "0" : "").append(this.minor);
        if (this.build != 0 || this.bugfix != 0) {
            builder.append('.').append(this.bugfix);
        }
        if (this.build != 0) {
            builder.append('.').append(this.build);
        }
        return builder.toString();
    }
}

