/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.type;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.tds.ProtocolException;
import io.r2dbc.mssql.message.type.LengthStrategy;
import io.r2dbc.mssql.message.type.TypeInformation;

public final class PlpLength {
    public static final long PLP_NULL = -1L;
    public static final long UNKNOWN_PLP_LEN = -2L;
    private final long length;
    private final boolean isNull;

    private PlpLength(long length, boolean isNull) {
        this.length = length;
        this.isNull = isNull;
    }

    public static PlpLength unknown() {
        return PlpLength.of(-2L, false);
    }

    public static PlpLength nullLength() {
        return PlpLength.of(0L, true);
    }

    public static PlpLength of(long length) {
        return PlpLength.of(length, false);
    }

    public static PlpLength of(long length, boolean isNull) {
        return new PlpLength(length, isNull);
    }

    public static PlpLength decode(ByteBuf buffer, TypeInformation type) {
        if (type.getLengthStrategy() == LengthStrategy.PARTLENTYPE) {
            long length = Decode.uLongLong(buffer);
            return PlpLength.of(length == -1L ? 0L : length, length == -1L);
        }
        throw ProtocolException.invalidTds("Cannot parse using " + (Object)((Object)type.getLengthStrategy()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canDecode(ByteBuf buffer, TypeInformation type) {
        int readerIndex = buffer.readerIndex();
        try {
            boolean bl = PlpLength.doCanDecode(buffer, type);
            return bl;
        }
        finally {
            buffer.readerIndex(readerIndex);
        }
    }

    public void encode(ByteBuf buffer) {
        if (this.isNull()) {
            Encode.uLongLong(buffer, -1L);
        } else {
            Encode.uLongLong(buffer, this.getLength());
        }
    }

    private static boolean doCanDecode(ByteBuf buffer, TypeInformation type) {
        if (type.getLengthStrategy() == LengthStrategy.PARTLENTYPE) {
            return buffer.readableBytes() >= 8;
        }
        throw ProtocolException.invalidTds("Cannot parse value LengthDescriptor");
    }

    public long getLength() {
        return this.length;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public boolean isUnknown() {
        return this.length == -2L;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [length=").append(this.length);
        sb.append(", isNull=").append(this.isNull);
        sb.append(']');
        return sb.toString();
    }
}

