/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.tds.ProtocolException;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.mssql.util.StringUtils;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class Identifier {
    @Nullable
    private final String serverName;
    @Nullable
    private final String databaseName;
    @Nullable
    private final String schemaName;
    private final String objectName;

    private Identifier(@Nullable String serverName, @Nullable String databaseName, @Nullable String schemaName, String objectName) {
        this.serverName = serverName;
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.objectName = Assert.requireNonNull(objectName, "Object name must not be null");
    }

    public static Identifier objectName(String objectName) {
        return new Identifier(null, null, null, objectName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Identifier decode(ByteBuf buffer) {
        Assert.requireNonNull(buffer, "Buffer must not be null");
        int parts = Decode.uByte(buffer);
        if (1 > parts || parts > 4) {
            throw ProtocolException.invalidTds(String.format("Identifier must contain one to four parts, got: %d", parts));
        }
        String[] nameParts = new String[parts];
        for (int i = 0; i < parts; ++i) {
            nameParts[i] = Decode.unicodeUString(buffer);
        }
        String serverName = null;
        String databaseName = null;
        String schemaName = null;
        String objectName = nameParts[parts - 1];
        if (parts >= 2) {
            schemaName = nameParts[parts - 2];
        }
        if (parts >= 3) {
            databaseName = nameParts[parts - 3];
        }
        if (parts == 4) {
            serverName = nameParts[parts - 4];
        }
        return new Identifier(serverName, databaseName, schemaName, objectName);
    }

    static boolean canDecodeAndSkipBytes(ByteBuf buffer) {
        Assert.requireNonNull(buffer, "Buffer must not be null");
        if (!buffer.isReadable()) {
            return false;
        }
        int parts = Decode.uByte(buffer);
        String[] nameParts = new String[parts];
        for (int i = 0; i < parts; ++i) {
            if (1 > buffer.readableBytes()) {
                return false;
            }
            int length = buffer.readUnsignedShortLE() * 2;
            if (length > buffer.readableBytes()) {
                return false;
            }
            buffer.skipBytes(length);
        }
        return true;
    }

    @Nullable
    public String getServerName() {
        return this.serverName;
    }

    @Nullable
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String asEscapedString() {
        StringBuilder fullName = new StringBuilder(256);
        if (StringUtils.hasText(this.serverName)) {
            fullName.append("[" + this.serverName + "].");
        }
        if (StringUtils.hasText(this.databaseName)) {
            fullName.append("[" + this.databaseName + "].");
        } else {
            Assert.state(StringUtils.isEmpty(this.serverName), "Server name must be empty");
        }
        if (StringUtils.hasText(this.schemaName)) {
            fullName.append("[" + this.schemaName + "].");
        } else if (StringUtils.hasText(this.databaseName)) {
            fullName.append('.');
        }
        fullName.append("[" + this.objectName + "]");
        return fullName.toString();
    }

    public String toString() {
        return this.asEscapedString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Identifier)) {
            return false;
        }
        Identifier that = (Identifier)o;
        return Objects.equals(this.serverName, that.serverName) && Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.objectName, that.objectName);
    }

    public int hashCode() {
        return Objects.hash(this.serverName, this.databaseName, this.schemaName, this.objectName);
    }

    public static class Builder {
        @Nullable
        private String serverName;
        @Nullable
        private String databaseName;
        @Nullable
        private String schemaName;
        @Nullable
        private String objectName;

        private Builder() {
        }

        public Builder objectName(String objectName) {
            this.objectName = Assert.requireNonNull(objectName, "Object name must not be null");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = Assert.requireNonNull(schemaName, "Schema name must not be null");
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.databaseName = Assert.requireNonNull(databaseName, "Database name must not be null");
            return this;
        }

        public Builder serverName(String serverName) {
            this.serverName = Assert.requireNonNull(serverName, "Server name must not be null");
            return this;
        }

        public Identifier build() {
            Assert.notNull((Object)this.objectName, "Object name must not be null");
            Assert.state(StringUtils.isEmpty(this.serverName) || !StringUtils.isEmpty(this.databaseName), "Server name must be either null or both, server name and database name must be provided");
            return new Identifier(this.serverName, this.databaseName, this.schemaName, this.objectName);
        }
    }
}

