/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.r2dbc.mssql.codec.Decodable;
import io.r2dbc.mssql.message.token.Identifier;
import io.r2dbc.mssql.message.type.TypeInformation;
import io.r2dbc.mssql.util.Assert;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public class Column
implements Decodable {
    private final int index;
    private final String name;
    private final TypeInformation type;
    @Nullable
    private final Identifier table;

    public Column(int index, String name, TypeInformation type) {
        this(index, name, type, null);
    }

    public Column(int index, String name, TypeInformation type, @Nullable Identifier table) {
        this.index = index;
        this.name = Assert.requireNonNull(name, "Column name must not be null");
        this.type = Assert.requireNonNull(type, "Type information must not be null");
        this.table = table;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TypeInformation getType() {
        return this.type;
    }

    @Nullable
    public Identifier getTable() {
        return this.table;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [name='").append(this.name).append('\"');
        sb.append(", type=").append(this.type);
        sb.append(", table=").append(this.table);
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column column = (Column)o;
        return this.index == column.index && Objects.equals(this.name, column.name) && Objects.equals(this.table, column.table);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.name, this.table);
    }
}

