/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.header;

import io.r2dbc.mssql.util.Assert;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class Status {
    private static final Status[] STATUS_CACHE = new Status[255];
    private final byte value;

    private Status(Set<StatusBit> statusBits) {
        this.value = Status.getStatusValue(statusBits);
    }

    public static Status empty() {
        return Status.fromBitmask((byte)0);
    }

    public static Status fromBitmask(byte bitmask) {
        return STATUS_CACHE[bitmask - -128];
    }

    private static Status fromBitmask0(byte bitmask) {
        EnumSet<StatusBit> result = EnumSet.noneOf(StatusBit.class);
        for (StatusBit status : StatusBit.values()) {
            if ((bitmask & status.getBits()) == 0) continue;
            result.add(status);
        }
        return new Status(result);
    }

    public static Status of(StatusBit bit) {
        Assert.requireNonNull(bit, "StatusBit must not be null");
        return Status.fromBitmask(bit.bits);
    }

    public static Status of(StatusBit bit, StatusBit ... other) {
        Assert.requireNonNull(bit, "StatusBit must not be null");
        Assert.requireNonNull(other, "StatusBits must not be null");
        byte result = bit.bits;
        for (StatusBit s : other) {
            result = (byte)(result | s.bits);
        }
        return Status.fromBitmask(result);
    }

    public Status and(StatusBit bit) {
        if (this.is(bit)) {
            return this;
        }
        byte mask = (byte)(this.getValue() | bit.bits);
        return Status.fromBitmask(mask);
    }

    public Status not(StatusBit bit) {
        if (!this.is(bit)) {
            return this;
        }
        byte mask = this.getValue();
        mask = (byte)(mask & ~bit.bits);
        return Status.fromBitmask(mask);
    }

    public boolean is(StatusBit bit) {
        return (this.value & bit.bits) != 0;
    }

    public byte getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Status)) {
            return false;
        }
        Status status = (Status)o;
        return this.value == status.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    private static byte getStatusValue(Collection<StatusBit> statusBits) {
        byte result = 0;
        for (StatusBit s : statusBits) {
            result = (byte)(result | s.getBits());
        }
        return result;
    }

    public String toString() {
        return Integer.toHexString(this.value);
    }

    static {
        for (byte b = -128; b < 127; b = (byte)(b + 1)) {
            Status.STATUS_CACHE[b - -128] = Status.fromBitmask0(b);
        }
    }

    public static enum StatusBit {
        NORMAL(0),
        EOM(1),
        IGNORE(2),
        RESET_CONNECTION(8),
        RESET_CONNECTION_SKIP_TRAN(16);

        private final byte bits;

        private StatusBit(int bits) {
            this.bits = Integer.valueOf(bits).byteValue();
        }

        public int getBits() {
            return this.bits;
        }
    }
}

