/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.codec.AbstractCodec;
import io.r2dbc.mssql.codec.ByteArray;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.LocalDateCodec;
import io.r2dbc.mssql.codec.LocalTimeCodec;
import io.r2dbc.mssql.codec.RpcEncoding;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TdsDataType;
import io.r2dbc.mssql.message.type.TypeInformation;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

final class OffsetDateTimeCodec
extends AbstractCodec<OffsetDateTime> {
    public static final OffsetDateTimeCodec INSTANCE = new OffsetDateTimeCodec();
    private static final byte[] NULL = ByteArray.fromEncoded(alloc -> RpcEncoding.encodeTemporalNull(alloc, SqlServerType.DATETIMEOFFSET, 7));

    private OffsetDateTimeCodec() {
        super(OffsetDateTime.class);
    }

    @Override
    Encoded doEncode(ByteBufAllocator allocator, RpcParameterContext context, OffsetDateTime value) {
        return new RpcEncoding.HintedEncoded(TdsDataType.DATETIMEOFFSETN, SqlServerType.DATETIMEOFFSET, () -> {
            ByteBuf buffer = allocator.buffer(12);
            Encode.asByte(buffer, 7);
            Encode.asByte(buffer, 10);
            OffsetDateTimeCodec.doEncode(buffer, value.minusSeconds(value.getOffset().getTotalSeconds()));
            return buffer;
        });
    }

    @Override
    public boolean canEncodeNull(SqlServerType serverType) {
        return serverType == SqlServerType.DATETIMEOFFSET;
    }

    @Override
    public Encoded doEncodeNull(ByteBufAllocator allocator) {
        return RpcEncoding.wrap(NULL, SqlServerType.DATETIMEOFFSET);
    }

    @Override
    public Encoded encodeNull(ByteBufAllocator allocator, SqlServerType serverType) {
        return RpcEncoding.encodeTemporalNull(allocator, serverType, 7);
    }

    @Override
    boolean doCanDecode(TypeInformation typeInformation) {
        return typeInformation.getServerType() == SqlServerType.DATETIMEOFFSET;
    }

    @Override
    OffsetDateTime doDecode(ByteBuf buffer, Length length, TypeInformation type, Class<? extends OffsetDateTime> valueType) {
        if (length.isNull()) {
            return null;
        }
        Object localTime = LocalTimeCodec.INSTANCE.doDecode(buffer, length, type, LocalTime.class);
        Object localDate = LocalDateCodec.INSTANCE.doDecode(buffer, length, type, LocalDate.class);
        short localMinutesOffset = Decode.smallInt(buffer);
        ZoneOffset offset = ZoneOffset.ofTotalSeconds(localMinutesOffset * 60);
        return OffsetDateTime.of(((LocalTime)localTime).atDate((LocalDate)localDate), offset).plusMinutes(localMinutesOffset);
    }

    static void doEncode(ByteBuf buffer, OffsetDateTime value) {
        LocalTimeCodec.doEncode(buffer, 7, value.toLocalTime());
        LocalDateCodec.encode(buffer, value.toLocalDate());
        int localMinutesOffset = value.getOffset().getTotalSeconds() / 60;
        Encode.smallInt(buffer, localMinutesOffset);
    }
}

