/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.r2dbc.mssql.codec.AbstractNumericCodec;
import io.r2dbc.mssql.codec.ByteArray;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.RpcEncoding;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TdsDataType;
import io.r2dbc.mssql.message.type.TypeInformation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Supplier;

final class DecimalCodec
extends AbstractNumericCodec<BigDecimal> {
    private static final BigInteger MAX_VALUE = new BigInteger("99999999999999999999999999999999999999");
    static final DecimalCodec INSTANCE = new DecimalCodec();
    private static final int MAX_PRECISION = 38;
    private static final byte[] NULL = ByteArray.fromBuffer(alloc -> {
        ByteBuf buffer = alloc.buffer(4);
        Encode.asByte(buffer, 17);
        Encode.asByte(buffer, SqlServerType.DECIMAL.getMaxLength());
        Encode.asByte(buffer, 0);
        Encode.asByte(buffer, 0);
        return buffer;
    });

    private DecimalCodec() {
        super(BigDecimal.class, BigDecimal::valueOf);
    }

    @Override
    Encoded doEncode(ByteBufAllocator allocator, RpcParameterContext context, BigDecimal value) {
        BigDecimal valueToUse = value.scale() < 0 ? value.setScale(0) : value;
        if (DecimalCodec.exceedsMaxPrecisionOrScale(valueToUse)) {
            throw new IllegalArgumentException("One or more values is out of range of values for the DECIMAL SQL type");
        }
        return new DecimalEncoded(TdsDataType.DECIMALN, () -> {
            ByteBuf buffer = RpcEncoding.prepareBuffer(allocator, TdsDataType.DECIMALN.getLengthStrategy(), 17, SqlServerType.DECIMAL.getMaxLength());
            DecimalCodec.encodeBigDecimal(buffer, valueToUse);
            return buffer;
        }, 38, valueToUse.scale());
    }

    @Override
    Encoded doEncodeNull(ByteBufAllocator allocator) {
        return new DecimalEncoded(TdsDataType.DECIMALN, () -> Unpooled.wrappedBuffer((byte[])NULL), 38, 0);
    }

    @Override
    BigDecimal doDecode(ByteBuf buffer, Length length, TypeInformation type, Class<? extends BigDecimal> valueType) {
        if (length.isNull()) {
            return null;
        }
        if (type.getServerType() == SqlServerType.DECIMAL || type.getServerType() == SqlServerType.NUMERIC) {
            return DecimalCodec.decodeDecimal(buffer, length.getLength(), type.getScale());
        }
        return super.doDecode(buffer, length, type, valueType);
    }

    private static void encodeBigDecimal(ByteBuf buffer, BigDecimal value) {
        boolean isNegative = value.signum() < 0;
        BigInteger valueToUse = value.unscaledValue();
        if (isNegative) {
            valueToUse = valueToUse.negate();
        }
        byte[] unscaledBytes = valueToUse.toByteArray();
        Encode.asByte(buffer, value.scale());
        Encode.asByte(buffer, unscaledBytes.length + 1);
        Encode.asByte(buffer, isNegative ? 0 : 1);
        for (int i = unscaledBytes.length - 1; i >= 0; --i) {
            Encode.asByte(buffer, unscaledBytes[i]);
        }
    }

    private static boolean exceedsMaxPrecisionOrScale(BigDecimal value) {
        if (value.scale() > 38) {
            return true;
        }
        BigInteger bi = value.unscaledValue();
        if (value.signum() < 0) {
            bi = bi.negate();
        }
        return bi.compareTo(MAX_VALUE) > 0;
    }

    static class DecimalEncoded
    extends RpcEncoding.HintedEncoded {
        private final int length;
        private final int scale;

        DecimalEncoded(TdsDataType dataType, Supplier<ByteBuf> value, int length, int scale) {
            super(dataType, SqlServerType.DECIMAL, value);
            this.length = length;
            this.scale = scale;
        }

        @Override
        public String getFormalType() {
            return super.getFormalType() + "(" + this.length + "," + this.scale + ")";
        }
    }
}

