/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.r2dbc.mssql.codec.ByteArray;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.codec.PlpEncodedCharacters;
import io.r2dbc.mssql.codec.RpcDirection;
import io.r2dbc.mssql.codec.RpcEncoding;
import io.r2dbc.mssql.codec.RpcParameterContext;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.tds.ServerCharset;
import io.r2dbc.mssql.message.type.Collation;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TdsDataType;
import io.r2dbc.spi.Clob;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

class CharacterEncoder {
    private static final byte[] NULL = ByteArray.fromBuffer(alloc -> {
        ByteBuf buffer = alloc.buffer(8);
        Encode.uShort(buffer, 8000);
        Collation.RAW.encode(buffer);
        Encode.uShort(buffer, -1);
        return buffer;
    });

    CharacterEncoder() {
    }

    static Encoded encodeNull(SqlServerType serverType) {
        if (CharacterEncoder.isNational(serverType)) {
            return new VarcharEncoded(TdsDataType.NVARCHAR, () -> Unpooled.wrappedBuffer((byte[])NULL));
        }
        return new NvarcharEncoded(TdsDataType.NVARCHAR, () -> Unpooled.wrappedBuffer((byte[])NULL));
    }

    static Encoded encodeBigVarchar(ByteBufAllocator allocator, RpcDirection direction, @Nullable SqlServerType serverType, Collation collation, boolean sendStringParametersAsUnicode, @Nullable CharSequence value) {
        int initialCapacity = (value != null ? value.length() * 2 : 0) + 7;
        Function<Boolean, ByteBuf> encoder = unicode -> {
            ByteBuf buffer = allocator.buffer(initialCapacity);
            CharacterEncoder.encodeBigVarchar(buffer, direction, collation, unicode, value);
            return buffer;
        };
        if (CharacterEncoder.isNational(serverType) || sendStringParametersAsUnicode) {
            return new NvarcharEncoded(TdsDataType.NVARCHAR, () -> (ByteBuf)encoder.apply(true));
        }
        return new VarcharEncoded(TdsDataType.BIGVARCHAR, Encoded.ofLengthAware(initialCapacity, i -> (ByteBuf)encoder.apply(false)));
    }

    static void encodeBigVarchar(ByteBuf buffer, RpcDirection direction, Collation collation, boolean sendStringParametersAsUnicode, @Nullable CharSequence value) {
        boolean usePLP;
        ByteBuf characterData = CharacterEncoder.encodeCharSequence(buffer.alloc(), collation, sendStringParametersAsUnicode, value);
        int valueLength = characterData.readableBytes();
        boolean isShortValue = valueLength <= 8000;
        boolean isNull = value == null;
        boolean bl = usePLP = !isShortValue || direction == RpcDirection.OUT;
        if (usePLP) {
            Encode.uShort(buffer, -1);
            collation.encode(buffer);
            if (isNull) {
                Encode.uLongLong(buffer, -1L);
            } else if (-1 == valueLength) {
                Encode.uLongLong(buffer, -2L);
            } else {
                Encode.uLongLong(buffer, valueLength);
            }
            if (!isNull && valueLength > 0) {
                Encode.asInt(buffer, valueLength);
                buffer.writeBytes(characterData);
                characterData.release();
            }
            Encode.asInt(buffer, 0);
        } else {
            Encode.uShort(buffer, 8000);
            collation.encode(buffer);
            Encode.uShort(buffer, valueLength);
            if (0 != valueLength) {
                buffer.writeBytes(characterData);
                characterData.release();
            }
        }
    }

    private static ByteBuf encodeCharSequence(ByteBufAllocator alloc, Collation collation, boolean sendStringParametersAsUnicode, @Nullable CharSequence value) {
        if (value == null || value.length() == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (sendStringParametersAsUnicode) {
            ByteBuf buffer = alloc.buffer(value.length() * 2);
            Encode.rpcString(buffer, value);
            return buffer;
        }
        ByteBuf buffer = alloc.buffer((int)((double)value.length() * 1.5));
        Encode.rpcString(buffer, value, collation.getCharset());
        return buffer;
    }

    static Encoded encodePlp(ByteBufAllocator allocator, @Nullable SqlServerType serverType, RpcParameterContext.CharacterValueContext valueContext, CharSequence value) {
        Flux binaryStream = Flux.just((Object)value).map(it -> CharacterEncoder.encodeCharSequence(allocator, CharacterEncoder.isNational(serverType), valueContext, it));
        return new PlpEncodedCharacters(CharacterEncoder.getPlpType(serverType, valueContext), valueContext.getCollation(), allocator, (Publisher<ByteBuf>)binaryStream, () -> {});
    }

    private static boolean isNational(@Nullable SqlServerType serverType) {
        return serverType != null && serverType.getCategory() == SqlServerType.Category.NCHARACTER;
    }

    static Encoded encodePlp(ByteBufAllocator allocator, @Nullable SqlServerType serverType, RpcParameterContext.CharacterValueContext valueContext, Clob value) {
        Flux binaryStream = Flux.from((Publisher)value.stream()).map(it -> CharacterEncoder.encodeCharSequence(allocator, CharacterEncoder.isNational(serverType), valueContext, it));
        return new PlpEncodedCharacters(CharacterEncoder.getPlpType(serverType, valueContext), valueContext.getCollation(), allocator, (Publisher<ByteBuf>)binaryStream, () -> Mono.from((Publisher)value.discard()).toFuture());
    }

    private static SqlServerType getPlpType(@Nullable SqlServerType serverType, RpcParameterContext.CharacterValueContext valueContext) {
        return CharacterEncoder.isNational(serverType) || valueContext.isSendStringParametersAsUnicode() ? SqlServerType.NVARCHARMAX : SqlServerType.VARCHARMAX;
    }

    private static ByteBuf encodeCharSequence(ByteBufAllocator allocator, boolean isNational, RpcParameterContext.CharacterValueContext valueContext, CharSequence it) {
        return ByteBufUtil.encodeString((ByteBufAllocator)allocator, (CharBuffer)CharBuffer.wrap(it), (Charset)(isNational || valueContext.isSendStringParametersAsUnicode() ? ServerCharset.UNICODE.charset() : valueContext.getCollation().getCharset()));
    }

    private static class VarcharEncoded
    extends RpcEncoding.HintedEncoded {
        private static final String FORMAL_TYPE = (Object)((Object)SqlServerType.VARCHAR) + "(" + 8000 + ")";

        VarcharEncoded(TdsDataType dataType, Supplier<ByteBuf> value) {
            super(dataType, SqlServerType.NVARCHAR, value);
        }

        @Override
        public String getFormalType() {
            return FORMAL_TYPE;
        }
    }

    private static class NvarcharEncoded
    extends RpcEncoding.HintedEncoded {
        private static final String FORMAL_TYPE = (Object)((Object)SqlServerType.NVARCHAR) + "(" + 4000 + ")";

        NvarcharEncoded(TdsDataType dataType, Supplier<ByteBuf> value) {
            super(dataType, SqlServerType.NVARCHAR, value);
        }

        @Override
        public String getFormalType() {
            return FORMAL_TYPE;
        }
    }
}

