/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.client.ssl;

import io.r2dbc.mssql.util.Assert;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.regex.Pattern;

class HostNamePredicate
implements Predicate<String> {
    private final Pattern hostnamePattern;

    private HostNamePredicate(Pattern hostnamePattern) {
        this.hostnamePattern = hostnamePattern;
    }

    public static HostNamePredicate of(String expectedHostname) {
        String[] segments;
        Assert.notNull((Object)expectedHostname, "Expected hostname must not be null");
        StringBuilder builder = new StringBuilder();
        for (String segment : segments = expectedHostname.toLowerCase(Locale.ENGLISH).split("\\.")) {
            if (builder.length() != 0) {
                builder.append("\\.");
            }
            StringBuilder rewrittenSegment = new StringBuilder(segment.length());
            StringBuilder part = new StringBuilder(segment.length());
            for (char c : segment.toCharArray()) {
                if (c == '*') {
                    if (part.length() != 0) {
                        rewrittenSegment.append(Pattern.quote(part.toString()));
                        part = new StringBuilder(segment.length());
                    }
                    rewrittenSegment.append("([^\\.]*)");
                    continue;
                }
                part.append(c);
            }
            if (part.length() != 0) {
                rewrittenSegment.append(Pattern.quote(part.toString()));
            }
            builder.append((CharSequence)rewrittenSegment);
        }
        return new HostNamePredicate(Pattern.compile(builder.toString()));
    }

    @Override
    public boolean test(String s) {
        return this.hostnamePattern.matcher(s).matches();
    }
}

