/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.ConnectionOptions;
import io.r2dbc.mssql.ExceptionFactory;
import io.r2dbc.mssql.MssqlStatement;
import io.r2dbc.mssql.client.Client;
import io.r2dbc.mssql.message.Message;
import io.r2dbc.mssql.util.Assert;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.annotation.Nullable;

abstract class MssqlStatementSupport
implements MssqlStatement {
    static final int FETCH_SIZE = 128;
    static final int FETCH_UNCONFIGURED = -1;
    private final boolean preferCursoredExecution;
    @Nullable
    private String[] generatedColumns;
    private int fetchSize = -1;

    MssqlStatementSupport(boolean preferCursoredExecution) {
        this.preferCursoredExecution = preferCursoredExecution;
    }

    int getEffectiveFetchSize() {
        if (this.preferCursoredExecution) {
            return this.fetchSize == -1 ? 128 : this.fetchSize;
        }
        return this.fetchSize == -1 ? 0 : this.fetchSize;
    }

    @Nullable
    String[] getGeneratedColumns() {
        return this.generatedColumns;
    }

    @Override
    public MssqlStatementSupport returnGeneratedValues(String ... columns) {
        Assert.requireNonNull(columns, "columns must not be null");
        this.generatedColumns = columns;
        return this;
    }

    @Override
    public MssqlStatementSupport fetchSize(int fetchSize) {
        Assert.isTrue(fetchSize >= 0, "Fetch size must be greater or equal to zero");
        this.fetchSize = fetchSize;
        return this;
    }

    Flux<Message> potentiallyAttachTimeout(Flux<Message> exchange, ConnectionOptions connectionOptions, Client client, String sql) {
        Duration statementTimeout = connectionOptions.getStatementTimeout();
        if (statementTimeout.isZero()) {
            return exchange;
        }
        Mono timeout = Mono.delay((Duration)statementTimeout, (Scheduler)Schedulers.parallel()).onErrorReturn((Object)0L);
        return exchange.timeout((Publisher)timeout).onErrorResume(TimeoutException.class, e -> client.attention().then(Mono.error((Throwable)((Object)new ExceptionFactory.MssqlStatementTimeoutException(String.format("Statement did not yield a result within %dms", statementTimeout.toMillis()), sql)))));
    }
}

