/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.MssqlColumnMetadata;
import io.r2dbc.mssql.NamedCollectionSupport;
import io.r2dbc.mssql.codec.Codecs;
import io.r2dbc.mssql.message.token.ReturnValue;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.spi.OutParametersMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.util.annotation.Nullable;

final class MssqlReturnValuesMetadata
extends NamedCollectionSupport<ReturnValue>
implements OutParametersMetadata,
Collection<String> {
    private final Codecs codecs;
    @Nullable
    private Map<ReturnValue, MssqlColumnMetadata> metadataCache;

    MssqlReturnValuesMetadata(Codecs codecs, ReturnValue[] returnValues) {
        super(returnValues, MssqlReturnValuesMetadata.toMap(returnValues, ReturnValue::getParameterName), ReturnValue::getParameterName, "return value");
        this.codecs = Assert.requireNonNull(codecs, "Codecs must not be null");
    }

    public static MssqlReturnValuesMetadata create(Codecs codecs, List<ReturnValue> returnValues) {
        Assert.notNull(returnValues, "ReturnValues must not be null");
        return new MssqlReturnValuesMetadata(codecs, returnValues.toArray(new ReturnValue[0]));
    }

    public MssqlColumnMetadata getParameterMetadata(int index) {
        if (this.metadataCache == null) {
            this.metadataCache = new HashMap<ReturnValue, MssqlColumnMetadata>();
        }
        return this.metadataCache.computeIfAbsent((ReturnValue)this.get(index), returnValue -> new MssqlColumnMetadata(returnValue.asDecodable(), this.codecs));
    }

    public MssqlColumnMetadata getParameterMetadata(String identifier) {
        if (this.metadataCache == null) {
            this.metadataCache = new HashMap<ReturnValue, MssqlColumnMetadata>();
        }
        return this.metadataCache.computeIfAbsent((ReturnValue)this.get(identifier), returnValue -> new MssqlColumnMetadata(returnValue.asDecodable(), this.codecs));
    }

    public List<MssqlColumnMetadata> getParameterMetadatas() {
        if (this.metadataCache == null) {
            this.metadataCache = new HashMap<ReturnValue, MssqlColumnMetadata>();
        }
        ArrayList<MssqlColumnMetadata> metadatas = new ArrayList<MssqlColumnMetadata>(this.getCount());
        for (int i = 0; i < this.getCount(); ++i) {
            MssqlColumnMetadata columnMetadata = this.metadataCache.computeIfAbsent((ReturnValue)this.get(i), returnValue -> new MssqlColumnMetadata(returnValue.asDecodable(), this.codecs));
            metadatas.add(columnMetadata);
        }
        return metadatas;
    }

    @Override
    ReturnValue find(String name) {
        ReturnValue returnValue = (ReturnValue)super.find(name);
        if (returnValue == null && !name.startsWith("@")) {
            return (ReturnValue)super.find("@" + name);
        }
        return returnValue;
    }
}

