/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql;

import io.r2dbc.mssql.util.StringUtils;
import reactor.util.annotation.Nullable;

public final class ErrorDetails {
    private final String message;
    private final long number;
    private final int state;
    private final int infoClass;
    @Nullable
    private final String serverName;
    @Nullable
    private final String procName;
    private final long lineNumber;

    public ErrorDetails(String message, long number, int state, int infoClass, String serverName, String procName, long lineNumber) {
        this.message = message;
        this.number = number;
        this.state = state;
        this.infoClass = infoClass;
        this.serverName = StringUtils.hasText(serverName) ? serverName : null;
        this.procName = procName;
        this.lineNumber = lineNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public long getNumber() {
        return this.number;
    }

    public int getState() {
        return this.state;
    }

    public String getStateCode() {
        return this.getStateCode((int)this.getNumber(), this.getState());
    }

    public int getInfoClass() {
        return this.infoClass;
    }

    @Nullable
    public String getServerName() {
        return this.serverName;
    }

    @Nullable
    public String getProcName() {
        return this.procName;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    private String getStateCode(int errNum, int databaseState) {
        switch (errNum) {
            case 8152: {
                return "22001";
            }
            case 515: 
            case 547: {
                return "23000";
            }
            case 2601: {
                return "23000";
            }
            case 2714: {
                return "S0001";
            }
            case 208: {
                return "S0002";
            }
            case 1205: {
                return "40001";
            }
            case 2627: {
                return "23000";
            }
        }
        return "S000" + databaseState;
    }
}

