/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import org.jboss.resteasy.reactive.server.mapping.Dumpable;
import org.jboss.resteasy.reactive.server.mapping.PathMatcher;
import org.jboss.resteasy.reactive.server.mapping.URITemplate;

public class RequestMapper<T> {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final PathMatcher<ArrayList<RequestPath<T>>> requestPaths;
    private final PathMatcher.Builder<ArrayList<RequestPath<T>>> pathMatcherBuilder = new PathMatcher.Builder();
    private final ArrayList<RequestPath<T>> templates;
    final int maxParams;

    public RequestMapper(ArrayList<RequestPath<T>> templates) {
        this.templates = templates;
        int max = 0;
        HashMap<String, ArrayList> aggregates = new HashMap<String, ArrayList>();
        for (RequestPath<T> i : templates) {
            ArrayList<RequestPath<T>> paths = (ArrayList<RequestPath<T>>)aggregates.get(i.template.stem);
            if (paths == null) {
                paths = new ArrayList<RequestPath<T>>();
                aggregates.put(i.template.stem, paths);
            }
            paths.add(i);
            max = Math.max(max, i.template.countPathParamNames());
        }
        aggregates.forEach(this::sortAggregates);
        aggregates.forEach(this::addPrefixPaths);
        this.maxParams = max;
        this.requestPaths = this.pathMatcherBuilder.build();
    }

    private void sortAggregates(String stem, List<RequestPath<T>> list) {
        list.sort(new Comparator<RequestPath<T>>(){

            @Override
            public int compare(RequestPath<T> t1, RequestPath<T> t2) {
                return t2.template.compareTo(t1.template);
            }
        });
    }

    private void addPrefixPaths(String stem, ArrayList<RequestPath<T>> list) {
        this.pathMatcherBuilder.addPrefixPath(stem, list);
    }

    public RequestMatch<T> map(String path) {
        RequestMatch<T> result = this.mapFromPathMatcher(path, this.requestPaths.match(path));
        if (result != null) {
            return result;
        }
        return this.mapFromPathMatcher(path, this.requestPaths.defaultMatch(path));
    }

    private RequestMatch<T> mapFromPathMatcher(String path, PathMatcher.PathMatch<ArrayList<RequestPath<T>>> initialMatch) {
        ArrayList<RequestPath<T>> value = initialMatch.getValue();
        if (initialMatch.getValue() == null) {
            return null;
        }
        int pathLength = path.length();
        for (int index = 0; index < value.size(); ++index) {
            RequestPath potentialMatch = (RequestPath)value.get(index);
            String[] params = this.maxParams > 0 ? new String[this.maxParams] : EMPTY_STRING_ARRAY;
            int paramCount = 0;
            boolean matched = true;
            boolean prefixAllowed = potentialMatch.prefixTemplate;
            int matchPos = initialMatch.getMatched().length();
            for (int i = 1; i < potentialMatch.template.components.length; ++i) {
                URITemplate.TemplateComponent segment = potentialMatch.template.components[i];
                if (segment.type == URITemplate.Type.CUSTOM_REGEX) {
                    Matcher matcher = segment.pattern.matcher(path);
                    matched = matcher.find(matchPos);
                    if (!matched || matcher.start() != matchPos) break;
                    matchPos = matcher.end();
                    for (String group : segment.groups) {
                        params[paramCount++] = matcher.group(group);
                    }
                    continue;
                }
                if (segment.type == URITemplate.Type.LITERAL) {
                    if (matchPos + segment.literalText.length() > pathLength) {
                        matched = false;
                        break;
                    }
                    for (int pos = 0; pos < segment.literalText.length(); ++pos) {
                        if (path.charAt(matchPos++) == segment.literalText.charAt(pos)) continue;
                        matched = false;
                        break;
                    }
                    if (matched) continue;
                    break;
                }
                if (segment.type != URITemplate.Type.DEFAULT_REGEX) continue;
                if (matchPos == pathLength) {
                    matched = false;
                    break;
                }
                int start = matchPos;
                while (matchPos < pathLength && path.charAt(matchPos) != '/') {
                    ++matchPos;
                }
                params[paramCount++] = path.substring(start, matchPos);
            }
            if (!matched) continue;
            if (paramCount < params.length) {
                params[paramCount] = null;
            }
            boolean fullMatch = matchPos == pathLength;
            boolean doPrefixMatch = false;
            if (!fullMatch) {
                if (matchPos == 1) {
                    doPrefixMatch = prefixAllowed || pathLength == 1;
                } else if (path.charAt(matchPos) == '/') {
                    boolean bl = doPrefixMatch = prefixAllowed || matchPos == pathLength - 1;
                }
            }
            if (!fullMatch && !doPrefixMatch) continue;
            String remaining = fullMatch ? "" : (matchPos == 1 ? path : path.substring(matchPos));
            return new RequestMatch(potentialMatch.template, potentialMatch.value, params, remaining);
        }
        return null;
    }

    public void dump() {
        this.requestPaths.dump(0);
    }

    public PathMatcher<ArrayList<RequestPath<T>>> getRequestPaths() {
        return this.requestPaths;
    }

    public ArrayList<RequestPath<T>> getTemplates() {
        return this.templates;
    }

    public static class RequestPath<T>
    implements Dumpable {
        public final boolean prefixTemplate;
        public final URITemplate template;
        public final T value;

        public RequestPath(boolean prefixTemplate, URITemplate template, T value) {
            this.prefixTemplate = prefixTemplate;
            this.template = template;
            this.value = value;
        }

        public String toString() {
            return "RequestPath{ value: " + this.value + ", template: " + this.template + " }";
        }

        @Override
        public void dump(int level) {
            this.indent(level);
            System.err.println("RequestPath:");
            this.indent(level + 1);
            System.err.println("value: " + this.value);
            this.indent(level + 1);
            System.err.println("template: ");
            this.template.dump(level + 2);
        }
    }

    public static class RequestMatch<T> {
        public final URITemplate template;
        public final T value;
        public final String[] pathParamValues;
        public final String remaining;

        public RequestMatch(URITemplate template, T value, String[] pathParamValues, String remaining) {
            this.template = template;
            this.value = value;
            this.pathParamValues = pathParamValues;
            this.remaining = remaining;
        }

        public String toString() {
            return "RequestMatch{ value: " + this.value + ", template: " + this.template + ", pathParamValues: " + Arrays.toString(this.pathParamValues) + " }";
        }
    }
}

