/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.reactive.server.handlers.ClassRoutingHandler;
import org.jboss.resteasy.reactive.server.handlers.RestInitialHandler;
import org.jboss.resteasy.reactive.server.mapping.RequestMapper;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public interface RuntimeResourceVisitor {
    default public void visitBasePath(String basePath) {
    }

    default public void visitRuntimeResource(String httpMethod, String fullPath, RuntimeResource runtimeResource) {
    }

    default public void visitEnd() {
    }

    default public void visitStart() {
    }

    public static void visitRuntimeResources(String applicationPath, List<RequestMapper.RequestPath<RestInitialHandler.InitialMatch>> classMappers, RuntimeResourceVisitor visitor) {
        visitor.visitStart();
        for (RequestMapper.RequestPath<RestInitialHandler.InitialMatch> classMapper : classMappers) {
            ServerRestHandler firstHandler;
            String template = classMapper.template.template;
            RestInitialHandler.InitialMatch initialMatch = (RestInitialHandler.InitialMatch)classMapper.value;
            if (initialMatch.handlers == null || initialMatch.handlers.length == 0 || !((firstHandler = initialMatch.handlers[0]) instanceof ClassRoutingHandler)) continue;
            ClassRoutingHandler classRoutingHandler = (ClassRoutingHandler)firstHandler;
            Map<String, RequestMapper<RuntimeResource>> classRoutingHandlerMappers = classRoutingHandler.getMappers();
            for (Map.Entry<String, RequestMapper<RuntimeResource>> entry : classRoutingHandlerMappers.entrySet()) {
                RequestMapper<RuntimeResource> requestMapper;
                ArrayList<RequestMapper.RequestPath<RuntimeResource>> methodTemplates;
                String basePath = template;
                String httpMethod = entry.getKey();
                if (httpMethod == null || (methodTemplates = (requestMapper = entry.getValue()).getTemplates()).isEmpty()) continue;
                visitor.visitBasePath(basePath);
                for (RequestMapper.RequestPath requestPath : methodTemplates) {
                    String subPath = requestPath.template.template;
                    if (subPath.startsWith("/")) {
                        subPath = subPath.substring(1);
                    }
                    Object fullPath = basePath;
                    if (!subPath.isEmpty()) {
                        fullPath = basePath.endsWith("/") ? (String)fullPath + subPath : basePath + "/" + subPath;
                    }
                    if (applicationPath != null && !applicationPath.isBlank() && !applicationPath.equals("/")) {
                        fullPath = applicationPath + (String)fullPath;
                    }
                    RuntimeResource runtimeResource = (RuntimeResource)requestPath.value;
                    visitor.visitRuntimeResource(httpMethod, (String)fullPath, runtimeResource);
                }
            }
        }
        visitor.visitEnd();
    }
}

