/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.model.ResourceReader;
import org.jboss.resteasy.reactive.common.model.ResourceWriter;

public abstract class DeploymentUtils {
    private static final Map<String, Class<?>> primitiveTypes;

    public static void registerWriter(Serialisers serialisers, String entityClassName, ResourceWriter writer) {
        serialisers.addWriter(DeploymentUtils.loadClass(entityClassName), writer);
    }

    public static void registerReader(Serialisers serialisers, String entityClassName, ResourceReader reader) {
        serialisers.addReader(DeploymentUtils.loadClass(entityClassName), reader);
    }

    public static <T> Class<T> loadClass(String name) {
        if (primitiveTypes.containsKey(name)) {
            return primitiveTypes.get(name);
        }
        try {
            return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        HashMap<String, Class<Comparable<Byte>>> prims = new HashMap<String, Class<Comparable<Byte>>>();
        prims.put(Byte.TYPE.getName(), Byte.TYPE);
        prims.put(Boolean.TYPE.getName(), Boolean.TYPE);
        prims.put(Character.TYPE.getName(), Character.TYPE);
        prims.put(Short.TYPE.getName(), Short.TYPE);
        prims.put(Integer.TYPE.getName(), Integer.TYPE);
        prims.put(Float.TYPE.getName(), Float.TYPE);
        prims.put(Double.TYPE.getName(), Double.TYPE);
        prims.put(Long.TYPE.getName(), Long.TYPE);
        primitiveTypes = Collections.unmodifiableMap(prims);
    }
}

