/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.model;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.common.util.ServerMediaType;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ResourceWriter {
    private BeanFactory<MessageBodyWriter<?>> factory;
    private List<String> mediaTypeStrings = new ArrayList<String>();
    private RuntimeType constraint;
    private boolean builtin = true;
    private volatile List<MediaType> mediaTypes;
    private volatile ServerMediaType serverMediaType;
    private volatile MessageBodyWriter<?> instance;

    public ResourceWriter setFactory(BeanFactory<MessageBodyWriter<?>> factory) {
        this.factory = factory;
        return this;
    }

    public BeanFactory<MessageBodyWriter<?>> getFactory() {
        return this.factory;
    }

    public List<String> getMediaTypeStrings() {
        return this.mediaTypeStrings;
    }

    public ResourceWriter setMediaTypeStrings(List<String> mediaTypeStrings) {
        this.mediaTypeStrings = mediaTypeStrings;
        return this;
    }

    public RuntimeType getConstraint() {
        return this.constraint;
    }

    public ResourceWriter setConstraint(RuntimeType constraint) {
        this.constraint = constraint;
        return this;
    }

    public boolean isBuiltin() {
        return this.builtin;
    }

    public void setBuiltin(boolean builtin) {
        this.builtin = builtin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageBodyWriter<?> instance() {
        if (this.instance == null) {
            ResourceWriter resourceWriter = this;
            synchronized (resourceWriter) {
                if (this.instance == null) {
                    this.instance = this.factory.createInstance().getInstance();
                }
            }
        }
        return this.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaType> mediaTypes() {
        if (this.mediaTypes == null) {
            ResourceWriter resourceWriter = this;
            synchronized (resourceWriter) {
                ArrayList<MediaType> mts = new ArrayList<MediaType>(this.mediaTypeStrings.size());
                for (int i = 0; i < this.mediaTypeStrings.size(); ++i) {
                    mts.add(MediaType.valueOf((String)this.mediaTypeStrings.get(i)));
                }
                this.mediaTypes = Collections.unmodifiableList(mts);
            }
        }
        return this.mediaTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerMediaType serverMediaType() {
        if (this.serverMediaType == null) {
            ResourceWriter resourceWriter = this;
            synchronized (resourceWriter) {
                this.serverMediaType = new ServerMediaType(this.mediaTypes(), StandardCharsets.UTF_8.name(), false, false);
            }
        }
        return this.serverMediaType;
    }

    public boolean matchesRuntimeType(RuntimeType runtimeType) {
        if (runtimeType == null) {
            return true;
        }
        if (this.constraint == null) {
            return true;
        }
        return runtimeType == this.constraint;
    }

    public String toString() {
        return "ResourceWriter[constraint: " + this.constraint + ", mediaTypes: " + this.mediaTypes + ", factory: " + this.factory + "]";
    }

    public static class ResourceWriterComparator
    implements Comparator<ResourceWriter> {
        public static final ResourceWriterComparator INSTANCE = new ResourceWriterComparator();

        @Override
        public int compare(ResourceWriter o1, ResourceWriter o2) {
            int builtInCompare = Boolean.compare(o1.isBuiltin(), o2.isBuiltin());
            if (builtInCompare != 0) {
                return builtInCompare;
            }
            List<MediaType> mediaTypes1 = o1.mediaTypes();
            List<MediaType> mediaTypes2 = o2.mediaTypes();
            if (mediaTypes1.isEmpty() && mediaTypes2.isEmpty()) {
                return 0;
            }
            if (mediaTypes1.isEmpty()) {
                return 1;
            }
            if (mediaTypes2.isEmpty()) {
                return -1;
            }
            int mediaTypeCompare = MediaTypeHelper.compareWeight(mediaTypes1.get(0), mediaTypes2.get(0));
            if (mediaTypeCompare != 0) {
                return mediaTypeCompare;
            }
            return Integer.compare(mediaTypes1.size(), mediaTypes2.size());
        }
    }
}

