/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.jaxrs;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.reactive.common.util.Encode;
import org.jboss.resteasy.reactive.common.util.PathHelper;
import org.jboss.resteasy.reactive.common.util.QuarkusMultivaluedHashMap;

public class UriBuilderImpl
extends UriBuilder {
    private String host;
    private String scheme;
    private int port = -1;
    private String userInfo;
    private String path;
    private String query;
    private String fragment;
    private String ssp;
    private String authority;
    public static final Pattern opaqueUri = Pattern.compile("^([^:/?#{]+):([^/].*)");
    public static final Pattern hierarchicalUri = Pattern.compile("^(([^:/?#{]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final Pattern hostPortPattern = Pattern.compile("([^/:]+):(\\d+)");
    private static final Pattern squareHostBrackets = Pattern.compile("(\\[(([0-9A-Fa-f]{0,4}:){2,7})([0-9A-Fa-f]{0,4})%?.*\\]):(\\d+)");
    private static final Pattern PARAM_REPLACEMENT = Pattern.compile("_resteasy_uri_parameter");

    public UriBuilder clone() {
        UriBuilderImpl impl = new UriBuilderImpl();
        impl.host = this.host;
        impl.scheme = this.scheme;
        impl.port = this.port;
        impl.userInfo = this.userInfo;
        impl.path = this.path;
        impl.query = this.query;
        impl.fragment = this.fragment;
        impl.ssp = this.ssp;
        impl.authority = this.authority;
        return impl;
    }

    public static boolean compare(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static URI relativize(URI from, URI to) {
        int i;
        if (!UriBuilderImpl.compare(from.getScheme(), to.getScheme())) {
            return to;
        }
        if (!UriBuilderImpl.compare(from.getHost(), to.getHost())) {
            return to;
        }
        if (from.getPort() != to.getPort()) {
            return to;
        }
        if (from.getPath() == null && to.getPath() == null) {
            return URI.create("");
        }
        if (from.getPath() == null) {
            return URI.create(to.getPath());
        }
        if (to.getPath() == null) {
            return to;
        }
        String fromPath = from.getPath();
        if (fromPath.startsWith("/")) {
            fromPath = fromPath.substring(1);
        }
        String[] fsplit = fromPath.split("/");
        String toPath = to.getPath();
        if (toPath.startsWith("/")) {
            toPath = toPath.substring(1);
        }
        String[] tsplit = toPath.split("/");
        for (int f = 0; f < fsplit.length && f < tsplit.length && fsplit[f].equals(tsplit[f]); ++f) {
        }
        UriBuilder builder = UriBuilder.fromPath((String)"");
        for (i = f; i < fsplit.length; ++i) {
            builder.path("..");
        }
        for (i = f; i < tsplit.length; ++i) {
            builder.path(tsplit[i]);
        }
        return builder.build(new Object[0]);
    }

    public static UriBuilderImpl fromTemplate(String uriTemplate) {
        UriBuilderImpl impl = (UriBuilderImpl)RuntimeDelegate.getInstance().createUriBuilder();
        impl.uriTemplate(uriTemplate);
        return impl;
    }

    public UriBuilder uriTemplate(CharSequence uriTemplate) {
        if (uriTemplate == null) {
            throw new IllegalArgumentException("Param was null");
        }
        Matcher opaque = opaqueUri.matcher(uriTemplate);
        if (opaque.matches()) {
            this.authority = null;
            this.host = null;
            this.port = -1;
            this.userInfo = null;
            this.query = null;
            this.scheme = opaque.group(1);
            this.ssp = opaque.group(2);
            return this;
        }
        Matcher match = hierarchicalUri.matcher(uriTemplate);
        if (match.matches()) {
            this.ssp = null;
            return this.parseHierarchicalUri(uriTemplate, match);
        }
        throw new IllegalArgumentException("Illegal URI template" + uriTemplate);
    }

    protected UriBuilder parseHierarchicalUri(CharSequence uriTemplate, Matcher match) {
        String authority;
        boolean scheme;
        boolean bl = scheme = match.group(2) != null;
        if (scheme) {
            this.scheme = match.group(2);
        }
        if ((authority = match.group(4)) != null) {
            Matcher bracketsMatch;
            Matcher hostPortMatch;
            this.authority = null;
            String host = match.group(4);
            int at = host.indexOf(64);
            if (at > -1) {
                String user = host.substring(0, at);
                host = host.substring(at + 1);
                this.userInfo = user;
            }
            if ((hostPortMatch = hostPortPattern.matcher(host)).matches()) {
                this.host = hostPortMatch.group(1);
                try {
                    this.port = Integer.parseInt(hostPortMatch.group(2));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal URI template" + uriTemplate, e);
                }
            }
            if (host.startsWith("[") && (bracketsMatch = squareHostBrackets.matcher(host)).matches()) {
                host = bracketsMatch.group(1);
                try {
                    this.port = Integer.parseInt(bracketsMatch.group(5));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal URI template" + uriTemplate, e);
                }
            }
            this.host = host;
        }
        if (match.group(5) != null) {
            String group = match.group(5);
            if (!(scheme || "".equals(group) || group.startsWith("/") || group.indexOf(58) <= -1 || group.indexOf(47) <= -1 || group.indexOf(58) >= group.indexOf(47))) {
                throw new IllegalArgumentException("Illegal URI template" + uriTemplate);
            }
            if (!"".equals(group)) {
                this.replacePath(group);
            }
        }
        if (match.group(7) != null) {
            this.replaceQuery(match.group(7));
        }
        if (match.group(9) != null) {
            this.fragment(match.group(9));
        }
        return this;
    }

    public UriBuilder uri(String uriTemplate) throws IllegalArgumentException {
        return this.uriTemplate(uriTemplate);
    }

    public UriBuilder uriFromCharSequence(CharSequence uriTemplate) throws IllegalArgumentException {
        return this.uriTemplate(uriTemplate);
    }

    public UriBuilder uri(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("URI is null");
        }
        if (uri.getRawFragment() != null) {
            this.fragment = uri.getRawFragment();
        }
        if (uri.isOpaque()) {
            this.scheme = uri.getScheme();
            this.ssp = uri.getRawSchemeSpecificPart();
            return this;
        }
        if (uri.getScheme() == null) {
            if (this.ssp != null && uri.getRawSchemeSpecificPart() != null) {
                this.ssp = uri.getRawSchemeSpecificPart();
                return this;
            }
        } else {
            this.scheme = uri.getScheme();
        }
        this.ssp = null;
        if (uri.getRawAuthority() != null) {
            if (uri.getRawUserInfo() == null && uri.getHost() == null && uri.getPort() == -1) {
                this.authority = uri.getRawAuthority();
                this.userInfo = null;
                this.host = null;
                this.port = -1;
            } else {
                this.authority = null;
                if (uri.getRawUserInfo() != null) {
                    this.userInfo = uri.getRawUserInfo();
                }
                if (uri.getHost() != null) {
                    this.host = uri.getHost();
                }
                if (uri.getPort() != -1) {
                    this.port = uri.getPort();
                }
            }
        }
        if (uri.getRawPath() != null && uri.getRawPath().length() > 0) {
            this.path = uri.getRawPath();
        }
        if (uri.getRawQuery() != null && uri.getRawQuery().length() > 0) {
            this.query = uri.getRawQuery();
        }
        return this;
    }

    public UriBuilder scheme(String scheme) throws IllegalArgumentException {
        this.scheme = scheme;
        return this;
    }

    public UriBuilder schemeSpecificPart(String ssp) throws IllegalArgumentException {
        URI uri;
        if (ssp == null) {
            throw new IllegalArgumentException("Scheme was null");
        }
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme).append(':');
        }
        if (ssp != null) {
            sb.append(ssp);
        }
        if (this.fragment != null && this.fragment.length() > 0) {
            sb.append('#').append(this.fragment);
        }
        if ((uri = URI.create(sb.toString())).getRawSchemeSpecificPart() != null && uri.getRawPath() == null) {
            this.ssp = uri.getRawSchemeSpecificPart();
        } else {
            this.ssp = null;
            this.userInfo = uri.getRawUserInfo();
            this.host = uri.getHost();
            this.port = uri.getPort();
            this.path = uri.getRawPath();
            this.query = uri.getRawQuery();
        }
        return this;
    }

    public UriBuilder userInfo(String ui) {
        this.userInfo = ui;
        return this;
    }

    public UriBuilder host(String host) throws IllegalArgumentException {
        if (host != null && host.equals("")) {
            throw new IllegalArgumentException("invalid host");
        }
        this.host = host;
        return this;
    }

    public UriBuilder port(int port) throws IllegalArgumentException {
        if (port < -1) {
            throw new IllegalArgumentException("invalid port");
        }
        this.port = port;
        return this;
    }

    protected static String paths(boolean encode, String basePath, String ... segments) {
        String path = basePath;
        if (path == null) {
            path = "";
        }
        for (String segment : segments) {
            if ("".equals(segment)) continue;
            if (path.endsWith("/")) {
                if (segment.startsWith("/") && "".equals(segment = segment.substring(1))) continue;
                if (encode) {
                    segment = Encode.encodePath(segment);
                }
                path = path + segment;
                continue;
            }
            if (encode) {
                segment = Encode.encodePath(segment);
            }
            path = "".equals(path) ? segment : (segment.startsWith("/") ? path + segment : path + "/" + segment);
        }
        return path;
    }

    public UriBuilder path(String segment) throws IllegalArgumentException {
        if (segment == null) {
            throw new IllegalArgumentException("path is null");
        }
        this.path = UriBuilderImpl.paths(true, this.path, segment);
        return this;
    }

    public UriBuilder path(Class resource) throws IllegalArgumentException {
        if (resource == null) {
            throw new IllegalArgumentException("path is null");
        }
        Path ann = resource.getAnnotation(Path.class);
        if (ann == null) {
            throw new IllegalArgumentException("class must be annotated with @Path");
        }
        String[] segments = new String[]{ann.value()};
        this.path = UriBuilderImpl.paths(true, this.path, segments);
        return this;
    }

    public UriBuilder path(Class resource, String method) throws IllegalArgumentException {
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        Method theMethod = null;
        for (Method m : resource.getMethods()) {
            if (!m.getName().equals(method)) continue;
            if (theMethod != null && m.isAnnotationPresent(Path.class)) {
                throw new IllegalArgumentException("Two methods with the same path " + method);
            }
            if (!m.isAnnotationPresent(Path.class)) continue;
            theMethod = m;
        }
        if (theMethod == null) {
            throw new IllegalArgumentException("No public method annotated with @Path " + resource.getName() + " " + method);
        }
        return this.path(theMethod);
    }

    public UriBuilder path(Method method) throws IllegalArgumentException {
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        Path ann = method.getAnnotation(Path.class);
        if (ann == null) {
            throw new IllegalArgumentException("Method not annotated with @Path");
        }
        this.path = UriBuilderImpl.paths(true, this.path, ann.value());
        return this;
    }

    public UriBuilder replaceMatrix(String matrix) throws IllegalArgumentException {
        if (matrix == null) {
            matrix = "";
        }
        if (!matrix.startsWith(";")) {
            matrix = ";" + matrix;
        }
        matrix = Encode.encodePath(matrix);
        if (this.path == null) {
            this.path = matrix;
        } else {
            int matrixIndex;
            int start = this.path.lastIndexOf(47);
            if (start < 0) {
                start = 0;
            }
            this.path = (matrixIndex = this.path.indexOf(59, start)) > -1 ? this.path.substring(0, matrixIndex) + matrix : this.path + matrix;
        }
        return this;
    }

    public UriBuilder replaceQuery(String query) throws IllegalArgumentException {
        if (query == null || query.length() == 0) {
            this.query = null;
            return this;
        }
        this.query = Encode.encodeQueryString(query);
        return this;
    }

    public UriBuilder fragment(String fragment) throws IllegalArgumentException {
        if (fragment == null) {
            this.fragment = null;
            return this;
        }
        this.fragment = Encode.encodeFragment(fragment);
        return this;
    }

    public UriBuilder substitutePathParam(String name, Object value, boolean isEncoded) {
        if (this.path != null) {
            StringBuilder builder = new StringBuilder();
            this.replacePathParameter(name, value.toString(), isEncoded, this.path, builder, false);
            this.path = builder.toString();
        }
        return this;
    }

    public URI buildFromMap(Map<String, ? extends Object> values) throws IllegalArgumentException, UriBuilderException {
        if (values == null) {
            throw new IllegalArgumentException("Values parameter is null");
        }
        return this.buildUriFromMap(values, false, true);
    }

    public URI buildFromEncodedMap(Map<String, ? extends Object> values) throws IllegalArgumentException, UriBuilderException {
        if (values == null) {
            throw new IllegalArgumentException("Values parameter is null");
        }
        return this.buildUriFromMap(values, true, false);
    }

    public URI buildFromMap(Map<String, ?> values, boolean encodeSlashInPath) throws IllegalArgumentException, UriBuilderException {
        if (values == null) {
            throw new IllegalArgumentException("Values parameter is null");
        }
        return this.buildUriFromMap(values, false, encodeSlashInPath);
    }

    protected URI buildUriFromMap(Map<String, ? extends Object> paramMap, boolean fromEncodedMap, boolean encodeSlash) throws IllegalArgumentException, UriBuilderException {
        String buf = this.buildString(paramMap, fromEncodedMap, false, encodeSlash);
        try {
            return URI.create(buf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create URI", e);
        }
    }

    private String buildString(Map<String, ? extends Object> paramMap, boolean fromEncodedMap, boolean isTemplate, boolean encodeSlash) {
        return this.buildCharSequence(paramMap, fromEncodedMap, isTemplate, encodeSlash).toString();
    }

    private CharSequence buildCharSequence(Map<String, ? extends Object> paramMap, boolean fromEncodedMap, boolean isTemplate, boolean encodeSlash) {
        StringBuilder builder = new StringBuilder();
        if (this.scheme != null) {
            this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.scheme, builder, encodeSlash).append(":");
        }
        if (this.ssp != null) {
            builder.append(this.ssp);
        } else if (this.userInfo != null || this.host != null || this.port != -1) {
            builder.append("//");
            if (this.userInfo != null) {
                this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.userInfo, builder, encodeSlash).append("@");
            }
            if (this.host != null) {
                if ("".equals(this.host)) {
                    throw new UriBuilderException("empty host");
                }
                this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.host, builder, encodeSlash);
            }
            if (this.port != -1) {
                builder.append(":").append(Integer.toString(this.port));
            }
        } else if (this.authority != null) {
            builder.append("//");
            this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.authority, builder, encodeSlash);
        }
        if (this.path != null) {
            StringBuilder tmp = new StringBuilder();
            this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.path, tmp, encodeSlash);
            if ((this.userInfo != null || this.host != null) && tmp.length() > 0 && tmp.charAt(0) != '/') {
                builder.append("/");
            }
            builder.append((CharSequence)tmp);
        }
        if (this.query != null) {
            builder.append("?");
            this.replaceQueryStringParameter(paramMap, fromEncodedMap, isTemplate, this.query, builder);
        }
        if (this.fragment != null) {
            builder.append("#");
            this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.fragment, builder, encodeSlash);
        }
        return builder;
    }

    protected StringBuilder replacePathParameter(String name, String value, boolean isEncoded, String string, StringBuilder builder, boolean encodeSlash) {
        if (string.indexOf(123) == -1) {
            return builder.append(string);
        }
        Matcher matcher = UriBuilderImpl.createUriParamMatcher(string);
        int start = 0;
        while (matcher.find()) {
            String param = matcher.group(1);
            if (!param.equals(name)) continue;
            builder.append(string, start, matcher.start());
            value = !isEncoded ? (encodeSlash ? Encode.encodePath(value) : Encode.encodePathSegment(value)) : Encode.encodeNonCodes(value);
            builder.append(value);
            start = matcher.end();
        }
        builder.append(string, start, string.length());
        return builder;
    }

    public static Matcher createUriParamMatcher(String string) {
        Matcher matcher = PathHelper.URI_PARAM_PATTERN.matcher(PathHelper.replaceEnclosedCurlyBracesCS(string));
        return matcher;
    }

    protected StringBuilder replaceParameter(Map<String, ? extends Object> paramMap, boolean fromEncodedMap, boolean isTemplate, String string, StringBuilder builder, boolean encodeSlash) {
        if (string.indexOf(123) == -1) {
            return builder.append(string);
        }
        Matcher matcher = UriBuilderImpl.createUriParamMatcher(string);
        int start = 0;
        while (matcher.find()) {
            String stringValue;
            builder.append(string, start, matcher.start());
            String param = matcher.group(1);
            boolean containsValueForParam = paramMap.containsKey(param);
            if (!containsValueForParam) {
                if (isTemplate) {
                    builder.append(matcher.group());
                    start = matcher.end();
                    continue;
                }
                throw new IllegalArgumentException("Path parameter not provided " + param);
            }
            Object value = paramMap.get(param);
            String string2 = stringValue = value != null ? value.toString() : null;
            if (stringValue != null) {
                stringValue = !fromEncodedMap ? (encodeSlash ? Encode.encodePathSegmentAsIs(stringValue) : Encode.encodePathAsIs(stringValue)) : (encodeSlash ? Encode.encodePathSegmentSaveEncodings(stringValue) : Encode.encodePathSaveEncodings(stringValue));
                builder.append(stringValue);
                start = matcher.end();
                continue;
            }
            throw new IllegalArgumentException("Template parameter null: " + param);
        }
        builder.append(string, start, string.length());
        return builder;
    }

    protected StringBuilder replaceQueryStringParameter(Map<String, ? extends Object> paramMap, boolean fromEncodedMap, boolean isTemplate, String string, StringBuilder builder) {
        if (string.indexOf(123) == -1) {
            return builder.append(string);
        }
        Matcher matcher = UriBuilderImpl.createUriParamMatcher(string);
        int start = 0;
        while (matcher.find()) {
            String stringValue;
            builder.append(string, start, matcher.start());
            String param = matcher.group(1);
            boolean containsValueForParam = paramMap.containsKey(param);
            if (!containsValueForParam) {
                if (isTemplate) {
                    builder.append(matcher.group());
                    start = matcher.end();
                    continue;
                }
                throw new IllegalArgumentException("Path parameter not provided " + param);
            }
            Object value = paramMap.get(param);
            String string2 = stringValue = value != null ? value.toString() : null;
            if (stringValue != null) {
                stringValue = !fromEncodedMap ? Encode.encodeQueryParamAsIs(stringValue) : Encode.encodeQueryParamSaveEncodings(stringValue);
                builder.append(stringValue);
                start = matcher.end();
                continue;
            }
            throw new IllegalArgumentException("Template parm was null: " + param);
        }
        builder.append(string, start, string.length());
        return builder;
    }

    public List<String> getPathParamNamesInDeclarationOrder() {
        ArrayList<String> params = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        if (this.scheme != null) {
            this.addToPathParamList(params, set, this.scheme);
        }
        if (this.userInfo != null) {
            this.addToPathParamList(params, set, this.userInfo);
        }
        if (this.host != null) {
            this.addToPathParamList(params, set, this.host);
        }
        if (this.path != null) {
            this.addToPathParamList(params, set, this.path);
        }
        if (this.query != null) {
            this.addToPathParamList(params, set, this.query);
        }
        if (this.fragment != null) {
            this.addToPathParamList(params, set, this.fragment);
        }
        return params;
    }

    private void addToPathParamList(List<String> params, HashSet<String> set, String string) {
        Matcher matcher = PathHelper.URI_PARAM_PATTERN.matcher(PathHelper.replaceEnclosedCurlyBracesCS(string));
        while (matcher.find()) {
            String param = matcher.group(1);
            if (set.contains(param)) continue;
            set.add(param);
            params.add(param);
        }
    }

    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        if (values == null) {
            throw new IllegalArgumentException("Values parameter is null");
        }
        return this.buildFromValues(true, false, values);
    }

    protected URI buildFromValues(boolean encodeSlash, boolean encoded, Object ... values) {
        String buf = null;
        try {
            buf = this.buildString(new URITemplateParametersMap(values), encoded, false, encodeSlash);
            return new URI(buf);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new UriBuilderException("failed to create URI", (Throwable)e);
        }
    }

    public UriBuilder matrixParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name parameter is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values parameter is null");
        }
        if (this.path == null) {
            this.path = "";
        }
        for (Object val : values) {
            if (val == null) {
                throw new IllegalArgumentException("Value is null");
            }
            this.path = this.path + ";" + Encode.encodeMatrixParam(name) + "=" + Encode.encodeMatrixParam(val.toString());
        }
        return this;
    }

    public UriBuilder replaceMatrixParam(String name, Object ... values) throws IllegalArgumentException {
        int matrixIndex;
        if (name == null) {
            throw new IllegalArgumentException("Name parameter is null");
        }
        if (this.path == null) {
            if (values != null && values.length > 0) {
                return this.matrixParam(name, values);
            }
            return this;
        }
        ArrayList<String> pathParams = new ArrayList<String>();
        boolean foundParam = false;
        CharSequence pathWithoutEnclosedCurlyBraces = PathHelper.replaceEnclosedCurlyBracesCS(this.path);
        Matcher matcher = PathHelper.URI_TEMPLATE_PATTERN.matcher(pathWithoutEnclosedCurlyBraces);
        StringBuilder newSegment = new StringBuilder();
        int from = 0;
        while (matcher.find()) {
            newSegment.append(pathWithoutEnclosedCurlyBraces, from, matcher.start());
            foundParam = true;
            String group = matcher.group();
            pathParams.add(PathHelper.recoverEnclosedCurlyBraces(group));
            newSegment.append("_resteasy_uri_parameter");
            from = matcher.end();
        }
        newSegment.append(pathWithoutEnclosedCurlyBraces, from, pathWithoutEnclosedCurlyBraces.length());
        this.path = newSegment.toString();
        int start = this.path.lastIndexOf(47);
        if (start < 0) {
            start = 0;
        }
        if ((matrixIndex = this.path.indexOf(59, start)) > -1) {
            String matrixParams = this.path.substring(matrixIndex + 1);
            this.path = this.path.substring(0, matrixIndex);
            QuarkusMultivaluedHashMap map = new QuarkusMultivaluedHashMap();
            String[] params = matrixParams.split(";");
            for (String param : params) {
                int idx = param.indexOf(61);
                if (idx < 0) {
                    map.add(param, null);
                    continue;
                }
                String theName = param.substring(0, idx);
                String value = "";
                if (idx + 1 < param.length()) {
                    value = param.substring(idx + 1);
                }
                map.add(theName, value);
            }
            map.remove(name);
            for (String theName : map.keySet()) {
                List vals = (List)map.get(theName);
                for (Object val : vals) {
                    if (val == null) {
                        this.path = this.path + ";" + theName;
                        continue;
                    }
                    this.path = this.path + ";" + theName + "=" + val.toString();
                }
            }
        }
        if (values != null && values.length > 0) {
            this.matrixParam(name, values);
        }
        if (foundParam) {
            matcher = PARAM_REPLACEMENT.matcher(this.path);
            newSegment = new StringBuilder();
            int i = 0;
            from = 0;
            while (matcher.find()) {
                newSegment.append(this.path, from, matcher.start());
                newSegment.append((String)pathParams.get(i++));
                from = matcher.end();
            }
            newSegment.append(this.path, from, this.path.length());
            this.path = newSegment.toString();
        }
        return this;
    }

    public UriBuilder clientQueryParam(String name, Object ... values) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        if (this.query == null) {
            this.query = "";
        } else {
            sb.append(this.query).append("&");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name parameter is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values parameter is null");
        }
        for (Object value : values) {
            if (value == null) {
                throw new IllegalArgumentException("Value is null");
            }
            sb.append(prefix);
            prefix = "&";
            sb.append(Encode.encodeQueryParamAsIs(name)).append("=").append(Encode.encodeQueryParamAsIs(value.toString()));
        }
        this.query = sb.toString();
        return this;
    }

    public UriBuilder queryParam(String name, Object ... values) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        if (this.query == null) {
            this.query = "";
        } else {
            sb.append(this.query).append("&");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name parameter is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values parameter is null");
        }
        for (Object value : values) {
            if (value == null) {
                throw new IllegalArgumentException("Value is null");
            }
            sb.append(prefix);
            prefix = "&";
            sb.append(Encode.encodeQueryParam(name)).append("=").append(Encode.encodeQueryParam(value.toString()));
        }
        this.query = sb.toString();
        return this;
    }

    public UriBuilder replaceQueryParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name parameter is null");
        }
        if (this.query == null || this.query.equals("")) {
            if (values != null) {
                return this.queryParam(name, values);
            }
            return this;
        }
        String[] params = this.query.split("&");
        this.query = null;
        String replacedName = Encode.encodeQueryParam(name);
        for (String param : params) {
            String paramName;
            int pos = param.indexOf(61);
            if (pos < 0 ? param.equals(replacedName) : (paramName = param.substring(0, pos)).equals(replacedName)) continue;
            this.query = this.query == null ? "" : this.query + "&";
            this.query = this.query + param;
        }
        if (values == null || values.length == 0) {
            return this;
        }
        return this.queryParam(name, values);
    }

    public String getHost() {
        return this.host;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public UriBuilder segment(String ... segments) throws IllegalArgumentException {
        if (segments == null) {
            throw new IllegalArgumentException("Segment parameter is null");
        }
        for (String segment : segments) {
            if (segment == null) {
                throw new IllegalArgumentException("Segment is null");
            }
            this.path(Encode.encodePathSegment(segment));
        }
        return this;
    }

    public URI buildFromEncoded(Object ... values) throws IllegalArgumentException, UriBuilderException {
        if (values == null) {
            throw new IllegalArgumentException("Values is null");
        }
        return this.buildFromValues(false, true, values);
    }

    public UriBuilder replacePath(String path) {
        if (path == null) {
            this.path = null;
            return this;
        }
        this.path = Encode.encodePath(path);
        return this;
    }

    public URI build(Object[] values, boolean encodeSlashInPath) throws IllegalArgumentException, UriBuilderException {
        if (values == null) {
            throw new IllegalArgumentException("Values is null");
        }
        return this.buildFromValues(encodeSlashInPath, false, values);
    }

    public String toTemplate() {
        return this.buildString(new HashMap(), true, true, true);
    }

    public UriBuilder resolveTemplate(String name, Object value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        HashMap<String, Object> vals = new HashMap<String, Object>();
        vals.put(name, value);
        return this.resolveTemplates(vals);
    }

    public UriBuilder resolveTemplates(Map<String, Object> templateValues) throws IllegalArgumentException {
        if (templateValues == null) {
            throw new IllegalArgumentException("Template values null");
        }
        if (templateValues.containsKey(null)) {
            throw new IllegalArgumentException("map key null");
        }
        return this.uriTemplate(this.buildCharSequence(templateValues, false, true, true));
    }

    public UriBuilder resolveTemplate(String name, Object value, boolean encodeSlashInPath) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        HashMap<String, Object> vals = new HashMap<String, Object>();
        vals.put(name, value);
        return this.uriTemplate(this.buildCharSequence(vals, false, true, encodeSlashInPath));
    }

    public UriBuilder resolveTemplateFromEncoded(String name, Object value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        HashMap<String, Object> vals = new HashMap<String, Object>();
        vals.put(name, value);
        return this.uriTemplate(this.buildCharSequence(vals, true, true, true));
    }

    public UriBuilder resolveTemplates(Map<String, Object> templateValues, boolean encodeSlashInPath) throws IllegalArgumentException {
        if (templateValues == null) {
            throw new IllegalArgumentException("Template values null");
        }
        if (templateValues.containsKey(null)) {
            throw new IllegalArgumentException("map key null");
        }
        return this.uriTemplate(this.buildCharSequence(templateValues, false, true, encodeSlashInPath));
    }

    public UriBuilder resolveTemplatesFromEncoded(Map<String, Object> templateValues) throws IllegalArgumentException {
        if (templateValues == null) {
            throw new IllegalArgumentException("Template values null");
        }
        if (templateValues.containsKey(null)) {
            throw new IllegalArgumentException("map key null");
        }
        return this.uriTemplate(this.buildCharSequence(templateValues, true, true, true));
    }

    private static final class URITemplateParametersMap
    extends HashMap<String, Object> {
        private final Object[] parameterValues;
        private int index;

        private URITemplateParametersMap(Object ... parameterValues) {
            this.parameterValues = parameterValues;
        }

        @Override
        public Object get(Object key) {
            Object object = null;
            if (!super.containsKey(key) && this.index != this.parameterValues.length) {
                object = this.parameterValues[this.index++];
                super.put((String)key, object);
            } else {
                object = super.get(key);
            }
            return object;
        }

        @Override
        public boolean containsKey(Object key) {
            boolean containsKey = super.containsKey(key);
            if (!containsKey && this.index != this.parameterValues.length) {
                super.put((String)key, this.parameterValues[this.index++]);
                containsKey = true;
            }
            return containsKey;
        }
    }
}

