/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.parsetools.RecordParser;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.sse.InboundSseEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.jboss.resteasy.reactive.client.SseEvent;
import org.jboss.resteasy.reactive.client.SseEventFilter;
import org.jboss.resteasy.reactive.client.impl.AbstractRxInvoker;
import org.jboss.resteasy.reactive.client.impl.AsyncInvokerImpl;
import org.jboss.resteasy.reactive.client.impl.InvocationBuilderImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.impl.SseEventSourceImpl;
import org.jboss.resteasy.reactive.common.jaxrs.ResponseImpl;
import org.jboss.resteasy.reactive.common.util.RestMediaType;

public class MultiInvoker
extends AbstractRxInvoker<Multi<?>> {
    private final InvocationBuilderImpl invocationBuilder;

    public MultiInvoker(InvocationBuilderImpl target) {
        this.invocationBuilder = target;
    }

    @Override
    public <R> Multi<R> get(Class<R> responseType) {
        return (Multi)super.get(responseType);
    }

    @Override
    public <R> Multi<R> get(GenericType<R> responseType) {
        return (Multi)super.get(responseType);
    }

    @Override
    public <R> Multi<R> method(String name, Entity<?> entity, GenericType<R> responseType) {
        AsyncInvokerImpl invoker = (AsyncInvokerImpl)this.invocationBuilder.rx();
        return Multi.createFrom().emitter(emitter -> {
            MultiRequest multiRequest = new MultiRequest(emitter);
            RestClientRequestContext restClientRequestContext = invoker.performRequestInternal(name, entity, responseType, false);
            restClientRequestContext.getResult().handle((response, connectionError) -> {
                if (connectionError != null) {
                    emitter.fail(connectionError);
                } else {
                    HttpClientResponse vertxResponse = restClientRequestContext.getVertxClientResponse();
                    if (!emitter.isCancelled()) {
                        if (response.getStatus() == 200 && MediaType.SERVER_SENT_EVENTS_TYPE.isCompatible(response.getMediaType())) {
                            this.registerForSse(multiRequest, responseType, vertxResponse, (String)restClientRequestContext.getProperties().get("io.quarkus.rest.client.defaultContentType"), restClientRequestContext.getInvokedMethod());
                        } else if (response.getStatus() == 200 && RestMediaType.APPLICATION_STREAM_JSON_TYPE.isCompatible(response.getMediaType())) {
                            this.registerForJsonStream(multiRequest, restClientRequestContext, responseType, (ResponseImpl)response, vertxResponse);
                        } else {
                            this.registerForChunks(multiRequest, restClientRequestContext, responseType, (ResponseImpl)response, vertxResponse);
                        }
                        vertxResponse.resume();
                    } else {
                        vertxResponse.request().connection().close();
                    }
                }
                return null;
            });
        });
    }

    private boolean isNewlineDelimited(ResponseImpl response) {
        return RestMediaType.APPLICATION_STREAM_JSON_TYPE.isCompatible(response.getMediaType()) || RestMediaType.APPLICATION_NDJSON_TYPE.isCompatible(response.getMediaType());
    }

    private <R> void registerForSse(MultiRequest<? super R> multiRequest, GenericType<R> responseType, HttpClientResponse vertxResponse, String defaultContentType, Method invokedMethod) {
        boolean returnSseEvent = SseEvent.class.equals((Object)responseType.getRawType());
        GenericType responseTypeFirstParam = responseType.getType() instanceof ParameterizedType ? new GenericType(((ParameterizedType)responseType.getType()).getActualTypeArguments()[0]) : null;
        Predicate<SseEvent<String>> eventPredicate = this.createEventPredicate(invokedMethod);
        SseEventSourceImpl sseSource = new SseEventSourceImpl(this.invocationBuilder.getTarget(), this.invocationBuilder, Integer.MAX_VALUE, TimeUnit.SECONDS, defaultContentType);
        multiRequest.onCancel(() -> ((SseEventSourceImpl)sseSource).close());
        sseSource.register(event -> {
            boolean keep;
            if (eventPredicate != null && !(keep = eventPredicate.test(new SseEvent<String>(){

                @Override
                public String id() {
                    return event.getId();
                }

                @Override
                public String name() {
                    return event.getName();
                }

                @Override
                public String comment() {
                    return event.getComment();
                }

                @Override
                public String data() {
                    return event.readData();
                }
            }))) {
                return;
            }
            if (returnSseEvent) {
                multiRequest.emit(new SseEvent((InboundSseEvent)event, responseTypeFirstParam){
                    final /* synthetic */ InboundSseEvent val$event;
                    final /* synthetic */ GenericType val$responseTypeFirstParam;
                    {
                        this.val$event = inboundSseEvent;
                        this.val$responseTypeFirstParam = genericType;
                    }

                    @Override
                    public String id() {
                        return this.val$event.getId();
                    }

                    @Override
                    public String name() {
                        return this.val$event.getName();
                    }

                    @Override
                    public String comment() {
                        return this.val$event.getComment();
                    }

                    public Object data() {
                        if (this.val$responseTypeFirstParam != null) {
                            return this.val$event.readData(this.val$responseTypeFirstParam);
                        }
                        return this.val$event.readData();
                    }
                });
            } else {
                Object item = event.readData(responseType);
                if (item != null) {
                    multiRequest.emit(item);
                }
            }
        }, multiRequest::fail, multiRequest::complete);
        sseSource.registerAfterRequest(vertxResponse);
    }

    private Predicate<SseEvent<String>> createEventPredicate(Method invokedMethod) {
        if (invokedMethod == null) {
            return null;
        }
        SseEventFilter filterAnnotation = invokedMethod.getAnnotation(SseEventFilter.class);
        if (filterAnnotation == null) {
            return null;
        }
        try {
            return filterAnnotation.value().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private <R> void registerForChunks(final MultiRequest<? super R> multiRequest, final RestClientRequestContext restClientRequestContext, final GenericType<R> responseType, final ResponseImpl response, HttpClientResponse vertxClientResponse) {
        final boolean isNewlineDelimited = this.isNewlineDelimited(response);
        vertxClientResponse.exceptionHandler(t -> {
            if (t != ConnectionBase.CLOSED_EXCEPTION) {
                multiRequest.emitter.fail(t);
            }
        });
        vertxClientResponse.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer buffer) {
                try {
                    byte[] bytes = buffer.getBytes();
                    MediaType mediaType = response.getMediaType();
                    if (isNewlineDelimited) {
                        String charset = (String)mediaType.getParameters().get("charset");
                        charset = charset == null ? "UTF-8" : charset;
                        byte[] separator = "\n".getBytes(charset);
                        int start = 0;
                        while (start < bytes.length) {
                            int end = bytes.length;
                            for (int i = start; i < end; ++i) {
                                if (bytes[i] != separator[0]) continue;
                                boolean matches = true;
                                for (int j = 1; j < separator.length; ++j) {
                                    if (bytes[i + j] == separator[j]) continue;
                                    matches = false;
                                    break;
                                }
                                if (!matches) continue;
                                end = i;
                                break;
                            }
                            if (start < end) {
                                ByteArrayInputStream in = new ByteArrayInputStream(bytes, start, end);
                                Object item = restClientRequestContext.readEntity(in, responseType, mediaType, (MultivaluedMap<String, Object>)response.getMetadata());
                                multiRequest.emitter.emit(item);
                            }
                            start = end + separator.length;
                        }
                    } else {
                        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                        Object item = restClientRequestContext.readEntity(in, responseType, mediaType, (MultivaluedMap<String, Object>)response.getMetadata());
                        multiRequest.emitter.emit(item);
                    }
                }
                catch (Throwable t) {
                    multiRequest.emitter.fail(t);
                }
            }
        });
        vertxClientResponse.endHandler(v -> multiRequest.emitter.complete());
        multiRequest.onCancel(() -> vertxClientResponse.request().connection().close());
    }

    private <R> void registerForJsonStream(final MultiRequest<? super R> multiRequest, final RestClientRequestContext restClientRequestContext, final GenericType<R> responseType, final ResponseImpl response, HttpClientResponse vertxClientResponse) {
        RecordParser parser = RecordParser.newDelimited((String)"\n");
        parser.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer chunk) {
                ByteArrayInputStream in = new ByteArrayInputStream(chunk.getBytes());
                try {
                    Object item = restClientRequestContext.readEntity(in, responseType, response.getMediaType(), (MultivaluedMap<String, Object>)response.getMetadata());
                    multiRequest.emit(item);
                }
                catch (IOException e) {
                    multiRequest.fail(e);
                }
            }
        });
        vertxClientResponse.exceptionHandler(t -> {
            if (t != ConnectionBase.CLOSED_EXCEPTION) {
                multiRequest.fail((Throwable)t);
            }
        });
        vertxClientResponse.endHandler((Handler)new Handler<Void>(){

            public void handle(Void c) {
                multiRequest.complete();
            }
        });
        vertxClientResponse.handler((Handler)parser);
        multiRequest.onCancel(() -> vertxClientResponse.request().connection().close());
    }

    static class MultiRequest<R> {
        private final AtomicReference<Runnable> onCancel = new AtomicReference();
        private final MultiEmitter<? super R> emitter;
        private static final Runnable CLEARED = () -> {};

        public MultiRequest(MultiEmitter<? super R> emitter) {
            this.emitter = emitter;
            emitter.onTermination(() -> {
                if (emitter.isCancelled()) {
                    this.cancel();
                }
            });
        }

        void emit(R item) {
            if (!this.isCancelled()) {
                this.emitter.emit(item);
            }
        }

        void fail(Throwable t) {
            if (!this.isCancelled()) {
                this.emitter.fail(t);
                this.cancel();
            }
        }

        void complete() {
            if (!this.isCancelled()) {
                this.emitter.complete();
                this.cancel();
            }
        }

        public boolean isCancelled() {
            return this.onCancel.get() == CLEARED;
        }

        private void cancel() {
            Runnable action = this.onCancel.getAndSet(CLEARED);
            if (action != null && action != CLEARED) {
                action.run();
            }
        }

        public void onCancel(Runnable onCancel) {
            if (!this.onCancel.compareAndSet(null, onCancel)) {
                if (this.onCancel.get() == CLEARED) {
                    if (onCancel != null) {
                        onCancel.run();
                    }
                } else {
                    throw new IllegalArgumentException("onCancel was already called");
                }
            }
        }
    }
}

