/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.common.NotImplementedYet;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;

public class ClientRequestContextImpl
implements ClientRequestContext {
    private final Client client;
    private final ConfigurationImpl configuration;
    private OutputStream entityStream;
    private RestClientRequestContext restClientRequestContext;

    public ClientRequestContextImpl(RestClientRequestContext restClientRequestContext, ClientImpl client, ConfigurationImpl configuration) {
        this.restClientRequestContext = restClientRequestContext;
        this.client = client;
        this.configuration = configuration;
    }

    public Object getProperty(String name) {
        return this.restClientRequestContext.properties.get(name);
    }

    public Collection<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.restClientRequestContext.properties.keySet());
    }

    public void setProperty(String name, Object object) {
        this.restClientRequestContext.properties.put(name, object);
    }

    public void removeProperty(String name) {
        this.restClientRequestContext.properties.remove(name);
    }

    public URI getUri() {
        return this.restClientRequestContext.uri;
    }

    public void setUri(URI uri) {
        this.restClientRequestContext.uri = uri;
    }

    public String getMethod() {
        return this.restClientRequestContext.httpMethod;
    }

    public void setMethod(String method) {
        this.restClientRequestContext.httpMethod = method;
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.restClientRequestContext.requestHeaders.getHeaders();
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.restClientRequestContext.requestHeaders.asMap();
    }

    public String getHeaderString(String name) {
        return this.restClientRequestContext.requestHeaders.getHeader(name);
    }

    public Date getDate() {
        return this.restClientRequestContext.requestHeaders.getDate();
    }

    public Locale getLanguage() {
        return this.restClientRequestContext.entity != null ? this.restClientRequestContext.entity.getLanguage() : null;
    }

    public MediaType getMediaType() {
        return this.restClientRequestContext.entity != null ? this.restClientRequestContext.entity.getMediaType() : null;
    }

    public List<MediaType> getAcceptableMediaTypes() {
        List<MediaType> acceptableMediaTypes = this.restClientRequestContext.requestHeaders.getAcceptableMediaTypes();
        if (acceptableMediaTypes.isEmpty()) {
            return Collections.singletonList(MediaType.WILDCARD_TYPE);
        }
        return acceptableMediaTypes;
    }

    public List<Locale> getAcceptableLanguages() {
        return this.restClientRequestContext.requestHeaders.getAcceptableLanguages();
    }

    public Map<String, Cookie> getCookies() {
        return this.restClientRequestContext.requestHeaders.getCookies();
    }

    public boolean hasEntity() {
        return this.restClientRequestContext.entity != null;
    }

    public Object getEntity() {
        Entity<?> entity = this.restClientRequestContext.entity;
        if (entity != null) {
            Object ret = entity.getEntity();
            if (ret instanceof GenericEntity) {
                return ((GenericEntity)ret).getEntity();
            }
            return ret;
        }
        return null;
    }

    public Class<?> getEntityClass() {
        Entity<?> entity = this.restClientRequestContext.entity;
        if (entity != null) {
            Object ret = entity.getEntity();
            if (ret instanceof GenericEntity) {
                return ((GenericEntity)ret).getRawType();
            }
            return ret.getClass();
        }
        return null;
    }

    public Type getEntityType() {
        Entity<?> entity = this.restClientRequestContext.entity;
        if (entity != null) {
            Object ret = entity.getEntity();
            if (ret instanceof GenericEntity) {
                return ((GenericEntity)ret).getType();
            }
            return ret.getClass();
        }
        return null;
    }

    public void setEntity(Object entity) {
        this.setEntity(entity, Serialisers.NO_ANNOTATION, null);
    }

    public void setEntity(Object entity, Annotation[] annotations, MediaType mediaType) {
        this.restClientRequestContext.setEntity(entity, annotations, mediaType);
    }

    public Annotation[] getEntityAnnotations() {
        return this.restClientRequestContext.entity != null ? this.restClientRequestContext.entity.getAnnotations() : Serialisers.NO_ANNOTATION;
    }

    public OutputStream getEntityStream() {
        throw new NotImplementedYet();
    }

    public void setEntityStream(OutputStream outputStream) {
        throw new NotImplementedYet();
    }

    public Client getClient() {
        return this.client;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void abortWith(Response response) {
        this.restClientRequestContext.setAbortedWith(response);
    }

    public Response getAbortedWith() {
        return this.restClientRequestContext.getAbortedWith();
    }
}

