/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent.scopes;

import io.quarkus.qute.Mapper;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.debug.agent.frames.RemoteStackFrame;
import io.quarkus.qute.debug.agent.variables.VariablesHelper;
import io.quarkus.qute.debug.agent.variables.VariablesProvider;
import io.quarkus.qute.debug.agent.variables.VariablesRegistry;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.Variable;

public abstract class RemoteScope
extends Scope
implements VariablesProvider {
    public static final Scope[] EMPTY_SCOPES = new Scope[0];
    private final transient VariablesRegistry variablesRegistry;
    private transient Collection<Variable> variables;
    private final transient RemoteStackFrame frame;

    public RemoteScope(String name, RemoteStackFrame frame, VariablesRegistry variablesRegistry) {
        super.setName(name);
        this.frame = frame;
        this.variablesRegistry = variablesRegistry;
        variablesRegistry.addVariable(this);
    }

    @Override
    public Collection<Variable> getVariables() {
        if (this.variables == null) {
            this.variables = this.createVariables();
        }
        return this.variables;
    }

    protected abstract Collection<Variable> createVariables();

    protected static void fillVariables(RemoteStackFrame frame, ResolutionContext context, Collection<Variable> variables, VariablesRegistry variablesRegistry) {
        block2: {
            Object data;
            block3: {
                Object object = data = context != null ? context.getData() : null;
                if (data == null) break block2;
                if (!(data instanceof Map)) break block3;
                Map dataMap = (Map)data;
                for (Map.Entry entry : dataMap.entrySet()) {
                    String name = entry.getKey().toString();
                    Object value = entry.getValue();
                    VariablesHelper.fillVariable(name, value, frame, variables, variablesRegistry);
                }
                break block2;
            }
            if (!(data instanceof Mapper)) break block2;
            Mapper dataMapper = (Mapper)data;
            Set keys = dataMapper.mappedKeys();
            for (String name : keys) {
                CompletionStage value = dataMapper.getAsync(name);
                VariablesHelper.fillVariable(name, value, frame, variables, variablesRegistry);
            }
        }
    }

    public VariablesRegistry getVariablesRegistry() {
        return this.variablesRegistry;
    }

    public RemoteStackFrame getStackFrame() {
        return this.frame;
    }
}

