/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent.variables;

import io.quarkus.qute.debug.agent.frames.RemoteStackFrame;
import io.quarkus.qute.debug.agent.resolvers.ValueResolverContext;
import io.quarkus.qute.debug.agent.variables.VariablesHelper;
import io.quarkus.qute.debug.agent.variables.VariablesRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lsp4j.debug.Variable;

public class VariableContext
implements ValueResolverContext {
    private final Object base;
    private final RemoteStackFrame stackFrame;
    private final Collection<Variable> variables;
    private final VariablesRegistry variablesRegistry;
    private final Set<String> existingNames;

    public VariableContext(Object base, RemoteStackFrame stackFrame, VariablesRegistry variablesRegistry, Collection<Variable> variables) {
        this.base = base;
        this.stackFrame = stackFrame;
        this.variablesRegistry = variablesRegistry;
        this.variables = variables;
        this.existingNames = new HashSet<String>();
    }

    @Override
    public Object getBase() {
        return this.base;
    }

    @Override
    public RemoteStackFrame getStackFrame() {
        return this.stackFrame;
    }

    @Override
    public void addMethod(Method method) {
        String name = method.getName();
        if (this.exists(name)) {
            return;
        }
        Variable variable = new Variable();
        variable.setName(name);
        this.variables.add(variable);
    }

    @Override
    public void addProperty(Field field) {
        String name = field.getName();
        if (this.exists(name)) {
            return;
        }
        Object value = null;
        try {
            field.setAccessible(true);
            value = field.get(this.base);
        }
        catch (Exception exception) {
            // empty catch block
        }
        VariablesHelper.fillVariable(name, value, this.stackFrame, this.variables, this.variablesRegistry);
    }

    @Override
    public void addProperty(String property) {
        if (this.exists(property)) {
            return;
        }
        Variable variable = new Variable();
        variable.setName(property);
        this.variables.add(variable);
    }

    @Override
    public void addMethod(String method) {
        if (this.exists(method)) {
            return;
        }
        Variable variable = new Variable();
        variable.setName(method);
        this.variables.add(variable);
    }

    private boolean exists(String name) {
        return this.existingNames.contains(name);
    }

    @Override
    public boolean isCollectProperty() {
        return true;
    }

    @Override
    public boolean isCollectMethod() {
        return false;
    }
}

