/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent.evaluations;

import io.quarkus.qute.debug.agent.DebuggeeAgent;
import io.quarkus.qute.debug.agent.frames.RemoteStackFrame;
import io.quarkus.qute.debug.agent.variables.VariablesHelper;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.debug.EvaluateResponse;
import org.eclipse.lsp4j.debug.Variable;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;

public class EvaluationSupport {
    private static final Object IGNORE_RESULT = new Object();
    private final DebuggeeAgent agent;

    public EvaluationSupport(DebuggeeAgent agent) {
        this.agent = agent;
    }

    public CompletableFuture<EvaluateResponse> evaluate(Integer frameId, String expression, String context) {
        if (!this.agent.isEnabled()) {
            ResponseError re = new ResponseError();
            re.setCode(ResponseErrorCode.InvalidRequest);
            re.setMessage("Debuggee agent is not enabled.");
            throw new ResponseErrorException(re);
        }
        RemoteStackFrame frame = this.agent.findStackFrame(frameId);
        if (frame == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)frame.evaluate(expression).handle((result, error) -> {
            if (error != null) {
                if ("hover".equals(context)) {
                    return IGNORE_RESULT;
                }
                ResponseError re = new ResponseError();
                re.setCode(ResponseErrorCode.InvalidRequest);
                re.setMessage(error.getMessage());
                throw new ResponseErrorException(re);
            }
            return result;
        })).thenApply(result -> {
            EvaluateResponse response = new EvaluateResponse();
            if (result != null) {
                if (result != IGNORE_RESULT) {
                    response.setResult(result.toString());
                    if (VariablesHelper.shouldBeExpanded(result, frame)) {
                        Variable variable = VariablesHelper.fillVariable("", result, frame, null, this.agent.getVariablesRegistry());
                        response.setVariablesReference(variable.getVariablesReference());
                    }
                }
            } else {
                response.setResult("null");
            }
            return response;
        });
    }
}

