/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent.source;

import io.quarkus.qute.debug.agent.source.RemoteSource;
import io.quarkus.qute.debug.agent.source.SourceReferenceRegistry;
import java.net.URI;

public class JarSource
extends RemoteSource {
    public JarSource(URI uri, String templateId, SourceReferenceRegistry sourceReferenceRegistry) {
        super(uri, templateId);
        super.setSourceReference(Integer.valueOf(sourceReferenceRegistry.registerSourceReference(uri)));
    }

    @Override
    protected String computeName(URI uri) {
        String s = uri.toString();
        if (!s.startsWith("jar:file:")) {
            return super.computeName(uri);
        }
        s = s.substring("jar:file:/".length());
        while (s.startsWith("/")) {
            s = s.substring(1);
        }
        int jarIndex = s.lastIndexOf(".jar!");
        if (jarIndex == -1) {
            return super.computeName(uri);
        }
        int startIndex = s.lastIndexOf(47, jarIndex - 1);
        if (startIndex == -1) {
            return super.computeName(uri);
        }
        return s.substring(startIndex + 1);
    }
}

