/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent.completions;

import io.quarkus.qute.debug.agent.DebuggeeAgent;
import io.quarkus.qute.debug.agent.RemoteStackFrame;
import io.quarkus.qute.debug.agent.completions.CompletionContext;
import io.quarkus.qute.debug.agent.resolvers.ValueResolverRegistry;
import io.quarkus.qute.debug.agent.scopes.RemoteScope;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.debug.CompletionItem;
import org.eclipse.lsp4j.debug.CompletionItemType;
import org.eclipse.lsp4j.debug.CompletionsArguments;
import org.eclipse.lsp4j.debug.CompletionsResponse;
import org.eclipse.lsp4j.debug.Variable;

public class CompletionSupport {
    public static final CompletionItem[] EMPTY_COMPLETION_ITEMS = new CompletionItem[0];
    private final DebuggeeAgent agent;

    public CompletionSupport(DebuggeeAgent agent) {
        this.agent = agent;
    }

    public CompletableFuture<CompletionsResponse> completions(CompletionsArguments args) {
        Integer frameId;
        RemoteStackFrame stackFrame;
        if (this.agent.isEnabled() && (stackFrame = this.agent.findStackFrame(frameId = args.getFrameId())) != null) {
            CompletableFuture<Object> baseObject = this.getBaseObject(args.getText(), args.getColumn() - 1, stackFrame);
            if (baseObject != null) {
                return baseObject.handle((base, error) -> {
                    if (base == null || error != null) {
                        return this.getRootCompletions(stackFrame);
                    }
                    CompletionContext context = new CompletionContext(base, stackFrame);
                    ValueResolverRegistry.getInstance().fillWithValueResolvers(context);
                    return context.toResponse();
                });
            }
            CompletionsResponse response = this.getRootCompletions(stackFrame);
            return CompletableFuture.completedFuture(response);
        }
        CompletionsResponse response = new CompletionsResponse();
        response.setTargets(EMPTY_COMPLETION_ITEMS);
        return CompletableFuture.completedFuture(response);
    }

    private CompletionsResponse getRootCompletions(RemoteStackFrame stackFrame) {
        CompletionContext context = new CompletionContext(null, stackFrame);
        for (RemoteScope scope : stackFrame.getScopes()) {
            for (Variable variable : scope.getVariables()) {
                CompletionItem item = new CompletionItem();
                item.setLabel(variable.getName());
                item.setType(CompletionItemType.REFERENCE);
                context.add(item);
            }
        }
        return context.toResponse();
    }

    private CompletableFuture<Object> getBaseObject(String text, int column, RemoteStackFrame stackFrame) {
        if (text == null || text.isBlank() || column < 0 || column > text.length()) {
            return null;
        }
        String baseExpression = CompletionSupport.extractReceiverBeforeCaret(text, column - 1);
        if (baseExpression == null) {
            return null;
        }
        return stackFrame.evaluate(baseExpression);
    }

    public static String extractReceiverBeforeCaret(String expression, int caretOffset) {
        if (caretOffset > expression.length() || caretOffset <= 0) {
            return null;
        }
        boolean lastPart = true;
        int startOffset = -1;
        int endOffset = -1;
        int nbBracket = 0;
        int nbSquareBracket = 0;
        boolean inString = false;
        for (int i = caretOffset; i >= 0; --i) {
            char c = expression.charAt(i);
            if (c == '\'') {
                inString = !inString;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                if (endOffset != -1) continue;
                endOffset = i;
                continue;
            }
            if (inString) continue;
            if (c == '.') {
                if (!lastPart) continue;
                lastPart = false;
                endOffset = i;
                continue;
            }
            if (c == ')') {
                ++nbBracket;
                continue;
            }
            if (c == '(') {
                if (nbBracket == 0) {
                    startOffset = i + 1;
                    break;
                }
                --nbBracket;
                continue;
            }
            if (c == ']') {
                ++nbSquareBracket;
                continue;
            }
            if (c == '[') {
                if (nbSquareBracket == 0) {
                    startOffset = i + 1;
                    break;
                }
                --nbSquareBracket;
                continue;
            }
            startOffset = i + 1;
            break;
        }
        if (endOffset == -1) {
            return null;
        }
        if (startOffset == -1) {
            startOffset = 0;
        }
        return expression.substring(startOffset, endOffset);
    }
}

