/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent;

import io.quarkus.qute.Engine;
import io.quarkus.qute.debug.Debugger;
import io.quarkus.qute.debug.DebuggerListener;
import io.quarkus.qute.debug.DebuggerState;
import io.quarkus.qute.debug.StoppedEvent;
import io.quarkus.qute.debug.ThreadEvent;
import io.quarkus.qute.debug.agent.DebuggerTraceListener;
import io.quarkus.qute.debug.agent.RemoteStackFrame;
import io.quarkus.qute.debug.agent.RemoteThread;
import io.quarkus.qute.debug.agent.breakpoints.BreakpointsRegistry;
import io.quarkus.qute.debug.agent.breakpoints.RemoteBreakpoint;
import io.quarkus.qute.debug.agent.completions.CompletionSupport;
import io.quarkus.qute.debug.agent.evaluations.EvaluationSupport;
import io.quarkus.qute.debug.agent.scopes.RemoteScope;
import io.quarkus.qute.debug.agent.source.SourceReferenceRegistry;
import io.quarkus.qute.debug.agent.source.SourceTemplateRegistry;
import io.quarkus.qute.debug.agent.variables.VariablesRegistry;
import io.quarkus.qute.trace.ResolveEvent;
import io.quarkus.qute.trace.TemplateEvent;
import io.quarkus.qute.trace.TraceListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.CompletionsArguments;
import org.eclipse.lsp4j.debug.CompletionsResponse;
import org.eclipse.lsp4j.debug.EvaluateResponse;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.SourceBreakpoint;
import org.eclipse.lsp4j.debug.SourceResponse;
import org.eclipse.lsp4j.debug.StackTraceResponse;
import org.eclipse.lsp4j.debug.Variable;

public class DebuggeeAgent
implements Debugger {
    private final DebuggerTraceListener debugListener = new DebuggerTraceListener(this);
    private final BreakpointsRegistry breakpointsRegistry;
    private final Map<Integer, RemoteThread> debuggees = new ConcurrentHashMap<Integer, RemoteThread>();
    private final Collection<DebuggerListener> listeners = new ArrayList<DebuggerListener>();
    private final EvaluationSupport evaluationSupport;
    private final CompletionSupport completionSupport;
    private final VariablesRegistry variablesRegistry = new VariablesRegistry();
    private final Map<Engine, SourceTemplateRegistry> sourceTemplateRegistry;
    private final SourceReferenceRegistry sourceReferenceRegistry;
    private final Set<Engine> trackedEngine;
    private final Set<Engine> enginesWithDebugListener;
    private boolean enabled;

    public DebuggeeAgent() {
        this.breakpointsRegistry = new BreakpointsRegistry();
        this.sourceTemplateRegistry = new ConcurrentHashMap<Engine, SourceTemplateRegistry>();
        this.sourceReferenceRegistry = new SourceReferenceRegistry();
        this.trackedEngine = new HashSet<Engine>();
        this.enginesWithDebugListener = new HashSet<Engine>();
        this.evaluationSupport = new EvaluationSupport(this);
        this.completionSupport = new CompletionSupport(this);
    }

    public void track(Engine engine) {
        if (!this.trackedEngine.contains(engine)) {
            if (this.isEnabled()) {
                this.addDebugListener(engine);
            }
            this.trackedEngine.add(engine);
        }
    }

    @Override
    public DebuggerState getState(int threadId) {
        RemoteThread thread = this.getRemoteThread(threadId);
        return thread != null ? thread.getState() : DebuggerState.UNKNOWN;
    }

    @Override
    public void pause(int threadId) {
        RemoteThread thread = this.getRemoteThread(threadId);
        if (thread != null) {
            thread.pause();
        }
    }

    @Override
    public void resume(int threadId) {
        RemoteThread thread = this.getRemoteThread(threadId);
        if (thread != null) {
            thread.resume();
        }
    }

    public void onStartTemplate(TemplateEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        RemoteThread debuggee = this.getOrCreateDebuggeeThread();
        debuggee.start();
    }

    public void onTemplateNode(ResolveEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        OutputEventArguments args = new OutputEventArguments();
        args.setOutput(event.getTemplateNode().toString());
        args.setCategory("console");
        this.output(args);
        RemoteThread debuggee = this.getOrCreateDebuggeeThread();
        debuggee.onTemplateNode(event);
    }

    public void onEndTemplate(TemplateEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        RemoteThread debuggee = this.getOrCreateDebuggeeThread();
        this.debuggees.remove(debuggee.getId());
        debuggee.exit();
    }

    private RemoteThread getOrCreateDebuggeeThread() {
        Thread thread = Thread.currentThread();
        int threadId = (int)thread.getId();
        RemoteThread debuggee = this.getRemoteThread(threadId);
        if (debuggee == null) {
            debuggee = new RemoteThread(thread, this);
            this.debuggees.put(threadId, debuggee);
        }
        return debuggee;
    }

    private RemoteThread getRemoteThread(int threadId) {
        return this.debuggees.get(threadId);
    }

    @Override
    public Breakpoint[] setBreakpoints(SourceBreakpoint[] sourceBreakpoints, Source source) {
        return this.breakpointsRegistry.setBreakpoints(sourceBreakpoints, source);
    }

    @Override
    public org.eclipse.lsp4j.debug.Thread getThread(int threadId) {
        return this.debuggees.get(threadId);
    }

    @Override
    public org.eclipse.lsp4j.debug.Thread[] getThreads() {
        return this.debuggees.values().toArray(RemoteThread.EMPTY_THREAD);
    }

    RemoteBreakpoint getBreakpoint(URI sourceUri, String templateId, int line, Engine engine) {
        return this.breakpointsRegistry.resolveBreakpoint(sourceUri, templateId, line, this.getSourceTemplateRegistry(engine));
    }

    @Override
    public void addDebuggerListener(DebuggerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDebuggerListener(DebuggerListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.unlockAllDebuggeeThreads();
        }
    }

    void fireStoppedEvent(StoppedEvent event) {
        for (DebuggerListener listener : this.listeners) {
            try {
                listener.onStopped(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void fireThreadEvent(ThreadEvent event) {
        for (DebuggerListener listener : this.listeners) {
            try {
                listener.onThreadChanged(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void fireTerminateEvent() {
        for (DebuggerListener listener : this.listeners) {
            try {
                listener.onTerminate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void output(OutputEventArguments args) {
        for (DebuggerListener listener : this.listeners) {
            try {
                listener.output(args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void unlockAllDebuggeeThreads() {
        if (!this.debuggees.isEmpty()) {
            for (RemoteThread thread : this.debuggees.values()) {
                thread.terminate();
                this.fireThreadEvent(new ThreadEvent(thread.getId(), ThreadEvent.ThreadStatus.EXITED));
            }
            this.debuggees.clear();
        }
        if (!this.trackedEngine.isEmpty()) {
            this.trackedEngine.forEach(this::removeDebugListener);
            this.trackedEngine.clear();
        }
    }

    @Override
    public void terminate() {
        try {
            this.unlockAllDebuggeeThreads();
            this.sourceTemplateRegistry.clear();
            this.sourceReferenceRegistry.reset();
            this.breakpointsRegistry.reset();
        }
        finally {
            this.fireTerminateEvent();
        }
    }

    @Override
    public void stepIn(int threadId) {
        RemoteThread thread = this.getRemoteThread(threadId);
        if (thread != null) {
            thread.stepIn();
        }
    }

    @Override
    public void stepOut(int threadId) {
        RemoteThread thread = this.getRemoteThread(threadId);
        if (thread != null) {
            thread.stepOut();
        }
    }

    @Override
    public void stepOver(int threadId) {
        RemoteThread thread = this.getRemoteThread(threadId);
        if (thread != null) {
            thread.stepOver();
        }
    }

    @Override
    public void next(int threadId) {
        RemoteThread thread = this.getRemoteThread(threadId);
        if (thread != null) {
            thread.next();
        }
    }

    @Override
    public CompletableFuture<CompletionsResponse> completions(CompletionsArguments args) {
        return this.completionSupport.completions(args);
    }

    @Override
    public SourceResponse getSourceReference(int sourceReference) {
        return this.sourceReferenceRegistry.getSourceReference(sourceReference);
    }

    @Override
    public StackTraceResponse getStackFrames(int threadId, Integer startFrame, Integer levels) {
        StackTraceResponse response = new StackTraceResponse();
        RemoteThread thread = this.getRemoteThread(threadId);
        if (thread != null) {
            List<RemoteStackFrame> frames = thread.getStackFrames();
            if (startFrame != null || levels != null) {
                int startIndex = startFrame != null ? startFrame : 0;
                int endIndex = Math.min(startIndex + (levels != null ? levels.intValue() : frames.size()), frames.size());
                response.setStackFrames(thread.getStackFrames().subList(startIndex, endIndex).toArray(RemoteStackFrame.EMPTY_STACK_FRAMES));
            } else {
                response.setStackFrames(frames.toArray(RemoteStackFrame.EMPTY_STACK_FRAMES));
            }
            response.setTotalFrames(Integer.valueOf(frames.size()));
        } else {
            response.setStackFrames(RemoteStackFrame.EMPTY_STACK_FRAMES);
            response.setTotalFrames(Integer.valueOf(0));
        }
        return response;
    }

    @Override
    public Scope[] getScopes(int frameId) {
        for (RemoteThread thread : this.debuggees.values()) {
            RemoteStackFrame frame = thread.getStackFrame(frameId);
            if (frame == null) continue;
            return frame.getScopes().toArray(RemoteScope.EMPTY_SCOPES);
        }
        return RemoteScope.EMPTY_SCOPES;
    }

    @Override
    public Variable[] getVariables(int variablesReference) {
        return this.variablesRegistry.getVariables(variablesReference);
    }

    @Override
    public CompletableFuture<EvaluateResponse> evaluate(Integer frameId, String expression, String context) {
        return this.evaluationSupport.evaluate(frameId, expression, context);
    }

    public RemoteStackFrame findStackFrame(Integer frameId) {
        if (frameId == null) {
            return null;
        }
        for (RemoteThread thread : this.debuggees.values()) {
            RemoteStackFrame frame = thread.getStackFrame(frameId);
            if (frame == null) continue;
            return frame;
        }
        return null;
    }

    public VariablesRegistry getVariablesRegistry() {
        return this.variablesRegistry;
    }

    public SourceTemplateRegistry getSourceTemplateRegistry(Engine engine) {
        return this.sourceTemplateRegistry.computeIfAbsent(engine, k -> new SourceTemplateRegistry(this.breakpointsRegistry, this.sourceReferenceRegistry, engine));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.trackedEngine.forEach(this::addDebugListener);
        } else {
            this.trackedEngine.forEach(this::removeDebugListener);
        }
    }

    private void addDebugListener(Engine engine) {
        if (engine.getTraceManager() != null && !this.enginesWithDebugListener.contains(engine)) {
            engine.addTraceListener((TraceListener)this.debugListener);
            this.enginesWithDebugListener.add(engine);
        }
    }

    private void removeDebugListener(Engine engine) {
        if (engine.getTraceManager() != null) {
            engine.removeTraceListener((TraceListener)this.debugListener);
            this.enginesWithDebugListener.remove(engine);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void reset() {
        this.unlockAllDebuggeeThreads();
        this.sourceTemplateRegistry.clear();
        this.sourceReferenceRegistry.reset();
    }
}

