/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.InvokerFactoryBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InvokerInfo;
import io.quarkus.arc.processor.KotlinDotNames;
import io.quarkus.arc.processor.KotlinUtils;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.Types;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.execannotations.ExecutionModelAnnotationsAllowedBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.security.spi.ClassSecurityCheckAnnotationBuildItem;
import io.quarkus.security.spi.ClassSecurityCheckStorageBuildItem;
import io.quarkus.security.spi.PermissionsAllowedMetaAnnotationBuildItem;
import io.quarkus.security.spi.SecurityTransformerUtils;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.quarkus.websockets.next.HttpUpgradeCheck;
import io.quarkus.websockets.next.InboundProcessingMode;
import io.quarkus.websockets.next.WebSocketClientConnection;
import io.quarkus.websockets.next.WebSocketClientException;
import io.quarkus.websockets.next.WebSocketConnection;
import io.quarkus.websockets.next.WebSocketException;
import io.quarkus.websockets.next.WebSocketServerException;
import io.quarkus.websockets.next.deployment.Callback;
import io.quarkus.websockets.next.deployment.CallbackArgument;
import io.quarkus.websockets.next.deployment.CallbackArgumentBuildItem;
import io.quarkus.websockets.next.deployment.CallbackArgumentsBuildItem;
import io.quarkus.websockets.next.deployment.CloseReasonCallbackArgument;
import io.quarkus.websockets.next.deployment.ConnectionCallbackArgument;
import io.quarkus.websockets.next.deployment.ErrorCallbackArgument;
import io.quarkus.websockets.next.deployment.GeneratedEndpointBuildItem;
import io.quarkus.websockets.next.deployment.GlobalErrorHandlersBuildItem;
import io.quarkus.websockets.next.deployment.HandshakeRequestCallbackArgument;
import io.quarkus.websockets.next.deployment.KotlinContinuationCallbackArgument;
import io.quarkus.websockets.next.deployment.MessageCallbackArgument;
import io.quarkus.websockets.next.deployment.PathParamCallbackArgument;
import io.quarkus.websockets.next.deployment.WebSocketDotNames;
import io.quarkus.websockets.next.deployment.WebSocketEndpointBuildItem;
import io.quarkus.websockets.next.deployment.config.WebSocketsServerBuildConfig;
import io.quarkus.websockets.next.runtime.BasicWebSocketConnectorImpl;
import io.quarkus.websockets.next.runtime.ClientConnectionManager;
import io.quarkus.websockets.next.runtime.Codecs;
import io.quarkus.websockets.next.runtime.ConnectionManager;
import io.quarkus.websockets.next.runtime.ContextSupport;
import io.quarkus.websockets.next.runtime.JsonTextMessageCodec;
import io.quarkus.websockets.next.runtime.SecuritySupport;
import io.quarkus.websockets.next.runtime.WebSocketClientRecorder;
import io.quarkus.websockets.next.runtime.WebSocketConnectionBase;
import io.quarkus.websockets.next.runtime.WebSocketConnectorImpl;
import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.WebSocketEndpointBase;
import io.quarkus.websockets.next.runtime.WebSocketHeaderPropagationHandler;
import io.quarkus.websockets.next.runtime.WebSocketHttpServerOptionsCustomizer;
import io.quarkus.websockets.next.runtime.WebSocketServerRecorder;
import io.quarkus.websockets.next.runtime.kotlin.ApplicationCoroutineScope;
import io.quarkus.websockets.next.runtime.kotlin.CoroutineInvoker;
import io.quarkus.websockets.next.runtime.telemetry.ErrorInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.MetricsBuilderCustomizer;
import io.quarkus.websockets.next.runtime.telemetry.TracesBuilderCustomizer;
import io.quarkus.websockets.next.runtime.telemetry.WebSocketTelemetryProvider;
import io.quarkus.websockets.next.runtime.telemetry.WebSocketTelemetryProviderBuilder;
import io.quarkus.websockets.next.runtime.telemetry.WebSocketTelemetryRecorder;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniCreate;
import io.smallrye.mutiny.groups.UniOnFailure;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.invoke.Invoker;
import jakarta.inject.Singleton;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;

public class WebSocketProcessor {
    static final String SERVER_ENDPOINT_SUFFIX = "_WebSocketServerEndpoint";
    static final String CLIENT_ENDPOINT_SUFFIX = "_WebSocketClientEndpoint";
    static final String NESTED_SEPARATOR = "$_";
    static final DotName HTTP_UPGRADE_CHECK_NAME = DotName.createSimple(HttpUpgradeCheck.class);
    private static final Pattern PATH_PARAM_PATTERN = Pattern.compile("\\{[a-zA-Z0-9_]+\\}");
    public static final Pattern TRANSLATED_PATH_PARAM_PATTERN = Pattern.compile(":[a-zA-Z0-9_]+");

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("websockets-next");
    }

    @BuildStep
    void beanDefiningAnnotations(BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(WebSocketDotNames.WEB_SOCKET, DotNames.SINGLETON));
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(WebSocketDotNames.WEB_SOCKET_CLIENT, DotNames.SINGLETON));
    }

    @BuildStep
    AutoAddScopeBuildItem addScopeToGlobalErrorHandlers() {
        return AutoAddScopeBuildItem.builder().containsAnnotations(new DotName[]{WebSocketDotNames.ON_ERROR}).unremovable().reason("Add @Singleton to a global WebSocket error handler").defaultScope(BuiltinScope.SINGLETON).build();
    }

    @BuildStep
    ExecutionModelAnnotationsAllowedBuildItem executionModelAnnotations(final TransformedAnnotationsBuildItem transformedAnnotations) {
        return new ExecutionModelAnnotationsAllowedBuildItem((Predicate)new Predicate<MethodInfo>(){

            @Override
            public boolean test(MethodInfo method) {
                return Annotations.containsAny((Collection)transformedAnnotations.getAnnotations((AnnotationTarget)method), WebSocketDotNames.CALLBACK_ANNOTATIONS);
            }
        });
    }

    @BuildStep
    CallbackArgumentsBuildItem collectCallbackArguments(List<CallbackArgumentBuildItem> callbackArguments) {
        ArrayList<CallbackArgument> sorted = new ArrayList<CallbackArgument>();
        for (CallbackArgumentBuildItem callbackArgument : callbackArguments) {
            sorted.add(callbackArgument.getProvider());
        }
        sorted.sort(Comparator.comparingInt(CallbackArgument::priotity).reversed());
        return new CallbackArgumentsBuildItem(sorted);
    }

    @BuildStep
    void additionalBeans(CombinedIndexBuildItem combinedIndex, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        IndexView index = combinedIndex.getIndex();
        AdditionalBeanBuildItem removable = AdditionalBeanBuildItem.builder().setRemovable().addBeanClasses(new Class[]{WebSocketConnectorImpl.class, JsonTextMessageCodec.class}).build();
        additionalBeans.produce((BuildItem)removable);
        AdditionalBeanBuildItem.Builder unremovable = AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{Codecs.class, ClientConnectionManager.class, BasicWebSocketConnectorImpl.class});
        if (!index.getAnnotations(WebSocketDotNames.WEB_SOCKET).isEmpty()) {
            unremovable.addBeanClasses(new Class[]{ConnectionManager.class, WebSocketHttpServerOptionsCustomizer.class});
        }
        additionalBeans.produce((BuildItem)unremovable.build());
    }

    @BuildStep
    void produceCoroutineScope(BuildProducer<AdditionalBeanBuildItem> additionalBean) {
        if (!QuarkusClassLoader.isClassPresentAtRuntime((String)"kotlinx.coroutines.CoroutineScope")) {
            return;
        }
        additionalBean.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(ApplicationCoroutineScope.class).setUnremovable().build());
    }

    @BuildStep
    void builtinCallbackArguments(BuildProducer<CallbackArgumentBuildItem> providers) {
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new MessageCallbackArgument()));
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new ConnectionCallbackArgument()));
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new PathParamCallbackArgument()));
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new HandshakeRequestCallbackArgument()));
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new ErrorCallbackArgument()));
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new CloseReasonCallbackArgument()));
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new KotlinContinuationCallbackArgument()));
    }

    @BuildStep
    void collectGlobalErrorHandlers(BeanArchiveIndexBuildItem beanArchiveIndex, BeanDiscoveryFinishedBuildItem beanDiscoveryFinished, BuildProducer<GlobalErrorHandlersBuildItem> globalErrorHandlers, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations) {
        IndexView index = beanArchiveIndex.getIndex();
        HashMap<DotName, GlobalErrorHandler> globalErrors = new HashMap<DotName, GlobalErrorHandler>();
        for (BeanInfo bean : beanDiscoveryFinished.beanStream().classBeans()) {
            ClassInfo beanClass = ((AnnotationTarget)bean.getTarget().get()).asClass();
            if (beanClass.declaredAnnotation(WebSocketDotNames.WEB_SOCKET) != null || beanClass.declaredAnnotation(WebSocketDotNames.WEB_SOCKET_CLIENT) != null) continue;
            for (Callback callback : WebSocketProcessor.findErrorHandlers(Callback.Target.UNDEFINED, index, bean, beanClass, callbackArguments, transformedAnnotations, null)) {
                GlobalErrorHandler errorHandler = new GlobalErrorHandler(bean, callback);
                DotName errorTypeName = callback.argumentType(ErrorCallbackArgument::isError).name();
                if (globalErrors.containsKey(errorTypeName)) {
                    throw new WebSocketException(String.format("Multiple global @OnError callbacks may not accept the same error parameter: %s\n\t- %s\n\t- %s", errorTypeName, callback.asString(), ((GlobalErrorHandler)globalErrors.get((Object)errorTypeName)).callback.asString()));
                }
                globalErrors.put(errorTypeName, errorHandler);
            }
        }
        globalErrorHandlers.produce((BuildItem)new GlobalErrorHandlersBuildItem(List.copyOf(globalErrors.values())));
    }

    @BuildStep
    public void collectEndpoints(BeanArchiveIndexBuildItem beanArchiveIndex, BeanDiscoveryFinishedBuildItem beanDiscoveryFinished, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<WebSocketEndpointBuildItem> endpoints) {
        IndexView index = beanArchiveIndex.getIndex();
        HashMap<String, DotName> serverIdToEndpoint = new HashMap<String, DotName>();
        HashMap<String, DotName> serverPathToEndpoint = new HashMap<String, DotName>();
        HashMap<String, DotName> clientIdToEndpoint = new HashMap<String, DotName>();
        HashMap<String, DotName> clientPathToEndpoint = new HashMap<String, DotName>();
        for (BeanInfo bean : beanDiscoveryFinished.beanStream().classBeans()) {
            org.jboss.jandex.Type effectiveMessageType;
            AnnotationValue inboundProcessingMode;
            String id;
            String path;
            Callback.Target target;
            ClassInfo beanClass = ((AnnotationTarget)bean.getTarget().get()).asClass();
            AnnotationInstance webSocketAnnotation = beanClass.annotation(WebSocketDotNames.WEB_SOCKET);
            AnnotationInstance webSocketClientAnnotation = beanClass.annotation(WebSocketDotNames.WEB_SOCKET_CLIENT);
            if (webSocketAnnotation == null && webSocketClientAnnotation == null) continue;
            if (webSocketAnnotation != null && webSocketClientAnnotation != null) {
                throw new WebSocketException("Endpoint class may not be annotated with both @WebSocket and @WebSocketClient: " + String.valueOf(beanClass));
            }
            if (webSocketAnnotation != null) {
                target = Callback.Target.SERVER;
                path = WebSocketProcessor.getPath(webSocketAnnotation.value("path").asString());
                if (beanClass.nestingType() == ClassInfo.NestingType.INNER) {
                    path = WebSocketProcessor.mergePath(WebSocketProcessor.getPathPrefix(index, beanClass.enclosingClass()), path);
                }
                if ((prevPath = serverPathToEndpoint.put(path, beanClass.name())) != null) {
                    throw new WebSocketServerException(String.format("Multiple endpoints [%s, %s] define the same path: %s", prevPath, beanClass, path));
                }
                AnnotationValue endpointIdValue = webSocketAnnotation.value("endpointId");
                id = endpointIdValue == null ? beanClass.name().toString() : endpointIdValue.asString();
                prevId = serverIdToEndpoint.put(id, beanClass.name());
                if (prevId != null) {
                    throw new WebSocketServerException(String.format("Multiple endpoints [%s, %s] define the same endpoint id: %s", prevId, beanClass, id));
                }
                inboundProcessingMode = webSocketAnnotation.value("inboundProcessingMode");
            } else {
                target = Callback.Target.CLIENT;
                path = WebSocketProcessor.getPath(webSocketClientAnnotation.value("path").asString());
                prevPath = clientPathToEndpoint.put(path, beanClass.name());
                if (prevPath != null) {
                    throw new WebSocketServerException(String.format("Multiple client endpoints [%s, %s] define the same path: %s", prevPath, beanClass, path));
                }
                AnnotationValue clientIdValue = webSocketClientAnnotation.value("clientId");
                id = clientIdValue == null ? beanClass.name().toString() : clientIdValue.asString();
                prevId = clientIdToEndpoint.put(id, beanClass.name());
                if (prevId != null) {
                    throw new WebSocketServerException(String.format("Multiple client endpoints [%s, %s] define the same endpoint id: %s", prevId, beanClass, id));
                }
                inboundProcessingMode = webSocketClientAnnotation.value("inboundProcessingMode");
            }
            Callback onOpen = WebSocketProcessor.findCallback(target, beanArchiveIndex.getIndex(), bean, beanClass, WebSocketDotNames.ON_OPEN, callbackArguments, transformedAnnotations, path);
            Callback onTextMessage = WebSocketProcessor.findCallback(target, beanArchiveIndex.getIndex(), bean, beanClass, WebSocketDotNames.ON_TEXT_MESSAGE, callbackArguments, transformedAnnotations, path);
            Callback onBinaryMessage = WebSocketProcessor.findCallback(target, beanArchiveIndex.getIndex(), bean, beanClass, WebSocketDotNames.ON_BINARY_MESSAGE, callbackArguments, transformedAnnotations, path);
            Callback onPingMessage = WebSocketProcessor.findCallback(target, beanArchiveIndex.getIndex(), bean, beanClass, WebSocketDotNames.ON_PING_MESSAGE, callbackArguments, transformedAnnotations, path, this::validateOnPingMessage);
            Callback onPongMessage = WebSocketProcessor.findCallback(target, beanArchiveIndex.getIndex(), bean, beanClass, WebSocketDotNames.ON_PONG_MESSAGE, callbackArguments, transformedAnnotations, path, this::validateOnPongMessage);
            Callback onClose = WebSocketProcessor.findCallback(target, beanArchiveIndex.getIndex(), bean, beanClass, WebSocketDotNames.ON_CLOSE, callbackArguments, transformedAnnotations, path, this::validateOnClose);
            if (onOpen == null && onTextMessage == null && onBinaryMessage == null && onPingMessage == null && onPongMessage == null) {
                throw new WebSocketServerException("The endpoint must declare at least one method annotated with @OnTextMessage, @OnBinaryMessage, @OnPingMessage, @OnPongMessage or @OnOpen: " + String.valueOf(beanClass));
            }
            if (onTextMessage != null && (effectiveMessageType = onTextMessage.isKotlinSuspendFunction() ? (onTextMessage.isReturnTypeUni() ? (org.jboss.jandex.Type)onTextMessage.returnType().asParameterizedType().arguments().get(0) : KotlinUtils.getKotlinSuspendMethodResult((MethodInfo)onTextMessage.method)) : (onTextMessage.isReturnTypeUni() || onTextMessage.isReturnTypeMulti() ? (org.jboss.jandex.Type)onTextMessage.returnType().asParameterizedType().arguments().get(0) : onTextMessage.returnType())).kind() != Type.Kind.VOID && onTextMessage.getOutputCodec() == null) {
                reflectiveHierarchy.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((org.jboss.jandex.Type)effectiveMessageType).build());
            }
            endpoints.produce((BuildItem)new WebSocketEndpointBuildItem(target == Callback.Target.CLIENT, bean, path, id, inboundProcessingMode != null ? InboundProcessingMode.valueOf((String)inboundProcessingMode.asEnum()) : InboundProcessingMode.SERIAL, onOpen, onTextMessage, onBinaryMessage, onPingMessage, onPongMessage, onClose, WebSocketProcessor.findErrorHandlers(target, index, bean, beanClass, callbackArguments, transformedAnnotations, path)));
        }
    }

    @BuildStep
    public void validateConnectorInjectionPoints(List<WebSocketEndpointBuildItem> endpoints, ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        for (InjectionPointInfo injectionPoint : validationPhase.getContext().getInjectionPoints()) {
            if (!injectionPoint.getRequiredType().name().equals((Object)WebSocketDotNames.WEB_SOCKET_CONNECTOR) || !injectionPoint.hasDefaultedQualifier()) continue;
            org.jboss.jandex.Type clientEndpointType = (org.jboss.jandex.Type)injectionPoint.getRequiredType().asParameterizedType().arguments().get(0);
            if (!endpoints.stream().filter(WebSocketEndpointBuildItem::isClient).map(WebSocketEndpointBuildItem::beanClassName).noneMatch(arg_0 -> ((DotName)clientEndpointType.name()).equals(arg_0))) continue;
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new WebSocketClientException(String.format("Type argument [%s] of the injected WebSocketConnector is not a @WebSocketClient endpoint: %s", clientEndpointType, injectionPoint.getTargetInfo()))}));
        }
    }

    @BuildStep
    public void generateEndpoints(BeanArchiveIndexBuildItem index, List<WebSocketEndpointBuildItem> endpoints, CallbackArgumentsBuildItem argumentProviders, TransformedAnnotationsBuildItem transformedAnnotations, GlobalErrorHandlersBuildItem globalErrorHandlers, InvokerFactoryBuildItem invokerFactory, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<GeneratedEndpointBuildItem> generatedEndpoints, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        boolean metricsSupportEnabled = WebSocketProcessor.isMetricsSupportEnabled(metricsCapability);
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, (Function)new Function<String, String>(){

            @Override
            public String apply(String name) {
                int idx = name.indexOf(WebSocketProcessor.CLIENT_ENDPOINT_SUFFIX);
                if (idx == -1) {
                    idx = name.indexOf(WebSocketProcessor.SERVER_ENDPOINT_SUFFIX);
                }
                if (idx != -1) {
                    name = name.substring(0, idx);
                }
                if (name.contains(WebSocketProcessor.NESTED_SEPARATOR)) {
                    name = name.replace(WebSocketProcessor.NESTED_SEPARATOR, "$");
                }
                return name;
            }
        });
        for (WebSocketEndpointBuildItem endpoint : endpoints) {
            String generatedName = WebSocketProcessor.generateEndpoint(endpoint, argumentProviders, transformedAnnotations, index.getIndex(), (ClassOutput)classOutput, globalErrorHandlers, endpoint.isClient() ? CLIENT_ENDPOINT_SUFFIX : SERVER_ENDPOINT_SUFFIX, invokerFactory, metricsSupportEnabled);
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{generatedName}).constructors().build());
            generatedEndpoints.produce((BuildItem)new GeneratedEndpointBuildItem(endpoint.id, endpoint.bean.getImplClazz().name().toString(), generatedName, endpoint.path, endpoint.isClient));
        }
    }

    @Consume.List(value={@Consume(value=RuntimeConfigSetupCompleteBuildItem.class), @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    public void registerRoutes(WebSocketServerRecorder recorder, List<WebSocketEndpointBuildItem> endpoints, List<GeneratedEndpointBuildItem> generatedEndpoints, WebSocketsServerBuildConfig config, ValidationPhaseBuildItem validationPhase, BuildProducer<RouteBuildItem> routes, Optional<PermissionsAllowedMetaAnnotationBuildItem> metaPermissionsAllowed, EndpointSecurityChecksBuildItem endpointSecurityChecks, Capabilities capabilities) {
        boolean securityEnabled = capabilities.isPresent("io.quarkus.security");
        for (GeneratedEndpointBuildItem endpoint : generatedEndpoints.stream().filter(GeneratedEndpointBuildItem::isServer).toList()) {
            boolean httpUpgradeSecured = endpointSecurityChecks.endpointIdToSecurityCheck.containsKey(endpoint.endpointId);
            RouteBuildItem.Builder builder = RouteBuildItem.builder().route(endpoint.path).displayOnNotFoundPage("WebSocket Endpoint").handlerType(HandlerType.NORMAL).handler(recorder.createEndpointHandler(endpoint.generatedClassName, endpoint.endpointId, this.activateContext(config.activateRequestContext(), BuiltinScope.REQUEST.getInfo(), endpoint.endpointId, endpoints, validationPhase.getBeanResolver(), metaPermissionsAllowed, securityEnabled, httpUpgradeSecured), this.activateContext(config.activateSessionContext(), new ScopeInfo(DotName.createSimple(SessionScoped.class), true), endpoint.endpointId, endpoints, validationPhase.getBeanResolver(), metaPermissionsAllowed, securityEnabled, httpUpgradeSecured), endpoint.path));
            routes.produce((BuildItem)builder.build());
        }
    }

    private boolean activateContext(WebSocketsServerBuildConfig.ContextActivation activation, ScopeInfo scope, String endpointId, List<WebSocketEndpointBuildItem> endpoints, BeanResolver beanResolver, Optional<PermissionsAllowedMetaAnnotationBuildItem> metaPermissionsAllowed, boolean securityEnabled, boolean httpUpgradeSecured) {
        return switch (activation) {
            case WebSocketsServerBuildConfig.ContextActivation.ALWAYS -> true;
            case WebSocketsServerBuildConfig.ContextActivation.AUTO -> this.needsContext(this.findEndpoint((String)endpointId, endpoints).bean, scope, new HashSet<String>(), beanResolver, metaPermissionsAllowed, securityEnabled, httpUpgradeSecured);
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)activation));
        };
    }

    private WebSocketEndpointBuildItem findEndpoint(String endpointId, List<WebSocketEndpointBuildItem> endpoints) {
        for (WebSocketEndpointBuildItem endpoint : endpoints) {
            if (!endpoint.id.equals(endpointId)) continue;
            return endpoint;
        }
        throw new IllegalArgumentException("Endpoint not found: " + endpointId);
    }

    private boolean needsContext(BeanInfo bean, ScopeInfo scope, Set<String> processedBeans, BeanResolver beanResolver, Optional<PermissionsAllowedMetaAnnotationBuildItem> metaPermissionsAllowed, boolean securityEnabled, boolean httpUpgradeSecured) {
        if (processedBeans.add(bean.getIdentifier())) {
            if (scope.equals((Object)bean.getScope())) {
                return true;
            }
            if (securityEnabled && BuiltinScope.REQUEST.is(scope) && bean.isClassBean() && bean.hasAroundInvokeInterceptors() && WebSocketProcessor.hasSecurityAnnNotOnHttpUpgrade(((AnnotationTarget)bean.getTarget().get()).asClass(), metaPermissionsAllowed, httpUpgradeSecured)) {
                return true;
            }
            for (InjectionPointInfo injectionPoint : bean.getAllInjectionPoints()) {
                BeanInfo dependency = injectionPoint.getResolvedBean();
                if (dependency != null) {
                    if (!this.needsContext(dependency, scope, processedBeans, beanResolver, metaPermissionsAllowed, securityEnabled, false)) continue;
                    return true;
                }
                org.jboss.jandex.Type requiredType = null;
                HashSet qualifiers = null;
                if (BuiltinBean.INSTANCE.matches(injectionPoint)) {
                    requiredType = injectionPoint.getRequiredType();
                    qualifiers = injectionPoint.getRequiredQualifiers();
                } else if (BuiltinBean.LIST.matches(injectionPoint)) {
                    requiredType = (org.jboss.jandex.Type)injectionPoint.getRequiredType().asParameterizedType().arguments().get(0);
                    qualifiers = new HashSet(injectionPoint.getRequiredQualifiers());
                    Iterator it = qualifiers.iterator();
                    while (it.hasNext()) {
                        if (!((AnnotationInstance)it.next()).name().equals((Object)DotNames.ALL)) continue;
                        it.remove();
                    }
                }
                if (requiredType == null) continue;
                for (BeanInfo lookupDependency : beanResolver.resolveBeans(requiredType, (Set)qualifiers)) {
                    if (!this.needsContext(lookupDependency, scope, processedBeans, beanResolver, metaPermissionsAllowed, securityEnabled, false)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasSecurityAnnNotOnHttpUpgrade(ClassInfo classInfo, Optional<PermissionsAllowedMetaAnnotationBuildItem> metaPermissionsAllowed, boolean httpUpgradeSecured) {
        List<AnnotationInstance> annotations = httpUpgradeSecured ? classInfo.annotations().stream().filter(ai -> ai.target() != null && ai.target().kind() == AnnotationTarget.Kind.METHOD).toList() : classInfo.annotations();
        return SecurityTransformerUtils.hasSecurityAnnotation((Collection)annotations) || metaPermissionsAllowed.get().hasPermissionsAllowed(annotations);
    }

    @BuildStep
    UnremovableBeanBuildItem makeHttpUpgradeChecksUnremovable() {
        return UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{HTTP_UPGRADE_CHECK_NAME});
    }

    @BuildStep
    List<ValidationPhaseBuildItem.ValidationErrorBuildItem> validateHttpUpgradeCheckNotRequestScoped(ValidationPhaseBuildItem validationPhase) {
        return validationPhase.getContext().beans().withBeanType(HTTP_UPGRADE_CHECK_NAME).filter(b -> {
            BuiltinScope targetScope = BuiltinScope.from((DotName)b.getScope().getDotName());
            return BuiltinScope.APPLICATION != targetScope && BuiltinScope.SINGLETON != targetScope && BuiltinScope.DEPENDENT != targetScope;
        }).stream().map(b -> new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new RuntimeException("Bean '%s' scope is '%s', but the '%s' implementors must be one either `@ApplicationScoped', '@Singleton' or '@Dependent' beans".formatted(b.getBeanClass(), b.getScope().getDotName(), HTTP_UPGRADE_CHECK_NAME))})).toList();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void serverSyntheticBeans(WebSocketServerRecorder recorder, List<GeneratedEndpointBuildItem> generatedEndpoints, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        List<GeneratedEndpointBuildItem> serverEndpoints = generatedEndpoints.stream().filter(GeneratedEndpointBuildItem::isServer).toList();
        if (serverEndpoints.isEmpty()) {
            return;
        }
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(WebSocketConnection.class).scope(SessionScoped.class)).setRuntimeInit().supplier(recorder.connectionSupplier()).unremovable()).done());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void clientSyntheticBeans(WebSocketClientRecorder recorder, List<GeneratedEndpointBuildItem> generatedEndpoints, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        List<GeneratedEndpointBuildItem> clientEndpoints = generatedEndpoints.stream().filter(GeneratedEndpointBuildItem::isClient).toList();
        if (!clientEndpoints.isEmpty()) {
            syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(WebSocketClientConnection.class).scope(SessionScoped.class)).setRuntimeInit().supplier(recorder.connectionSupplier()).unremovable()).done());
        }
        HashMap<String, WebSocketClientRecorder.ClientEndpoint> endpointMap = new HashMap<String, WebSocketClientRecorder.ClientEndpoint>();
        for (GeneratedEndpointBuildItem generatedEndpoint : clientEndpoints) {
            endpointMap.put(generatedEndpoint.endpointClassName, new WebSocketClientRecorder.ClientEndpoint(generatedEndpoint.endpointId, WebSocketProcessor.getOriginalPath(generatedEndpoint.path), generatedEndpoint.generatedClassName));
        }
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(WebSocketClientRecorder.ClientEndpointsContext.class).setRuntimeInit().supplier(recorder.createContext(endpointMap)).done());
    }

    @BuildStep
    void createSecurityChecksForHttpUpgradeCheck(Capabilities capabilities, BuildProducer<ClassSecurityCheckAnnotationBuildItem> producer) {
        if (capabilities.isPresent("io.quarkus.security")) {
            producer.produce((BuildItem)new ClassSecurityCheckAnnotationBuildItem(WebSocketDotNames.WEB_SOCKET));
        }
    }

    @BuildStep
    void preventRepeatedSecurityChecksForHttpUpgrade(Capabilities capabilities, BuildProducer<AnnotationsTransformerBuildItem> producer) {
        if (capabilities.isPresent("io.quarkus.security")) {
            producer.produce((BuildItem)new AnnotationsTransformerBuildItem(((AnnotationTransformation.ClassBuilder)AnnotationTransformation.forClasses().whenAnyMatch(new DotName[]{WebSocketDotNames.WEB_SOCKET})).transform(ctx -> ctx.remove(SecurityTransformerUtils::isStandardSecurityAnnotation))));
        }
    }

    @BuildStep
    EndpointSecurityChecksBuildItem collectEndpointSecurityChecks(BeanArchiveIndexBuildItem indexItem, List<WebSocketEndpointBuildItem> endpoints, Optional<ClassSecurityCheckStorageBuildItem> storageItem, Capabilities capabilities) {
        Map<String, SecurityCheck> endpointIdToSecurityCheck = capabilities.isPresent("io.quarkus.security") && storageItem.isPresent() ? WebSocketProcessor.collectEndpointSecurityChecks(endpoints, storageItem.get(), indexItem.getIndex()) : Map.of();
        return new EndpointSecurityChecksBuildItem(endpointIdToSecurityCheck);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void createSecurityHttpUpgradeCheck(BuildProducer<SyntheticBeanBuildItem> producer, EndpointSecurityChecksBuildItem endpointSecurityChecks, WebSocketServerRecorder recorder) {
        Map<String, SecurityCheck> endpointIdToSecurityCheck = endpointSecurityChecks.endpointIdToSecurityCheck;
        if (!endpointIdToSecurityCheck.isEmpty()) {
            producer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(HttpUpgradeCheck.class).scope(BuiltinScope.SINGLETON.getInfo())).priority(2147483547)).setRuntimeInit().addInjectionPoint((org.jboss.jandex.Type)ClassType.create((DotName)DotNames.BEAN_MANAGER), new AnnotationInstance[0])).addInjectionPoint((org.jboss.jandex.Type)ParameterizedType.create((DotName)DotNames.EVENT, (org.jboss.jandex.Type[])new org.jboss.jandex.Type[]{ClassType.create(AuthorizationFailureEvent.class)}), new AnnotationInstance[0])).addInjectionPoint((org.jboss.jandex.Type)ParameterizedType.create((DotName)DotNames.EVENT, (org.jboss.jandex.Type[])new org.jboss.jandex.Type[]{ClassType.create(AuthorizationSuccessEvent.class)}), new AnnotationInstance[0])).createWith(recorder.createSecurityHttpUpgradeCheck(endpointIdToSecurityCheck)).done());
        }
    }

    @BuildStep
    void createHeaderPropagationHandler(BuildProducer<FilterBuildItem> filterProducer, WebSocketsServerBuildConfig buildConfig) {
        if (buildConfig.propagateSubprotocolHeaders()) {
            WebSocketHeaderPropagationHandler handler = new WebSocketHeaderPropagationHandler();
            int priority = 220;
            filterProducer.produce((BuildItem)new FilterBuildItem((Handler)handler, priority));
        }
    }

    @BuildStep
    void addMetricsSupport(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (WebSocketProcessor.isMetricsSupportEnabled(metricsCapability)) {
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(MetricsBuilderCustomizer.class));
        }
    }

    @BuildStep
    void addTracesSupport(Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer) {
        if (WebSocketProcessor.isTracesSupportEnabled(capabilities)) {
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(TracesBuilderCustomizer.class));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createTelemetryProvider(BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer, Capabilities capabilities, WebSocketTelemetryRecorder recorder, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (WebSocketProcessor.isTracesSupportEnabled(capabilities) || WebSocketProcessor.isMetricsSupportEnabled(metricsCapability)) {
            SyntheticBeanBuildItem syntheticBeanBuildItem = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(WebSocketTelemetryProvider.class).setRuntimeInit().unremovable()).addInjectionPoint((org.jboss.jandex.Type)ParameterizedType.builder(Instance.class).addArgument((org.jboss.jandex.Type)ParameterizedType.builder(Consumer.class).addArgument(WebSocketTelemetryProviderBuilder.class).build()).build(), new AnnotationInstance[0])).createWith(recorder.createTelemetryProvider()).scope(Singleton.class)).done();
            syntheticBeanProducer.produce((BuildItem)syntheticBeanBuildItem);
        }
    }

    private static boolean isTracesSupportEnabled(Capabilities capabilities) {
        return capabilities.isPresent("io.quarkus.opentelemetry.tracer");
    }

    private static boolean isMetricsSupportEnabled(Optional<MetricsCapabilityBuildItem> metricsCapability) {
        return metricsCapability.map(m -> m.metricsSupported("micrometer")).orElse(false);
    }

    private static Map<String, SecurityCheck> collectEndpointSecurityChecks(List<WebSocketEndpointBuildItem> endpoints, ClassSecurityCheckStorageBuildItem storage, IndexView index) {
        return endpoints.stream().mapMulti((endpoint, consumer) -> {
            DotName beanName = endpoint.beanClassName();
            Object patt0$temp = storage.getSecurityCheck(beanName);
            if (patt0$temp instanceof SecurityCheck) {
                SecurityCheck check = (SecurityCheck)patt0$temp;
                consumer.accept(Map.entry(endpoint.id, check));
            } else if (SecurityTransformerUtils.hasSecurityAnnotation((ClassInfo)index.getClassByName(beanName))) {
                throw new IllegalStateException("WebSocket endpoint '%s' requires ".formatted(beanName) + "secured HTTP upgrade but Quarkus did not configure security check correctly. Please open issue in Quarkus project");
            }
        }).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static String mergePath(String prefix, String path) {
        if (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return prefix + (String)path;
    }

    static String getPath(String path) {
        if (path.isEmpty()) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        Matcher m = PATH_PARAM_PATTERN.matcher(path);
        while (m.find()) {
            char nextChar;
            String match = m.group();
            int end = m.end();
            if (end < path.length() && (Character.isAlphabetic(nextChar = path.charAt(end)) || Character.isDigit(nextChar) || nextChar == '_')) {
                throw new WebSocketServerException("Path parameter " + match + " may not be followed by an alphanumeric character or underscore: " + path);
            }
            m.appendReplacement(sb, ":" + String.valueOf(match.subSequence(1, match.length() - 1)));
        }
        m.appendTail(sb);
        return path.startsWith("/") ? sb.toString() : "/" + sb.toString();
    }

    public static String getOriginalPath(String path) {
        StringBuilder sb = new StringBuilder();
        Matcher m = TRANSLATED_PATH_PARAM_PATTERN.matcher(path);
        while (m.find()) {
            String match = m.group();
            m.appendReplacement(sb, "{" + String.valueOf(match.subSequence(1, match.length())) + "}");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    static String getPathPrefix(IndexView index, DotName enclosingClassName) {
        ClassInfo enclosingClass = index.getClassByName(enclosingClassName);
        if (enclosingClass == null) {
            throw new WebSocketServerException("Enclosing class not found in index: " + String.valueOf(enclosingClass));
        }
        AnnotationInstance webSocketAnnotation = enclosingClass.annotation(WebSocketDotNames.WEB_SOCKET);
        if (webSocketAnnotation != null) {
            String path = WebSocketProcessor.getPath(webSocketAnnotation.value("path").asString());
            if (enclosingClass.nestingType() == ClassInfo.NestingType.INNER) {
                return WebSocketProcessor.mergePath(WebSocketProcessor.getPathPrefix(index, enclosingClass.enclosingClass()), path);
            }
            return path.endsWith("/") ? path.substring(path.length() - 1) : path;
        }
        return "";
    }

    private void validateOnPingMessage(Callback callback) {
        org.jboss.jandex.Type messageType;
        if (KotlinUtils.isKotlinMethod((MethodInfo)callback.method)) {
            if (!(callback.isReturnTypeVoid() || WebSocketProcessor.isUniVoid(callback.returnType()) || callback.isKotlinSuspendFunctionReturningUnit())) {
                throw new WebSocketServerException("@OnPingMessage callback must return Unit or Uni<Void>: " + callback.asString());
            }
        } else if (!callback.isReturnTypeVoid() && !WebSocketProcessor.isUniVoid(callback.returnType())) {
            throw new WebSocketServerException("@OnPingMessage callback must return void or Uni<Void>: " + callback.asString());
        }
        if ((messageType = callback.argumentType(MessageCallbackArgument::isMessage)) == null || !messageType.name().equals((Object)WebSocketDotNames.BUFFER)) {
            throw new WebSocketServerException("@OnPingMessage callback must accept exactly one message parameter of type io.vertx.core.buffer.Buffer: " + callback.asString());
        }
    }

    private void validateOnPongMessage(Callback callback) {
        org.jboss.jandex.Type messageType;
        if (KotlinUtils.isKotlinMethod((MethodInfo)callback.method)) {
            if (!(callback.isReturnTypeVoid() || WebSocketProcessor.isUniVoid(callback.returnType()) || callback.isKotlinSuspendFunctionReturningUnit())) {
                throw new WebSocketServerException("@OnPongMessage callback must return Unit or Uni<Void>: " + callback.asString());
            }
        } else if (!callback.isReturnTypeVoid() && !WebSocketProcessor.isUniVoid(callback.returnType())) {
            throw new WebSocketServerException("@OnPongMessage callback must return void or Uni<Void>: " + callback.asString());
        }
        if ((messageType = callback.argumentType(MessageCallbackArgument::isMessage)) == null || !messageType.name().equals((Object)WebSocketDotNames.BUFFER)) {
            throw new WebSocketServerException("@OnPongMessage callback must accept exactly one message parameter of type io.vertx.core.buffer.Buffer: " + callback.asString());
        }
    }

    private void validateOnClose(Callback callback) {
        if (KotlinUtils.isKotlinMethod((MethodInfo)callback.method)) {
            if (!(callback.isReturnTypeVoid() || WebSocketProcessor.isUniVoid(callback.returnType()) || callback.isKotlinSuspendFunctionReturningUnit())) {
                throw new WebSocketServerException("@OnClose callback must return Unit or Uni<Void>: " + callback.asString());
            }
        } else if (!callback.isReturnTypeVoid() && !WebSocketProcessor.isUniVoid(callback.returnType())) {
            throw new WebSocketServerException("@OnClose callback must return void or Uni<Void>: " + callback.asString());
        }
    }

    static String generateEndpoint(WebSocketEndpointBuildItem endpoint, CallbackArgumentsBuildItem argumentProviders, TransformedAnnotationsBuildItem transformedAnnotations, IndexView index, ClassOutput classOutput, GlobalErrorHandlersBuildItem globalErrorHandlers, String endpointSuffix, InvokerFactoryBuildItem invokerFactory, boolean metricsSupportEnabled) {
        ResultHandle ret;
        ResultHandle[] args;
        TryBlock tryBlock;
        ResultHandle beanInstance;
        Callback callback;
        ClassInfo implClazz = endpoint.bean.getImplClazz();
        Object baseName = implClazz.enclosingClass() != null ? DotNames.simpleName((DotName)implClazz.enclosingClass()) + NESTED_SEPARATOR + DotNames.simpleName((ClassInfo)implClazz) : DotNames.simpleName((DotName)implClazz.name());
        String generatedName = DotNames.internalPackageNameWithTrailingSlash((DotName)implClazz.name()) + (String)baseName + endpointSuffix;
        ClassCreator endpointCreator = ClassCreator.builder().classOutput(classOutput).className(generatedName).superClass(WebSocketEndpointBase.class).build();
        MethodCreator constructor = endpointCreator.getConstructorCreator(new Class[]{WebSocketConnectionBase.class, Codecs.class, ContextSupport.class, SecuritySupport.class, ErrorInterceptor.class});
        constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(WebSocketEndpointBase.class, (Class[])new Class[]{WebSocketConnectionBase.class, Codecs.class, ContextSupport.class, SecuritySupport.class, ErrorInterceptor.class}), constructor.getThis(), new ResultHandle[]{constructor.getMethodParam(0), constructor.getMethodParam(1), constructor.getMethodParam(2), constructor.getMethodParam(3), constructor.getMethodParam(4)});
        MethodCreator inboundProcessingMode = endpointCreator.getMethodCreator("inboundProcessingMode", InboundProcessingMode.class, new Class[0]);
        inboundProcessingMode.returnValue(inboundProcessingMode.load((Enum)endpoint.inboundProcessingMode));
        MethodCreator beanIdentifier = endpointCreator.getMethodCreator("beanIdentifier", String.class, new Class[0]);
        beanIdentifier.returnValue(beanIdentifier.load(endpoint.bean.getIdentifier()));
        if (endpoint.onOpen != null) {
            callback = endpoint.onOpen;
            MethodCreator doOnOpen = endpointCreator.getMethodCreator("doOnOpen", Uni.class, new Class[]{Object.class});
            beanInstance = doOnOpen.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"beanInstance", Object.class, (Class[])new Class[0]), doOnOpen.getThis(), new ResultHandle[0]);
            tryBlock = WebSocketProcessor.onErrorTryBlock((BytecodeCreator)doOnOpen, doOnOpen.getThis());
            args = callback.generateArguments(tryBlock.getThis(), (BytecodeCreator)tryBlock, transformedAnnotations, index);
            ret = WebSocketProcessor.callBusinessMethod(endpointCreator, constructor, callback, "Open", (BytecodeCreator)tryBlock, beanInstance, args, invokerFactory);
            WebSocketProcessor.encodeAndReturnResult(tryBlock.getThis(), (BytecodeCreator)tryBlock, callback, globalErrorHandlers, endpoint, ret, metricsSupportEnabled);
            MethodCreator onOpenExecutionModel = endpointCreator.getMethodCreator("onOpenExecutionModel", WebSocketEndpoint.ExecutionModel.class, new Class[0]);
            onOpenExecutionModel.returnValue(onOpenExecutionModel.load((Enum)callback.executionModel));
        }
        WebSocketProcessor.generateOnMessage(endpointCreator, constructor, endpoint, endpoint.onBinaryMessage, transformedAnnotations, index, globalErrorHandlers, invokerFactory, metricsSupportEnabled);
        WebSocketProcessor.generateOnMessage(endpointCreator, constructor, endpoint, endpoint.onTextMessage, transformedAnnotations, index, globalErrorHandlers, invokerFactory, metricsSupportEnabled);
        WebSocketProcessor.generateOnMessage(endpointCreator, constructor, endpoint, endpoint.onPingMessage, transformedAnnotations, index, globalErrorHandlers, invokerFactory, metricsSupportEnabled);
        WebSocketProcessor.generateOnMessage(endpointCreator, constructor, endpoint, endpoint.onPongMessage, transformedAnnotations, index, globalErrorHandlers, invokerFactory, metricsSupportEnabled);
        if (endpoint.onClose != null) {
            callback = endpoint.onClose;
            MethodCreator doOnClose = endpointCreator.getMethodCreator("doOnClose", Uni.class, new Class[]{Object.class});
            beanInstance = doOnClose.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"beanInstance", Object.class, (Class[])new Class[0]), doOnClose.getThis(), new ResultHandle[0]);
            tryBlock = WebSocketProcessor.onErrorTryBlock((BytecodeCreator)doOnClose, doOnClose.getThis());
            args = callback.generateArguments(tryBlock.getThis(), (BytecodeCreator)tryBlock, transformedAnnotations, index);
            ret = WebSocketProcessor.callBusinessMethod(endpointCreator, constructor, callback, "Close", (BytecodeCreator)tryBlock, beanInstance, args, invokerFactory);
            WebSocketProcessor.encodeAndReturnResult(tryBlock.getThis(), (BytecodeCreator)tryBlock, callback, globalErrorHandlers, endpoint, ret, metricsSupportEnabled);
            MethodCreator onCloseExecutionModel = endpointCreator.getMethodCreator("onCloseExecutionModel", WebSocketEndpoint.ExecutionModel.class, new Class[0]);
            onCloseExecutionModel.returnValue(onCloseExecutionModel.load((Enum)callback.executionModel));
        }
        WebSocketProcessor.generateOnError(endpointCreator, constructor, endpoint, transformedAnnotations, globalErrorHandlers, index, invokerFactory, metricsSupportEnabled);
        constructor.returnVoid();
        endpointCreator.close();
        return generatedName.replace('/', '.');
    }

    private static void generateOnError(ClassCreator endpointCreator, MethodCreator constructor, WebSocketEndpointBuildItem endpoint, TransformedAnnotationsBuildItem transformedAnnotations, GlobalErrorHandlersBuildItem globalErrorHandlers, IndexView index, InvokerFactoryBuildItem invokerFactory, boolean metricsSupportEnabled) {
        HashMap<DotName, Callback> errors = new HashMap<DotName, Callback>();
        ArrayList<ThrowableInfo> throwableInfos = new ArrayList<ThrowableInfo>();
        for (Callback callback : endpoint.onErrors) {
            DotName errorTypeName = callback.argumentType(ErrorCallbackArgument::isError).name();
            if (errors.containsKey(errorTypeName)) {
                throw new WebSocketException(String.format("Multiple @OnError callbacks may not accept the same error parameter: %s\n\t- %s\n\t- %s", errorTypeName, callback.asString(), ((Callback)errors.get(errorTypeName)).asString()));
            }
            errors.put(errorTypeName, callback);
            throwableInfos.add(new ThrowableInfo(endpoint.bean, callback, WebSocketProcessor.throwableHierarchy(errorTypeName, index)));
        }
        for (GlobalErrorHandler globalErrorHandler : endpoint.isClient ? globalErrorHandlers.forClient() : globalErrorHandlers.forServer()) {
            Callback callback = globalErrorHandler.callback;
            DotName errorTypeName = callback.argumentType(ErrorCallbackArgument::isError).name();
            if (errors.containsKey(errorTypeName)) continue;
            throwableInfos.add(new ThrowableInfo(globalErrorHandler.bean, callback, WebSocketProcessor.throwableHierarchy(errorTypeName, index)));
        }
        if (throwableInfos.isEmpty()) {
            return;
        }
        MethodCreator doOnError = endpointCreator.getMethodCreator("doOnError", Uni.class, new Class[]{Throwable.class});
        throwableInfos.sort(Comparator.comparingInt(ThrowableInfo::level).reversed());
        ResultHandle endpointThis = doOnError.getThis();
        if (metricsSupportEnabled) {
            doOnError.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"interceptError", Void.TYPE, (Class[])new Class[]{Throwable.class}), endpointThis, new ResultHandle[]{doOnError.getMethodParam(0)});
        }
        for (ThrowableInfo throwableInfo : throwableInfos) {
            BytecodeCreator throwableMatches = doOnError.ifTrue(doOnError.instanceOf(doOnError.getMethodParam(0), throwableInfo.hierarchy.get(0).toString())).trueBranch();
            Callback callback = throwableInfo.callback;
            FunctionCreator fun = throwableMatches.createFunction(Function.class);
            BytecodeCreator funBytecode = fun.getBytecode();
            TryBlock tryBlock = WebSocketProcessor.uniFailureTryBlock(funBytecode);
            ResultHandle beanInstance = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"beanInstance", Object.class, (Class[])new Class[]{String.class}), endpointThis, new ResultHandle[]{funBytecode.load(throwableInfo.bean().getIdentifier())});
            ResultHandle[] args = callback.generateArguments(endpointThis, (BytecodeCreator)tryBlock, transformedAnnotations, index);
            ResultHandle ret = WebSocketProcessor.callBusinessMethod(endpointCreator, constructor, callback, "Error", (BytecodeCreator)tryBlock, beanInstance, args, invokerFactory);
            WebSocketProcessor.encodeAndReturnResult(endpointThis, (BytecodeCreator)tryBlock, callback, globalErrorHandlers, endpoint, ret, metricsSupportEnabled);
            throwableMatches.returnValue(throwableMatches.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"doErrorExecute", Uni.class, (Class[])new Class[]{Throwable.class, WebSocketEndpoint.ExecutionModel.class, Function.class}), throwableMatches.getThis(), new ResultHandle[]{throwableMatches.getMethodParam(0), throwableMatches.load((Enum)callback.executionModel), fun.getInstance()}));
        }
        ResultHandle uniCreate = doOnError.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Uni.class, (String)"createFrom", UniCreate.class, (Class[])new Class[0]), new ResultHandle[0]);
        doOnError.returnValue(doOnError.invokeVirtualMethod(MethodDescriptor.ofMethod(UniCreate.class, (String)"failure", Uni.class, (Class[])new Class[]{Throwable.class}), uniCreate, new ResultHandle[]{doOnError.getMethodParam(0)}));
    }

    private static List<DotName> throwableHierarchy(DotName throwableName, IndexView index) {
        ArrayList<DotName> ret = new ArrayList<DotName>();
        WebSocketProcessor.addToThrowableHierarchy(throwableName, index, ret);
        return ret;
    }

    private static void addToThrowableHierarchy(DotName throwableName, IndexView index, List<DotName> hierarchy) {
        hierarchy.add(throwableName);
        ClassInfo errorClass = index.getClassByName(throwableName);
        if (errorClass == null) {
            throw new IllegalArgumentException("The class " + String.valueOf(throwableName) + " not found in the index");
        }
        if (errorClass.superName().equals((Object)DotName.OBJECT_NAME)) {
            return;
        }
        WebSocketProcessor.addToThrowableHierarchy(errorClass.superName(), index, hierarchy);
    }

    private static void generateOnMessage(ClassCreator endpointCreator, MethodCreator constructor, WebSocketEndpointBuildItem endpoint, Callback callback, TransformedAnnotationsBuildItem transformedAnnotations, IndexView index, GlobalErrorHandlersBuildItem globalErrorHandlers, InvokerFactoryBuildItem invokerFactory, boolean metricsSupportEnabled) {
        String messageType;
        if (callback == null) {
            return;
        }
        MethodCreator doOnMessage = endpointCreator.getMethodCreator("doOn" + messageType + "Message", Uni.class, new Class[]{switch (callback.messageType()) {
            case Callback.MessageType.BINARY -> {
                messageType = "Binary";
                yield Object.class;
            }
            case Callback.MessageType.TEXT -> {
                messageType = "Text";
                yield Object.class;
            }
            case Callback.MessageType.PING -> {
                messageType = "Ping";
                yield Buffer.class;
            }
            case Callback.MessageType.PONG -> {
                messageType = "Pong";
                yield Buffer.class;
            }
            default -> throw new IllegalArgumentException();
        }});
        TryBlock tryBlock = WebSocketProcessor.onErrorTryBlock((BytecodeCreator)doOnMessage, doOnMessage.getThis());
        ResultHandle beanInstance = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"beanInstance", Object.class, (Class[])new Class[0]), tryBlock.getThis(), new ResultHandle[0]);
        ResultHandle[] args = callback.generateArguments(tryBlock.getThis(), (BytecodeCreator)tryBlock, transformedAnnotations, index);
        ResultHandle ret = WebSocketProcessor.callBusinessMethod(endpointCreator, constructor, callback, messageType, (BytecodeCreator)tryBlock, beanInstance, args, invokerFactory);
        WebSocketProcessor.encodeAndReturnResult(tryBlock.getThis(), (BytecodeCreator)tryBlock, callback, globalErrorHandlers, endpoint, ret, metricsSupportEnabled);
        MethodCreator onMessageExecutionModel = endpointCreator.getMethodCreator("on" + messageType + "MessageExecutionModel", WebSocketEndpoint.ExecutionModel.class, new Class[0]);
        onMessageExecutionModel.returnValue(onMessageExecutionModel.load((Enum)callback.executionModel));
        if (callback.acceptsMulti() && callback.messageType != Callback.MessageType.PING && callback.messageType != Callback.MessageType.PONG) {
            org.jboss.jandex.Type multiItemType = (org.jboss.jandex.Type)callback.messageParamType().asParameterizedType().arguments().get(0);
            MethodCreator consumedMultiType = endpointCreator.getMethodCreator("consumed" + messageType + "MultiType", Type.class, new Class[0]);
            consumedMultiType.returnValue(Types.getTypeHandle((BytecodeCreator)consumedMultiType, (org.jboss.jandex.Type)multiItemType));
            MethodCreator decodeMultiItem = endpointCreator.getMethodCreator("decode" + messageType + "MultiItem", Object.class, new Class[]{Object.class});
            decodeMultiItem.returnValue(WebSocketProcessor.decodeMessage(decodeMultiItem.getThis(), (BytecodeCreator)decodeMultiItem, callback.acceptsBinaryMessage(), multiItemType, decodeMultiItem.getMethodParam(0), callback));
        }
    }

    private static ResultHandle callBusinessMethod(ClassCreator clazz, MethodCreator constructor, Callback callback, String messageType, BytecodeCreator bytecode, ResultHandle beanInstance, ResultHandle[] args, InvokerFactoryBuildItem invokerFactory) {
        if (KotlinUtils.isKotlinSuspendMethod((MethodInfo)callback.method)) {
            InvokerInfo invoker = invokerFactory.createInvoker(callback.bean, callback.method).withInvocationWrapper(CoroutineInvoker.class, "inNewCoroutine").build();
            FieldCreator invokerField = (FieldCreator)clazz.getFieldCreator("invokerFor" + messageType, Invoker.class).setModifiers(18);
            constructor.writeInstanceField(invokerField.getFieldDescriptor(), constructor.getThis(), constructor.newInstance(MethodDescriptor.ofConstructor((String)invoker.getClassName(), (String[])new String[0]), new ResultHandle[0]));
            ResultHandle invokerHandle = bytecode.readInstanceField(invokerField.getFieldDescriptor(), bytecode.getThis());
            ResultHandle argsArray = bytecode.newArray(Object.class, args.length);
            for (int i = 0; i < args.length; ++i) {
                bytecode.writeArrayValue(argsArray, i, args[i]);
            }
            return bytecode.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invoker.class, (String)"invoke", Object.class, (Class[])new Class[]{Object.class, Object[].class}), invokerHandle, new ResultHandle[]{beanInstance, argsArray});
        }
        return bytecode.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)callback.method), beanInstance, args);
    }

    private static TryBlock uniFailureTryBlock(BytecodeCreator method) {
        TryBlock tryBlock = method.tryBlock();
        CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
        ResultHandle uniCreate = catchBlock.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Uni.class, (String)"createFrom", UniCreate.class, (Class[])new Class[0]), new ResultHandle[0]);
        catchBlock.returnValue(catchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(UniCreate.class, (String)"failure", Uni.class, (Class[])new Class[]{Throwable.class}), uniCreate, new ResultHandle[]{catchBlock.getCaughtException()}));
        return tryBlock;
    }

    private static TryBlock onErrorTryBlock(BytecodeCreator method, ResultHandle endpointThis) {
        TryBlock tryBlock = method.tryBlock();
        CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
        catchBlock.returnValue(catchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"doOnError", Uni.class, (Class[])new Class[]{Throwable.class}), endpointThis, new ResultHandle[]{catchBlock.getCaughtException()}));
        return tryBlock;
    }

    static ResultHandle decodeMessage(ResultHandle endpointThis, BytecodeCreator method, boolean binaryMessage, org.jboss.jandex.Type valueType, ResultHandle value, Callback callback) {
        if (WebSocketDotNames.MULTI.equals((Object)valueType.name())) {
            return value;
        }
        if (binaryMessage) {
            if (WebSocketDotNames.BUFFER.equals((Object)valueType.name())) {
                return value;
            }
            if (WebSocketProcessor.isByteArray(valueType)) {
                return method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"getBytes", byte[].class, (Class[])new Class[0]), value, new ResultHandle[0]);
            }
            if (WebSocketDotNames.STRING.equals((Object)valueType.name())) {
                return method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"toString", String.class, (Class[])new Class[0]), value, new ResultHandle[0]);
            }
            if (WebSocketDotNames.JSON_OBJECT.equals((Object)valueType.name())) {
                return method.newInstance(MethodDescriptor.ofConstructor(JsonObject.class, (Class[])new Class[]{Buffer.class}), new ResultHandle[]{value});
            }
            if (WebSocketDotNames.JSON_ARRAY.equals((Object)valueType.name())) {
                return method.newInstance(MethodDescriptor.ofConstructor(JsonArray.class, (Class[])new Class[]{Buffer.class}), new ResultHandle[]{value});
            }
            DotName inputCodec = callback.getInputCodec();
            ResultHandle type = Types.getTypeHandle((BytecodeCreator)method, (org.jboss.jandex.Type)valueType);
            ResultHandle decoded = method.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"decodeBinary", Object.class, (Class[])new Class[]{Type.class, Buffer.class, Class.class}), endpointThis, new ResultHandle[]{type, value, inputCodec != null ? method.loadClass(inputCodec.toString()) : method.loadNull()});
            return decoded;
        }
        if (WebSocketDotNames.STRING.equals((Object)valueType.name())) {
            return value;
        }
        if (WebSocketDotNames.JSON_OBJECT.equals((Object)valueType.name())) {
            return method.newInstance(MethodDescriptor.ofConstructor(JsonObject.class, (Class[])new Class[]{String.class}), new ResultHandle[]{value});
        }
        if (WebSocketDotNames.JSON_ARRAY.equals((Object)valueType.name())) {
            return method.newInstance(MethodDescriptor.ofConstructor(JsonArray.class, (Class[])new Class[]{String.class}), new ResultHandle[]{value});
        }
        if (WebSocketDotNames.BUFFER.equals((Object)valueType.name())) {
            return method.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{String.class}), new ResultHandle[]{value});
        }
        if (WebSocketProcessor.isByteArray(valueType)) {
            ResultHandle buffer = method.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{byte[].class}), new ResultHandle[]{value});
            return method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"getBytes", byte[].class, (Class[])new Class[0]), buffer, new ResultHandle[0]);
        }
        DotName inputCodec = callback.getInputCodec();
        ResultHandle type = Types.getTypeHandle((BytecodeCreator)method, (org.jboss.jandex.Type)valueType);
        ResultHandle decoded = method.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"decodeText", Object.class, (Class[])new Class[]{Type.class, String.class, Class.class}), endpointThis, new ResultHandle[]{type, value, inputCodec != null ? method.loadClass(inputCodec.toString()) : method.loadNull()});
        return decoded;
    }

    private static ResultHandle uniOnFailureDoOnError(ResultHandle endpointThis, BytecodeCreator method, Callback callback, ResultHandle uni, WebSocketEndpointBuildItem endpoint, GlobalErrorHandlersBuildItem globalErrorHandlers, boolean metricsSupportEnabled) {
        if ((callback.isOnError() || globalErrorHandlers.handlers.isEmpty() && (endpoint == null || endpoint.onErrors.isEmpty())) && !metricsSupportEnabled) {
            return uni;
        }
        FunctionCreator fun = method.createFunction(Function.class);
        BytecodeCreator funBytecode = fun.getBytecode();
        funBytecode.returnValue(funBytecode.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"doOnError", Uni.class, (Class[])new Class[]{Throwable.class}), endpointThis, new ResultHandle[]{funBytecode.getMethodParam(0)}));
        ResultHandle uniOnFailure = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Uni.class, (String)"onFailure", UniOnFailure.class, (Class[])new Class[0]), uni, new ResultHandle[0]);
        return method.invokeVirtualMethod(MethodDescriptor.ofMethod(UniOnFailure.class, (String)"recoverWithUni", Uni.class, (Class[])new Class[]{Function.class}), uniOnFailure, new ResultHandle[]{fun.getInstance()});
    }

    private static ResultHandle encodeMessage(ResultHandle endpointThis, BytecodeCreator method, Callback callback, GlobalErrorHandlersBuildItem globalErrorHandlers, WebSocketEndpointBuildItem endpoint, ResultHandle value, boolean metricsSupportEnabled) {
        if (callback.acceptsBinaryMessage() || WebSocketProcessor.isOnOpenWithBinaryReturnType(callback)) {
            if (callback.isReturnTypeUni() || callback.isKotlinSuspendFunction()) {
                org.jboss.jandex.Type messageType;
                org.jboss.jandex.Type type = messageType = callback.isReturnTypeUni() ? (org.jboss.jandex.Type)callback.returnType().asParameterizedType().arguments().get(0) : KotlinUtils.getKotlinSuspendMethodResult((MethodInfo)callback.method);
                if (messageType.name().equals((Object)KotlinDotNames.UNIT)) {
                    value = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Uni.class, (String)"replaceWithVoid", Uni.class, (Class[])new Class[0]), value, new ResultHandle[0]);
                    messageType = ClassType.create((DotName)WebSocketDotNames.VOID);
                }
                if (messageType.name().equals((Object)WebSocketDotNames.VOID)) {
                    return WebSocketProcessor.uniOnFailureDoOnError(endpointThis, method, callback, value, endpoint, globalErrorHandlers, metricsSupportEnabled);
                }
                FunctionCreator fun = method.createFunction(Function.class);
                BytecodeCreator funBytecode = fun.getBytecode();
                ResultHandle buffer = WebSocketProcessor.encodeBuffer(funBytecode, messageType, funBytecode.getMethodParam(0), endpointThis, callback);
                funBytecode.returnValue(funBytecode.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"sendBinary", Uni.class, (Class[])new Class[]{Buffer.class, Boolean.TYPE}), endpointThis, new ResultHandle[]{buffer, funBytecode.load(callback.broadcast())}));
                ResultHandle uniChain = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Uni.class, (String)"chain", Uni.class, (Class[])new Class[]{Function.class}), value, new ResultHandle[]{fun.getInstance()});
                return WebSocketProcessor.uniOnFailureDoOnError(endpointThis, method, callback, uniChain, endpoint, globalErrorHandlers, metricsSupportEnabled);
            }
            if (callback.isReturnTypeMulti()) {
                FunctionCreator fun = method.createFunction(Function.class);
                BytecodeCreator funBytecode = fun.getBytecode();
                ResultHandle endpointBase = funBytecode.checkCast(endpointThis, WebSocketEndpointBase.class);
                TryBlock tryBlock = WebSocketProcessor.onErrorTryBlock(fun.getBytecode(), endpointBase);
                ResultHandle buffer = WebSocketProcessor.encodeBuffer((BytecodeCreator)tryBlock, (org.jboss.jandex.Type)callback.returnType().asParameterizedType().arguments().get(0), tryBlock.getMethodParam(0), endpointThis, callback);
                tryBlock.returnValue(tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"sendBinary", Uni.class, (Class[])new Class[]{Buffer.class, Boolean.TYPE}), endpointThis, new ResultHandle[]{buffer, tryBlock.load(callback.broadcast())}));
                return method.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"multiBinary", Uni.class, (Class[])new Class[]{Multi.class, Function.class}), endpointThis, new ResultHandle[]{value, fun.getInstance()});
            }
            ResultHandle buffer = WebSocketProcessor.encodeBuffer(method, callback.returnType(), value, endpointThis, callback);
            return method.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"sendBinary", Uni.class, (Class[])new Class[]{Buffer.class, Boolean.TYPE}), endpointThis, new ResultHandle[]{buffer, method.load(callback.broadcast())});
        }
        if (callback.isReturnTypeUni() || callback.isKotlinSuspendFunction()) {
            org.jboss.jandex.Type messageType;
            org.jboss.jandex.Type type = messageType = callback.isReturnTypeUni() ? (org.jboss.jandex.Type)callback.returnType().asParameterizedType().arguments().get(0) : KotlinUtils.getKotlinSuspendMethodResult((MethodInfo)callback.method);
            if (messageType.name().equals((Object)KotlinDotNames.UNIT)) {
                value = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Uni.class, (String)"replaceWithVoid", Uni.class, (Class[])new Class[0]), value, new ResultHandle[0]);
                messageType = ClassType.create((DotName)WebSocketDotNames.VOID);
            }
            if (messageType.name().equals((Object)WebSocketDotNames.VOID)) {
                return WebSocketProcessor.uniOnFailureDoOnError(endpointThis, method, callback, value, endpoint, globalErrorHandlers, metricsSupportEnabled);
            }
            FunctionCreator fun = method.createFunction(Function.class);
            BytecodeCreator funBytecode = fun.getBytecode();
            ResultHandle text = WebSocketProcessor.encodeText(funBytecode, messageType, funBytecode.getMethodParam(0), endpointThis, callback);
            funBytecode.returnValue(funBytecode.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"sendText", Uni.class, (Class[])new Class[]{String.class, Boolean.TYPE}), endpointThis, new ResultHandle[]{text, funBytecode.load(callback.broadcast())}));
            ResultHandle uniChain = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Uni.class, (String)"chain", Uni.class, (Class[])new Class[]{Function.class}), value, new ResultHandle[]{fun.getInstance()});
            return WebSocketProcessor.uniOnFailureDoOnError(endpointThis, method, callback, uniChain, endpoint, globalErrorHandlers, metricsSupportEnabled);
        }
        if (callback.isReturnTypeMulti()) {
            FunctionCreator fun = method.createFunction(Function.class);
            BytecodeCreator funBytecode = fun.getBytecode();
            ResultHandle endpointBase = funBytecode.checkCast(endpointThis, WebSocketEndpointBase.class);
            TryBlock tryBlock = WebSocketProcessor.onErrorTryBlock(fun.getBytecode(), endpointBase);
            ResultHandle text = WebSocketProcessor.encodeText((BytecodeCreator)tryBlock, (org.jboss.jandex.Type)callback.returnType().asParameterizedType().arguments().get(0), tryBlock.getMethodParam(0), endpointThis, callback);
            tryBlock.returnValue(tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"sendText", Uni.class, (Class[])new Class[]{String.class, Boolean.TYPE}), endpointThis, new ResultHandle[]{text, tryBlock.load(callback.broadcast())}));
            return method.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"multiText", Uni.class, (Class[])new Class[]{Multi.class, Function.class}), endpointThis, new ResultHandle[]{value, fun.getInstance()});
        }
        ResultHandle text = WebSocketProcessor.encodeText(method, callback.returnType(), value, endpointThis, callback);
        return method.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"sendText", Uni.class, (Class[])new Class[]{String.class, Boolean.TYPE}), endpointThis, new ResultHandle[]{text, method.load(callback.broadcast())});
    }

    private static ResultHandle encodeBuffer(BytecodeCreator method, org.jboss.jandex.Type messageType, ResultHandle value, ResultHandle endpointThis, Callback callback) {
        ResultHandle buffer;
        if (messageType.name().equals((Object)WebSocketDotNames.BUFFER)) {
            buffer = value;
        } else if (WebSocketProcessor.isByteArray(messageType)) {
            buffer = method.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{byte[].class}), new ResultHandle[]{value});
        } else if (messageType.name().equals((Object)WebSocketDotNames.STRING)) {
            buffer = method.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{String.class}), new ResultHandle[]{value});
        } else if (messageType.name().equals((Object)WebSocketDotNames.JSON_OBJECT)) {
            buffer = method.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonObject.class, (String)"toBuffer", Buffer.class, (Class[])new Class[0]), value, new ResultHandle[0]);
        } else if (messageType.name().equals((Object)WebSocketDotNames.JSON_ARRAY)) {
            buffer = method.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonArray.class, (String)"toBuffer", Buffer.class, (Class[])new Class[0]), value, new ResultHandle[0]);
        } else {
            DotName outputCodec = callback.getOutputCodec();
            buffer = method.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"encodeBinary", Buffer.class, (Class[])new Class[]{Object.class, Class.class}), endpointThis, new ResultHandle[]{value, outputCodec != null ? method.loadClass(outputCodec.toString()) : method.loadNull()});
        }
        return buffer;
    }

    private static ResultHandle encodeText(BytecodeCreator method, org.jboss.jandex.Type messageType, ResultHandle value, ResultHandle endpointThis, Callback callback) {
        ResultHandle text;
        if (messageType.name().equals((Object)WebSocketDotNames.BUFFER)) {
            text = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"toString", String.class, (Class[])new Class[0]), value, new ResultHandle[0]);
        } else if (WebSocketProcessor.isByteArray(messageType)) {
            ResultHandle buffer = method.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{byte[].class}), new ResultHandle[]{value});
            text = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"toString", String.class, (Class[])new Class[0]), buffer, new ResultHandle[0]);
        } else if (messageType.name().equals((Object)WebSocketDotNames.STRING)) {
            text = value;
        } else if (messageType.name().equals((Object)WebSocketDotNames.JSON_OBJECT)) {
            text = method.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonObject.class, (String)"encode", String.class, (Class[])new Class[0]), value, new ResultHandle[0]);
        } else if (messageType.name().equals((Object)WebSocketDotNames.JSON_ARRAY)) {
            text = method.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonArray.class, (String)"encode", String.class, (Class[])new Class[0]), value, new ResultHandle[0]);
        } else {
            DotName outputCodec = callback.getOutputCodec();
            text = method.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"encodeText", String.class, (Class[])new Class[]{Object.class, Class.class}), endpointThis, new ResultHandle[]{value, outputCodec != null ? method.loadClass(outputCodec.toString()) : method.loadNull()});
        }
        return text;
    }

    private static ResultHandle uniVoid(BytecodeCreator method) {
        ResultHandle uniCreate = method.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Uni.class, (String)"createFrom", UniCreate.class, (Class[])new Class[0]), new ResultHandle[0]);
        return method.invokeVirtualMethod(MethodDescriptor.ofMethod(UniCreate.class, (String)"voidItem", Uni.class, (Class[])new Class[0]), uniCreate, new ResultHandle[0]);
    }

    private static void encodeAndReturnResult(ResultHandle endpointThis, BytecodeCreator method, Callback callback, GlobalErrorHandlersBuildItem globalErrorHandlers, WebSocketEndpointBuildItem endpoint, ResultHandle result, boolean metricsSupportEnabled) {
        if (callback.isReturnTypeVoid()) {
            method.returnValue(WebSocketProcessor.uniVoid(method));
        } else {
            BytecodeCreator isNull = method.ifNull(result).trueBranch();
            isNull.returnValue(WebSocketProcessor.uniVoid(isNull));
            method.returnValue(WebSocketProcessor.encodeMessage(endpointThis, method, callback, globalErrorHandlers, endpoint, result, metricsSupportEnabled));
        }
    }

    static List<Callback> findErrorHandlers(Callback.Target target, IndexView index, BeanInfo bean, ClassInfo beanClass, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations, String endpointPath) {
        List<AnnotationInstance> annotations = WebSocketProcessor.findCallbackAnnotations(index, beanClass, WebSocketDotNames.ON_ERROR);
        if (annotations.isEmpty()) {
            return List.of();
        }
        ArrayList<Callback> errorHandlers = new ArrayList<Callback>();
        for (AnnotationInstance annotation : annotations) {
            MethodInfo method = annotation.target().asMethod();
            if (method.parameterTypes().stream().map(org.jboss.jandex.Type::name).anyMatch(arg_0 -> ((DotName)WebSocketDotNames.WEB_SOCKET_CONNECTION).equals(arg_0))) {
                target = Callback.Target.SERVER;
            } else if (method.parameterTypes().stream().map(org.jboss.jandex.Type::name).anyMatch(arg_0 -> ((DotName)WebSocketDotNames.WEB_SOCKET_CLIENT_CONNECTION).equals(arg_0))) {
                target = Callback.Target.CLIENT;
            }
            Callback callback = new Callback(target, annotation, bean, method, WebSocketProcessor.executionModel(method, transformedAnnotations), callbackArguments, transformedAnnotations, endpointPath, index);
            long errorArguments = callback.arguments.stream().filter(ca -> ca instanceof ErrorCallbackArgument).count();
            if (errorArguments != 1L) {
                throw new WebSocketException(String.format("@OnError callback must accept exactly one error parameter; found %s: %s", errorArguments, callback.asString()));
            }
            errorHandlers.add(callback);
        }
        return errorHandlers;
    }

    private static List<AnnotationInstance> findCallbackAnnotations(IndexView index, ClassInfo beanClass, DotName annotationName) {
        ClassInfo aClass = beanClass;
        ArrayList<AnnotationInstance> annotations = new ArrayList<AnnotationInstance>();
        while (aClass != null) {
            DotName superName;
            List declared = (List)aClass.annotationsMap().get(annotationName);
            if (declared != null) {
                annotations.addAll(declared);
            }
            aClass = (superName = aClass.superName()) != null && !superName.equals((Object)DotNames.OBJECT) ? index.getClassByName(superName) : null;
        }
        return annotations;
    }

    static Callback findCallback(Callback.Target target, IndexView index, BeanInfo bean, ClassInfo beanClass, DotName annotationName, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations, String endpointPath) {
        return WebSocketProcessor.findCallback(target, index, bean, beanClass, annotationName, callbackArguments, transformedAnnotations, endpointPath, null);
    }

    private static Callback findCallback(Callback.Target target, IndexView index, BeanInfo bean, ClassInfo beanClass, DotName annotationName, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations, String endpointPath, Consumer<Callback> validator) {
        List<AnnotationInstance> annotations = WebSocketProcessor.findCallbackAnnotations(index, beanClass, annotationName);
        if (annotations.isEmpty()) {
            return null;
        }
        if (annotations.size() == 1) {
            AnnotationInstance annotation = annotations.get(0);
            MethodInfo method = annotation.target().asMethod();
            Callback callback = new Callback(target, annotation, bean, method, WebSocketProcessor.executionModel(method, transformedAnnotations), callbackArguments, transformedAnnotations, endpointPath, index);
            long messageArguments = callback.arguments.stream().filter(ca -> ca instanceof MessageCallbackArgument).count();
            if (callback.acceptsMessage()) {
                if (messageArguments > 1L) {
                    throw new WebSocketException(String.format("@%s callback may accept at most 1 message parameter; found %s: %s", DotNames.simpleName((DotName)callback.annotation.name()), messageArguments, callback.asString()));
                }
            } else if (messageArguments != 0L) {
                throw new WebSocketException(String.format("@%s callback must not accept a message parameter; found %s: %s", DotNames.simpleName((DotName)callback.annotation.name()), messageArguments, callback.asString()));
            }
            if (target == Callback.Target.CLIENT && callback.broadcast()) {
                throw new WebSocketClientException(String.format("@%s callback declared on a client endpoint must not broadcast messages: %s", DotNames.simpleName((DotName)callback.annotation.name()), callback.asString()));
            }
            if (validator != null) {
                validator.accept(callback);
            }
            return callback;
        }
        throw new WebSocketException(String.format("There can be only one callback annotated with %s declared on %s", annotationName, beanClass));
    }

    private static WebSocketEndpoint.ExecutionModel executionModel(MethodInfo method, TransformedAnnotationsBuildItem transformedAnnotations) {
        if (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method) && (transformedAnnotations.hasAnnotation((AnnotationTarget)method, WebSocketDotNames.RUN_ON_VIRTUAL_THREAD) || transformedAnnotations.hasAnnotation((AnnotationTarget)method.declaringClass(), WebSocketDotNames.RUN_ON_VIRTUAL_THREAD) || transformedAnnotations.hasAnnotation((AnnotationTarget)method, WebSocketDotNames.BLOCKING) || transformedAnnotations.hasAnnotation((AnnotationTarget)method, WebSocketDotNames.NON_BLOCKING))) {
            throw new WebSocketException("Kotlin `suspend` functions in WebSockets Next endpoints may not be annotated @Blocking, @NonBlocking or @RunOnVirtualThread: " + String.valueOf(method));
        }
        if (transformedAnnotations.hasAnnotation((AnnotationTarget)method, WebSocketDotNames.RUN_ON_VIRTUAL_THREAD) || transformedAnnotations.hasAnnotation((AnnotationTarget)method.declaringClass(), WebSocketDotNames.RUN_ON_VIRTUAL_THREAD)) {
            return WebSocketEndpoint.ExecutionModel.VIRTUAL_THREAD;
        }
        if (transformedAnnotations.hasAnnotation((AnnotationTarget)method, WebSocketDotNames.BLOCKING)) {
            return WebSocketEndpoint.ExecutionModel.WORKER_THREAD;
        }
        if (transformedAnnotations.hasAnnotation((AnnotationTarget)method, WebSocketDotNames.NON_BLOCKING)) {
            return WebSocketEndpoint.ExecutionModel.EVENT_LOOP;
        }
        if (transformedAnnotations.hasAnnotation((AnnotationTarget)method, WebSocketDotNames.TRANSACTIONAL) || transformedAnnotations.hasAnnotation((AnnotationTarget)method.declaringClass(), WebSocketDotNames.TRANSACTIONAL)) {
            return WebSocketEndpoint.ExecutionModel.WORKER_THREAD;
        }
        return WebSocketProcessor.hasBlockingSignature(method) ? WebSocketEndpoint.ExecutionModel.WORKER_THREAD : WebSocketEndpoint.ExecutionModel.EVENT_LOOP;
    }

    static boolean hasBlockingSignature(MethodInfo method) {
        if (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method)) {
            return false;
        }
        switch (method.returnType().kind()) {
            case VOID: 
            case CLASS: 
            case ARRAY: {
                return true;
            }
            case PARAMETERIZED_TYPE: {
                DotName name = method.returnType().asParameterizedType().name();
                return !name.equals((Object)WebSocketDotNames.UNI) && !name.equals((Object)WebSocketDotNames.MULTI);
            }
        }
        throw new WebSocketServerException("Unsupported return type:" + WebSocketProcessor.methodToString(method));
    }

    static boolean isUniVoid(org.jboss.jandex.Type type) {
        return WebSocketDotNames.UNI.equals((Object)type.name()) && ((org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0)).name().equals((Object)WebSocketDotNames.VOID);
    }

    static boolean isByteArray(org.jboss.jandex.Type type) {
        return type.kind() == Type.Kind.ARRAY && PrimitiveType.BYTE.equals((Object)type.asArrayType().constituent());
    }

    static String methodToString(MethodInfo method) {
        return String.valueOf(method.declaringClass().name()) + "#" + method.name() + "()";
    }

    private static boolean isOnOpenWithBinaryReturnType(Callback callback) {
        if (callback.isOnOpen()) {
            org.jboss.jandex.Type returnType = callback.returnType();
            if (callback.isReturnTypeUni() || callback.isReturnTypeMulti()) {
                returnType = (org.jboss.jandex.Type)callback.returnType().asParameterizedType().arguments().get(0);
            } else if (callback.isKotlinSuspendFunction()) {
                returnType = KotlinUtils.getKotlinSuspendMethodResult((MethodInfo)callback.method);
            }
            return WebSocketDotNames.BUFFER.equals((Object)returnType.name()) || returnType.kind() == Type.Kind.ARRAY && PrimitiveType.BYTE.equals((Object)returnType.asArrayType().constituent());
        }
        return false;
    }

    record GlobalErrorHandler(BeanInfo bean, Callback callback) {
    }

    private static final class EndpointSecurityChecksBuildItem
    extends SimpleBuildItem {
        private final Map<String, SecurityCheck> endpointIdToSecurityCheck;

        private EndpointSecurityChecksBuildItem(Map<String, SecurityCheck> endpointIdToSecurityCheck) {
            this.endpointIdToSecurityCheck = endpointIdToSecurityCheck;
        }
    }

    record ThrowableInfo(BeanInfo bean, Callback callback, List<DotName> hierarchy) {
        public int level() {
            return this.hierarchy.size();
        }
    }
}

