/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devconsole.spi;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.util.ArtifactInfoUtil;
import java.util.Map;
import java.util.function.Supplier;

public final class DevConsoleRuntimeTemplateInfoBuildItem
extends MultiBuildItem {
    private final String groupId;
    private final String artifactId;
    private final String name;
    private final Supplier<? extends Object> object;

    public DevConsoleRuntimeTemplateInfoBuildItem(String groupId, String artifactId, String name, Supplier<? extends Object> object) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.name = name;
        this.object = object;
    }

    public DevConsoleRuntimeTemplateInfoBuildItem(String name, Supplier<? extends Object> object) {
        String callerClassName = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass().getCanonicalName();
        Class<?> callerClass = null;
        try {
            callerClass = Thread.currentThread().getContextClassLoader().loadClass(callerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Map.Entry info = ArtifactInfoUtil.groupIdAndArtifactId(callerClass);
        this.groupId = (String)info.getKey();
        this.artifactId = (String)info.getValue();
        this.name = name;
        this.object = object;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getName() {
        return this.name;
    }

    public Supplier<? extends Object> getObject() {
        return this.object;
    }
}

