/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.cli;

import io.quarkus.tls.cli.letsencrypt.LetsEncryptConstants;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

public class DotEnvHelper {
    private DotEnvHelper() {
    }

    public static List<String> readDotEnvFile() throws IOException {
        if (!LetsEncryptConstants.DOT_ENV_FILE.exists()) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Files.readAllLines(LetsEncryptConstants.DOT_ENV_FILE.toPath()));
    }

    public static void addOrReplaceProperty(List<String> content, String key, String value) {
        int line = DotEnvHelper.hasLine(content, key);
        if (line != -1) {
            content.set(line, key + "=" + value);
        } else {
            content.add(key + "=" + value);
        }
    }

    private static int hasLine(List<String> content, String key) {
        for (int i = 0; i < content.size(); ++i) {
            if (!content.get(i).startsWith(key + "=") && !content.get(i).startsWith(key + " =")) continue;
            return i;
        }
        return -1;
    }

    public static void deleteQuietly(File file) {
        if (file.isFile()) {
            file.delete();
        }
    }
}

