/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.certs.ca;

import io.smallrye.certs.ca.LinuxCAInstaller;
import io.smallrye.certs.ca.MacCAInstaller;
import io.smallrye.certs.ca.WindowsCAInstaller;
import io.smallrye.common.os.OS;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Date;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CaGenerator {
    static System.Logger LOGGER = System.getLogger(CaGenerator.class.getName());
    public static final String KEYSTORE_KEY_ENTRY = "key";
    public static final String KEYSTORE_CERT_ENTRY = "ca";
    private final File ca;
    private final File key;
    private final File ks;
    private final String password;
    private volatile X509Certificate generatedCA;
    private String cn;

    public CaGenerator(File ca, File key, File ks, String password) {
        Security.addProvider(new BouncyCastleProvider());
        this.ca = ca;
        this.key = key;
        this.ks = ks;
        this.password = password;
    }

    public X509Certificate generate(String cn, String org, String unit, String location, String state, String country) throws Exception {
        BufferedWriter pemWriter;
        String issuerText = "CN=" + cn;
        if (org != null) {
            issuerText = issuerText + ",O=" + org;
        }
        String subjectText = issuerText;
        if (unit != null) {
            subjectText = subjectText + ",OU=" + unit;
        }
        if (location != null) {
            subjectText = subjectText + ",L=" + location;
        }
        if (state != null) {
            subjectText = subjectText + ",ST=" + state;
        }
        if (country != null) {
            subjectText = subjectText + ",C=" + country;
        }
        X500Name issuer = new X500Name(issuerText);
        X500Name subject = new X500Name(subjectText);
        Date yesterday = new Date(System.currentTimeMillis() - 86400000L);
        Date oneYear = new Date(System.currentTimeMillis() + 31536000000L);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(2048, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance(ASN1Sequence.getInstance(keyPair.getPublic().getEncoded()));
        X509v3CertificateBuilder builder = new X509v3CertificateBuilder(issuer, BigInteger.valueOf(System.currentTimeMillis()), yesterday, oneYear, subject, keyInfo);
        builder.addExtension(Extension.keyUsage, true, new KeyUsage(4));
        builder.addExtension(Extension.basicConstraints, true, new BasicConstraints(0));
        builder.addExtension(Extension.subjectKeyIdentifier, false, new JcaX509ExtensionUtils().createSubjectKeyIdentifier(keyPair.getPublic()));
        JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder("SHA256WithRSAEncryption");
        X509Certificate cert = new JcaX509CertificateConverter().getCertificate(builder.build(contentSignerBuilder.build(keyPair.getPrivate())));
        try (FileWriter fileWriter = new FileWriter(this.ca);){
            pemWriter = new BufferedWriter(fileWriter);
            try {
                pemWriter.write("-----BEGIN CERTIFICATE-----\n");
                pemWriter.write(Base64.getEncoder().encodeToString(cert.getEncoded()));
                pemWriter.write("\n-----END CERTIFICATE-----\n\n");
            }
            finally {
                pemWriter.close();
            }
        }
        fileWriter = new FileWriter(this.key);
        try {
            pemWriter = new BufferedWriter(fileWriter);
            try {
                pemWriter.write("-----BEGIN PRIVATE KEY-----\n");
                pemWriter.write(Base64.getEncoder().encodeToString(keyPair.getPrivate().getEncoded()));
                pemWriter.write("\n-----END PRIVATE KEY-----\n\n");
            }
            finally {
                pemWriter.close();
            }
        }
        finally {
            fileWriter.close();
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null, null);
        keyStore.setKeyEntry(KEYSTORE_KEY_ENTRY, keyPair.getPrivate(), this.password.toCharArray(), new Certificate[]{cert});
        keyStore.setCertificateEntry(KEYSTORE_CERT_ENTRY, cert);
        keyStore.store(new FileOutputStream(this.ks), this.password.toCharArray());
        if (OS.MAC.isCurrent() || OS.LINUX.isCurrent()) {
            Set<PosixFilePermission> ownerWritable = PosixFilePermissions.fromString("rw-r--r--");
            Set<PosixFilePermission> ownerRW = PosixFilePermissions.fromString("rw-------");
            Files.setPosixFilePermissions(this.ca.toPath(), ownerWritable);
            Files.setPosixFilePermissions(this.key.toPath(), ownerRW);
            Files.setPosixFilePermissions(this.ks.toPath(), ownerRW);
        }
        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd25 Root CA certificate generated successfully!");
        this.generatedCA = cert;
        this.cn = cn;
        return cert;
    }

    public void generateTrustStore(File trustStore) throws Exception {
        if (!this.ks.isFile() || this.generatedCA == null) {
            throw new IllegalStateException("The keystore has not been generated yet, call `generate` first");
        }
        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd25 Generating p12 truststore...");
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null, null);
        keyStore.setCertificateEntry(KEYSTORE_CERT_ENTRY, this.generatedCA);
        FileOutputStream fos = new FileOutputStream(trustStore);
        keyStore.store(fos, this.password.toCharArray());
        fos.close();
        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd25 Truststore generated successfully: {0}.", trustStore.getAbsolutePath());
    }

    public void installToSystem() throws Exception {
        if (!this.ks.isFile() || this.generatedCA == null) {
            throw new IllegalStateException("The keystore has not been generated yet, call `generate` first");
        }
        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd25 Installing the CA certificate in the system truststore...");
        if (OS.MAC.isCurrent()) {
            MacCAInstaller.installCAOnMac(this.cn, this.ca);
        } else if (OS.WINDOWS.isCurrent()) {
            WindowsCAInstaller.installCAOnWindows(this.cn, this.ca);
        } else if (OS.LINUX.isCurrent()) {
            LinuxCAInstaller.installCAOnLinux(this.cn, this.ca);
        } else {
            LOGGER.log(System.Logger.Level.WARNING, "\u274c Unsupported operating system: {0}", new Object[]{OS.current()});
        }
    }
}

