/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.certs;

import io.smallrye.certs.AliasRequest;
import io.smallrye.certs.CertificateFiles;
import io.smallrye.certs.CertificateHolder;
import io.smallrye.certs.CertificateRequest;
import io.smallrye.certs.CertificateUtils;
import io.smallrye.certs.Format;
import io.smallrye.certs.JksCertificateFiles;
import io.smallrye.certs.PemCertificateFiles;
import io.smallrye.certs.Pkcs12CertificateFiles;
import java.io.File;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CertificateRequestManager {
    private final CertificateRequest request;
    private final String name;
    Map<String, CertificateHolder> holders = new HashMap<String, CertificateHolder>();

    public CertificateRequestManager(CertificateRequest request) throws Exception {
        this.request = request;
        this.name = request.name();
        this.holders.put(request.name(), new CertificateHolder(request.getCN(), request.getSubjectAlternativeNames(), request.getDuration(), request.hasClient(), request.getPassword(), request.issuer()));
        for (String alias : request.aliases().keySet()) {
            AliasRequest nested = request.aliases().get(alias);
            String cn = nested.getCN();
            if (cn == null) {
                cn = request.getCN();
            }
            this.holders.put(alias, new CertificateHolder(cn, nested.getSubjectAlternativeNames(), request.getDuration(), nested.hasClient(), nested.getPassword(), request.issuer()));
        }
    }

    public CertificateHolder getCertificateHolder(String alias) {
        return this.holders.get(alias);
    }

    public CertificateHolder getMainCertificateHolder() {
        return this.holders.get(this.name);
    }

    public List<CertificateFiles> generate(Path root, boolean replaceIfExists) throws Exception {
        ArrayList<CertificateFiles> output = new ArrayList<CertificateFiles>();
        for (Format format : this.request.formats()) {
            switch (format) {
                case PEM: 
                case ENCRYPTED_PEM: {
                    output.addAll(this.generatePemCertificates(root, replaceIfExists));
                    break;
                }
                case JKS: {
                    output.add(this.generateJksCertificates(root, replaceIfExists));
                    break;
                }
                case PKCS12: {
                    output.add(this.generatePkcs12Certificates(root, replaceIfExists));
                }
            }
        }
        return output;
    }

    private CertificateFiles generateJksCertificates(Path root, boolean replaceIfExists) throws Exception {
        JksCertificateFiles files = new JksCertificateFiles(root, this.name, this.request.hasClient(), this.request.getPassword());
        if (replaceIfExists || !files.keyStoreFile().toFile().isFile()) {
            CertificateUtils.writePrivateKeyAndCertificateToJKS(this.holders, this.request.getPassword(), files.keyStoreFile().toFile());
        }
        if (replaceIfExists || !files.trustStoreFile().toFile().isFile()) {
            CertificateUtils.writeClientTrustStoreToJKS(this.holders, files.trustStoreFile().toFile(), this.request.getPassword().toCharArray());
        }
        HashMap<String, CertificateHolder> clients = new HashMap<String, CertificateHolder>();
        for (Map.Entry<String, CertificateHolder> entry : this.holders.entrySet()) {
            if (!entry.getValue().hasClient()) continue;
            clients.put(entry.getKey(), entry.getValue());
        }
        if (!clients.isEmpty()) {
            if (replaceIfExists || !files.clientKeyStoreFile().toFile().isFile()) {
                CertificateUtils.writeClientPrivateKeyAndCertificateToJKS(this.holders, this.request.getPassword(), files.clientKeyStoreFile().toFile());
            }
            if (replaceIfExists || !files.serverTrustStoreFile().toFile().isFile()) {
                CertificateUtils.writeServerTrustStoreToJKS(this.holders, files.serverTrustStoreFile().toFile(), this.request.getPassword().toCharArray());
            }
        }
        return files;
    }

    private CertificateFiles generatePkcs12Certificates(Path root, boolean replaceIfExists) throws Exception {
        Pkcs12CertificateFiles files = new Pkcs12CertificateFiles(root, this.name, this.request.hasClient(), this.request.getPassword());
        if (replaceIfExists || !files.keyStoreFile().toFile().isFile()) {
            CertificateUtils.writePrivateKeyAndCertificateToPKCS12(this.holders, files.keyStoreFile().toFile(), this.request.getPassword().toCharArray());
        }
        if (replaceIfExists || !files.trustStoreFile().toFile().isFile()) {
            CertificateUtils.writeClientTrustStoreToPKCS12(this.holders, files.trustStoreFile().toFile(), this.request.getPassword().toCharArray());
        }
        HashMap<String, CertificateHolder> clients = new HashMap<String, CertificateHolder>();
        for (Map.Entry<String, CertificateHolder> entry : this.holders.entrySet()) {
            if (!entry.getValue().hasClient()) continue;
            clients.put(entry.getKey(), entry.getValue());
        }
        if (!clients.isEmpty()) {
            if (replaceIfExists || !files.clientKeyStoreFile().toFile().isFile()) {
                CertificateUtils.writeClientPrivateKeyAndCertificateToPKCS12(this.holders, files.clientKeyStoreFile().toFile(), this.request.getPassword().toCharArray());
            }
            if (replaceIfExists || !files.serverTrustStoreFile().toFile().isFile()) {
                CertificateUtils.writeServerTrustStoreToPKCS12(this.holders, files.serverTrustStoreFile().toFile(), this.request.getPassword().toCharArray());
            }
        }
        return files;
    }

    private List<CertificateFiles> generatePemCertificates(Path root, boolean replaceIfExists) throws Exception {
        ArrayList<CertificateFiles> files = new ArrayList<CertificateFiles>();
        for (Map.Entry<String, CertificateHolder> entry : this.holders.entrySet()) {
            String alias = entry.getKey();
            CertificateHolder holder = entry.getValue();
            files.add(this.writePem(alias, holder, root, replaceIfExists));
        }
        return files;
    }

    private CertificateFiles writePem(String name, CertificateHolder holder, Path root, boolean replaceIfExists) throws Exception {
        PemCertificateFiles files = new PemCertificateFiles(root, name, holder.hasClient(), this.request.getPassword());
        if (this.request.formats().contains((Object)Format.ENCRYPTED_PEM) && this.request.getPassword() == null) {
            throw new IllegalArgumentException("The password is required for the encrypted PEM format");
        }
        X509Certificate serverCert = holder.certificate();
        X509Certificate clientCert = holder.clientCertificate();
        KeyPair serverKey = holder.keys();
        KeyPair clientKey = holder.clientKeys();
        File certFile = files.certFile().toFile();
        File keyFile = files.keyFile().toFile();
        File clientTrustFile = files.trustFile().toFile();
        File clientCertFile = files.clientCertFile().toFile();
        File clientKeyFile = files.clientKeyFile().toFile();
        File serverTrustfile = files.serverTrustFile().toFile();
        if (replaceIfExists || !certFile.isFile()) {
            CertificateUtils.writeCertificateToPEM(serverCert, certFile, new X509Certificate[0]);
        }
        if (replaceIfExists || !keyFile.isFile()) {
            if (this.request.formats().contains((Object)Format.ENCRYPTED_PEM)) {
                CertificateUtils.writePrivateKeyToPem(serverKey.getPrivate(), this.request.getPassword(), keyFile);
            } else {
                CertificateUtils.writePrivateKeyToPem(serverKey.getPrivate(), null, keyFile);
            }
        }
        if (replaceIfExists || !clientTrustFile.isFile()) {
            CertificateUtils.writeTruststoreToPem(List.of(serverCert), clientTrustFile);
        }
        if (holder.hasClient()) {
            if (replaceIfExists || !clientCertFile.isFile()) {
                CertificateUtils.writeCertificateToPEM(clientCert, clientCertFile, new X509Certificate[0]);
            }
            if (replaceIfExists || !clientKeyFile.isFile()) {
                if (this.request.formats().contains((Object)Format.ENCRYPTED_PEM)) {
                    CertificateUtils.writePrivateKeyToPem(clientKey.getPrivate(), this.request.getPassword(), clientKeyFile);
                } else {
                    CertificateUtils.writePrivateKeyToPem(clientKey.getPrivate(), null, clientKeyFile);
                }
            }
            if (replaceIfExists || !serverTrustfile.isFile()) {
                CertificateUtils.writeTruststoreToPem(List.of(clientCert), serverTrustfile);
            }
        }
        return files;
    }
}

