/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.certs;

import io.smallrye.certs.CertificateFiles;
import io.smallrye.certs.CertificateRequest;
import io.smallrye.certs.CertificateRequestManager;
import io.smallrye.certs.JksCertificateFiles;
import io.smallrye.certs.PemCertificateFiles;
import io.smallrye.certs.Pkcs12CertificateFiles;
import java.io.File;
import java.nio.file.Path;
import java.util.List;

public class CertificateGenerator {
    final File root;
    static System.Logger LOGGER = System.getLogger(CertificateGenerator.class.getName());
    private final boolean replaceIfExists;

    public CertificateGenerator(Path tempDir, boolean replaceIfExists) {
        this.replaceIfExists = replaceIfExists;
        this.root = tempDir.toFile();
    }

    public CertificateGenerator() {
        this.root = new File(".");
        this.replaceIfExists = false;
    }

    public List<CertificateFiles> generate(CertificateRequest request) throws Exception {
        request.validate();
        CertificateRequestManager manager = new CertificateRequestManager(request);
        List<CertificateFiles> certificateFiles = manager.generate(this.root.toPath(), this.replaceIfExists);
        try {
            for (CertificateFiles file : certificateFiles) {
                if (file instanceof PemCertificateFiles) {
                    LOGGER.log(System.Logger.Level.INFO, "\u2b50  PEM certificates, keystore, and truststore named " + file.name() + " generated!");
                    LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd11  Key File: " + ((PemCertificateFiles)file).keyFile().toFile().getAbsolutePath());
                    LOGGER.log(System.Logger.Level.INFO, "\ud83d\udcdc  Cert File: " + ((PemCertificateFiles)file).certFile().toFile().getAbsolutePath());
                    if (file.client()) {
                        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd13  Server Trust Store File: " + ((PemCertificateFiles)file).serverTrustFile().toFile().getAbsolutePath());
                        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd11  Client Key File: " + ((PemCertificateFiles)file).clientKeyFile().toFile().getAbsolutePath());
                        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udcdc  Client Cert File: " + ((PemCertificateFiles)file).clientCertFile().toFile().getAbsolutePath());
                        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd13  Client Trust Store File: " + ((PemCertificateFiles)file).trustFile().toFile().getAbsolutePath());
                        continue;
                    }
                    LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd13  Trust Store File: " + file.trustStore().toFile().getAbsolutePath());
                    continue;
                }
                if (file instanceof JksCertificateFiles) {
                    LOGGER.log(System.Logger.Level.INFO, "\u2b50  JKS keystore and truststore generated successfully!");
                    LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd10  Key Store File: " + ((JksCertificateFiles)file).keyStoreFile().toFile().getAbsolutePath());
                    if (file.client()) {
                        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd13  Server Trust Store File: " + ((JksCertificateFiles)file).serverTrustStoreFile().toFile().getAbsolutePath());
                        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd10  Client Key Store File: " + ((JksCertificateFiles)file).clientKeyStoreFile().toFile().getAbsolutePath());
                        LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd13  Client Trust Store File: " + ((JksCertificateFiles)file).trustStoreFile().toFile().getAbsolutePath());
                        continue;
                    }
                    LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd13  Trust Store File: " + file.trustStore().toFile().getAbsolutePath());
                    continue;
                }
                if (!(file instanceof Pkcs12CertificateFiles)) continue;
                LOGGER.log(System.Logger.Level.INFO, "\u2b50  PKCS12 keystore and truststore generated successfully!");
                LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd10  Key Store File: " + ((Pkcs12CertificateFiles)file).keyStoreFile().toFile().getAbsolutePath());
                if (file.client()) {
                    LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd13  Server Trust Store File: " + ((Pkcs12CertificateFiles)file).serverTrustStoreFile().toFile().getAbsolutePath());
                    LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd10  Client Key Store File: " + ((Pkcs12CertificateFiles)file).clientKeyStoreFile().toFile().getAbsolutePath());
                    LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd13  Client Trust Store File: " + ((Pkcs12CertificateFiles)file).trustStoreFile().toFile().getAbsolutePath());
                    continue;
                }
                LOGGER.log(System.Logger.Level.INFO, "\ud83d\udd13  Trust Store File: " + file.trustStore().toFile().getAbsolutePath());
            }
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.ERROR, "Error while generating the certificates", (Throwable)e);
            throw e;
        }
        return certificateFiles;
    }
}

