/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.cli.letsencrypt;

import io.quarkus.tls.cli.DotEnvHelper;
import io.quarkus.tls.cli.letsencrypt.LetsEncryptConstants;
import io.quarkus.tls.cli.letsencrypt.LetsEncryptHelpers;
import io.smallrye.certs.CertificateGenerator;
import io.smallrye.certs.CertificateRequest;
import io.smallrye.certs.Format;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="prepare", mixinStandardHelpOptions=true, description={"Prepare the environment to receive Let's Encrypt certificates. Make sure to restart the application after having run this command."})
public class LetsEncryptPrepareCommand
implements Callable<Integer> {
    static System.Logger LOGGER = System.getLogger("lets-encrypt-prepare");
    @CommandLine.Option(names={"-d", "--domain"}, description={"The domain for which the certificate will be generated"}, required=true)
    String domain;
    @CommandLine.Option(names={"-n", "--tls-configuration-name"}, description={"The name of the TLS configuration to be used, if not set, the default configuration is used"})
    String tlsConfigurationName;

    @Override
    public Integer call() throws Exception {
        if (!LetsEncryptConstants.LETS_ENCRYPT_DIR.exists() && LetsEncryptConstants.LETS_ENCRYPT_DIR.mkdir()) {
            LOGGER.log(System.Logger.Level.INFO, "\u2705 Created .letsencrypt directory: {0}", LetsEncryptConstants.LETS_ENCRYPT_DIR.getAbsolutePath());
        }
        boolean certExistingAndStillValid = false;
        if (LetsEncryptConstants.CERT_FILE.isFile() && LetsEncryptConstants.KEY_FILE.isFile()) {
            X509Certificate existing = LetsEncryptHelpers.loadCertificateFromPEM(LetsEncryptConstants.CERT_FILE.getAbsolutePath());
            try {
                existing.checkValidity();
                certExistingAndStillValid = true;
            }
            catch (Exception e) {
                LOGGER.log(System.Logger.Level.INFO, "\u26a0\ufe0f The existing certificate is expired, regenerating it...");
            }
        }
        if (!certExistingAndStillValid) {
            CertificateGenerator generator = new CertificateGenerator(LetsEncryptConstants.LETS_ENCRYPT_DIR.toPath(), true);
            CertificateRequest request = new CertificateRequest().withCN(this.domain).withSubjectAlternativeName("DNS:" + this.domain).withDuration(Duration.ofDays(30L)).withFormat(Format.PEM).withName("lets-encrypt");
            generator.generate(request);
        } else {
            LOGGER.log(System.Logger.Level.INFO, "\u2705 Certificate already exists and is still valid: {0}", LetsEncryptConstants.CERT_FILE.getAbsolutePath());
        }
        DotEnvHelper.deleteQuietly(LetsEncryptConstants.CA_FILE);
        List<String> dotEnvContent = DotEnvHelper.readDotEnvFile();
        Object prefix = "quarkus.tls";
        if (this.tlsConfigurationName != null) {
            prefix = (String)prefix + "." + this.tlsConfigurationName;
        }
        DotEnvHelper.addOrReplaceProperty(dotEnvContent, (String)prefix + ".key-store.pem.acme.cert", LetsEncryptConstants.CERT_FILE.getAbsolutePath());
        DotEnvHelper.addOrReplaceProperty(dotEnvContent, (String)prefix + ".key-store.pem.acme.key", LetsEncryptConstants.KEY_FILE.getAbsolutePath());
        Files.write(LetsEncryptConstants.DOT_ENV_FILE.toPath(), dotEnvContent, new OpenOption[0]);
        LOGGER.log(System.Logger.Level.INFO, "\u2705 .env file configured for Let's Encrypt: {0}", LetsEncryptConstants.DOT_ENV_FILE.getAbsolutePath());
        LOGGER.log(System.Logger.Level.INFO, "\u27a1\ufe0f Start the application and run `quarkus tls lets-encrypt issue-certificate --domain={0}{1}` to complete the challenge", this.domain, this.tlsConfigurationName != null ? " -tls-configuration-name=" + this.tlsConfigurationName : "");
        return 0;
    }
}

