/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security.oidc;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.Reader;
import java.io.StringReader;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ClaimType {
    LONG{

        @Override
        public Long convert(String value) {
            return Long.parseLong(value);
        }
    }
    ,
    INTEGER{

        @Override
        public Integer convert(String value) {
            return Integer.parseInt(value);
        }
    }
    ,
    BOOLEAN{

        @Override
        public Boolean convert(String value) {
            return Boolean.parseBoolean(value);
        }
    }
    ,
    STRING{

        @Override
        public String convert(String value) {
            return value;
        }
    }
    ,
    JSON_ARRAY{

        public JsonArray convert(String value) {
            try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(value));){
                JsonArray jsonArray = jsonReader.readArray();
                return jsonArray;
            }
        }
    }
    ,
    JSON_OBJECT{

        public JsonObject convert(String value) {
            try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(value));){
                JsonObject jsonObject = jsonReader.readObject();
                return jsonObject;
            }
        }
    }
    ,
    DEFAULT{

        @Override
        public String convert(String value) {
            return value;
        }
    };


    abstract Object convert(String var1);
}

