/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security.oidc;

import io.quarkus.jsonp.JsonProviderHolder;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.OidcConfigurationMetadata;
import io.quarkus.oidc.TokenIntrospection;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.runtime.OidcJwtCallerPrincipal;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.test.security.TestSecurityIdentityAugmentor;
import io.quarkus.test.security.oidc.Claim;
import io.quarkus.test.security.oidc.ClaimType;
import io.quarkus.test.security.oidc.OidcSecurity;
import io.smallrye.jwt.build.Jwt;
import io.smallrye.jwt.util.KeyUtils;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.lang.annotation.Annotation;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.microprofile.jwt.Claims;
import org.jose4j.jwt.JwtClaims;

public class OidcTestSecurityIdentityAugmentor
implements TestSecurityIdentityAugmentor {
    private static Map<String, ClaimType> standardClaimTypes = Map.of(Claims.exp.name(), ClaimType.LONG, Claims.iat.name(), ClaimType.LONG, Claims.nbf.name(), ClaimType.LONG, Claims.auth_time.name(), ClaimType.LONG, Claims.email_verified.name(), ClaimType.BOOLEAN);
    private static final PrivateKey privateKey;
    private Optional<String> issuer;

    public OidcTestSecurityIdentityAugmentor(Optional<String> issuer) {
        this.issuer = issuer;
    }

    public SecurityIdentity augment(SecurityIdentity identity, Annotation[] annotations) {
        boolean introspectionRequired;
        QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder((SecurityIdentity)identity);
        OidcSecurity oidcSecurity = OidcTestSecurityIdentityAugmentor.findOidcSecurity(annotations);
        boolean bl = introspectionRequired = oidcSecurity != null && oidcSecurity.introspectionRequired();
        if (!introspectionRequired) {
            JsonObjectBuilder claims = JsonProviderHolder.jsonProvider().createObjectBuilder();
            claims.add(Claims.preferred_username.name(), identity.getPrincipal().getName());
            claims.add(Claims.groups.name(), (JsonValue)JsonProviderHolder.jsonProvider().createArrayBuilder((Collection)identity.getRoles().stream().collect(Collectors.toList())).build());
            if (oidcSecurity != null && oidcSecurity.claims() != null) {
                for (Annotation annotation : oidcSecurity.claims()) {
                    Object claimValue = this.convertClaimValue((Claim)annotation);
                    if (claimValue instanceof String) {
                        claims.add(annotation.key(), (String)claimValue);
                        continue;
                    }
                    if (claimValue instanceof Long) {
                        claims.add(annotation.key(), ((Long)claimValue).longValue());
                        continue;
                    }
                    if (claimValue instanceof Integer) {
                        claims.add(annotation.key(), ((Integer)claimValue).intValue());
                        continue;
                    }
                    if (claimValue instanceof Boolean) {
                        claims.add(annotation.key(), ((Boolean)claimValue).booleanValue());
                        continue;
                    }
                    if (claimValue instanceof JsonArray) {
                        claims.add(annotation.key(), (JsonValue)((JsonArray)claimValue));
                        continue;
                    }
                    if (!(claimValue instanceof JsonObject)) continue;
                    claims.add(annotation.key(), (JsonValue)((JsonObject)claimValue));
                }
            }
            JsonObject claimsJson = claims.build();
            String jwt = this.generateToken(claimsJson);
            IdTokenCredential idToken = new IdTokenCredential(jwt);
            AccessTokenCredential accessTokenCredential = new AccessTokenCredential(jwt);
            try {
                OidcJwtCallerPrincipal principal = new OidcJwtCallerPrincipal(JwtClaims.parse((String)claimsJson.toString()), (TokenCredential)idToken);
                builder.setPrincipal((Principal)principal);
            }
            catch (Exception ex) {
                throw new RuntimeException();
            }
            builder.addCredential((Credential)idToken);
            builder.addCredential((Credential)accessTokenCredential);
        } else {
            JsonObjectBuilder introspectionBuilder = JsonProviderHolder.jsonProvider().createObjectBuilder();
            introspectionBuilder.add("active", true);
            introspectionBuilder.add("username", identity.getPrincipal().getName());
            introspectionBuilder.add("scope", identity.getRoles().stream().collect(Collectors.joining(" ")));
            if (oidcSecurity != null && oidcSecurity.introspection() != null) {
                for (Annotation annotation : oidcSecurity.introspection()) {
                    introspectionBuilder.add(annotation.key(), annotation.value());
                }
            }
            builder.addAttribute("introspection", (Object)new TokenIntrospection(introspectionBuilder.build()));
            builder.addCredential((Credential)new AccessTokenCredential(UUID.randomUUID().toString(), null));
        }
        if (oidcSecurity != null && oidcSecurity.userinfo() != null) {
            JsonObjectBuilder userInfoBuilder = JsonProviderHolder.jsonProvider().createObjectBuilder();
            for (Annotation annotation : oidcSecurity.userinfo()) {
                userInfoBuilder.add(annotation.key(), annotation.value());
            }
            builder.addAttribute("userinfo", (Object)new UserInfo(userInfoBuilder.build()));
        }
        io.vertx.core.json.JsonObject configMetadataBuilder = new io.vertx.core.json.JsonObject();
        if (this.issuer.isPresent()) {
            configMetadataBuilder.put("issuer", (Object)this.issuer.get());
        }
        if (oidcSecurity != null && oidcSecurity.config() != null) {
            for (Annotation annotation : oidcSecurity.config()) {
                configMetadataBuilder.put(annotation.key(), (Object)annotation.value());
            }
        }
        builder.addAttribute("configuration-metadata", (Object)new OidcConfigurationMetadata(configMetadataBuilder));
        return builder.build();
    }

    private String generateToken(JsonObject claims) {
        try {
            return Jwt.claims((JsonObject)claims).sign(privateKey);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static OidcSecurity findOidcSecurity(Annotation[] annotations) {
        for (Annotation ann : annotations) {
            if (!(ann instanceof OidcSecurity)) continue;
            return (OidcSecurity)ann;
        }
        return null;
    }

    private Object convertClaimValue(Claim claim) {
        ClaimType type = claim.type();
        if (type == ClaimType.DEFAULT && standardClaimTypes.containsKey(claim.key())) {
            type = standardClaimTypes.get(claim.key());
        }
        return type.convert(claim.value());
    }

    static {
        try {
            privateKey = KeyUtils.generateKeyPair((int)2048).getPrivate();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }
}

