/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.oidc.client;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.config.ConfigProvider;

public class OidcTestClient {
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(10L);
    private static final String CLIENT_AUTH_SERVER_URL_PROP = "client.quarkus.oidc.auth-server-url";
    private static final String AUTH_SERVER_URL_PROP = "quarkus.oidc.auth-server-url";
    private static final String CLIENT_ID_PROP = "quarkus.oidc.client-id";
    private static final String CLIENT_SECRET_PROP = "quarkus.oidc.credentials.secret";
    private volatile Vertx vertx = null;
    private volatile WebClient client = null;
    private String authServerUrl;
    private String tokenUrl;

    public String getClientAccessToken() {
        return this.getClientAccessToken(null);
    }

    public String getClientAccessToken(Map<String, String> extraProps) {
        return this.getClientAccessToken(this.getClientId(), this.getClientSecret(), extraProps);
    }

    public String getClientAccessToken(String clientId, String clientSecret) {
        return this.getClientAccessToken(clientId, clientSecret, null);
    }

    public String getClientAccessToken(String clientId, String clientSecret, Map<String, String> extraProps) {
        MultiMap requestMap = MultiMap.caseInsensitiveMultiMap();
        requestMap.add("grant_type", "client_credentials").add("client_id", clientId);
        if (clientSecret != null && !clientSecret.isBlank()) {
            requestMap.add("client_secret", clientSecret);
        }
        return this.getAccessTokenInternal(requestMap, extraProps);
    }

    public String getAccessToken(String userName, String userSecret) {
        return this.getAccessToken(userName, userSecret, null);
    }

    public String getAccessToken(String userName, String userSecret, Map<String, String> extraProps) {
        return this.getAccessToken(this.getClientId(), this.getClientSecret(), userName, userSecret, extraProps);
    }

    public String getAccessToken(String clientId, String clientSecret, String userName, String userSecret) {
        return this.getAccessToken(userName, userSecret, clientId, clientSecret, null);
    }

    public String getAccessToken(String clientId, String clientSecret, String userName, String userSecret, Map<String, String> extraProps) {
        MultiMap requestMap = MultiMap.caseInsensitiveMultiMap();
        requestMap.add("grant_type", "password").add("username", userName).add("password", userSecret);
        requestMap.add("client_id", clientId);
        if (clientSecret != null && !clientSecret.isBlank()) {
            requestMap.add("client_secret", clientSecret);
        }
        return this.getAccessTokenInternal(requestMap, extraProps);
    }

    private String getAccessTokenInternal(MultiMap requestMap, Map<String, String> extraProps) {
        if (extraProps != null) {
            requestMap = requestMap.addAll(extraProps);
        }
        Future result = this.getClient().postAbs(this.getTokenUrl()).putHeader("Content-Type", "application/x-www-form-urlencoded").sendBuffer(OidcTestClient.encodeForm(requestMap));
        Awaitility.await().atMost(REQUEST_TIMEOUT).until(() -> ((Future)result).isComplete());
        return ((HttpResponse)result.result()).bodyAsJsonObject().getString("access_token");
    }

    private String getClientId() {
        return this.getPropertyValue(CLIENT_ID_PROP);
    }

    private String getClientSecret() {
        return this.getPropertyValue(CLIENT_SECRET_PROP);
    }

    public String getAuthServerUrl() {
        if (this.authServerUrl == null) {
            this.authServerUrl = this.getOptionalPropertyValue(CLIENT_AUTH_SERVER_URL_PROP, AUTH_SERVER_URL_PROP);
        }
        return this.authServerUrl;
    }

    public String getTokenUrl() {
        if (this.tokenUrl == null) {
            this.getAuthServerUrl();
            Future result = this.getClient().getAbs(this.authServerUrl + "/.well-known/openid-configuration").send();
            Awaitility.await().atMost(REQUEST_TIMEOUT).until(() -> ((Future)result).isComplete());
            this.tokenUrl = ((HttpResponse)result.result()).bodyAsJsonObject().getString("token_endpoint");
        }
        return this.tokenUrl;
    }

    private String getPropertyValue(String prop) {
        return (String)ConfigProvider.getConfig().getValue(prop, String.class);
    }

    private String getOptionalPropertyValue(String prop, String defaultProp) {
        return ConfigProvider.getConfig().getOptionalValue(prop, String.class).orElseGet(() -> (String)ConfigProvider.getConfig().getValue(defaultProp, String.class));
    }

    public static Buffer encodeForm(MultiMap form) {
        Buffer buffer = Buffer.buffer();
        for (Map.Entry entry : form) {
            if (buffer.length() != 0) {
                buffer.appendByte((byte)38);
            }
            buffer.appendString((String)entry.getKey());
            buffer.appendByte((byte)61);
            buffer.appendString(OidcTestClient.urlEncode((String)entry.getValue()));
        }
        return buffer;
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private WebClient getClient() {
        if (this.client == null) {
            this.client = WebClient.create((Vertx)this.getVertx());
        }
        return this.client;
    }

    private Vertx getVertx() {
        Vertx managedVertx;
        ArcContainer container = Arc.container();
        if (container != null && container.isRunning() && (managedVertx = (Vertx)container.instance(Vertx.class, new Annotation[0]).orElse(null)) != null) {
            return managedVertx;
        }
        if (this.vertx == null) {
            this.vertx = Vertx.vertx();
        }
        return this.vertx;
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        if (this.vertx != null) {
            this.vertx.close().toCompletionStage().toCompletableFuture().join();
            this.vertx = null;
        }
    }
}

