/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import de.flapdoodle.embed.mongo.commands.MongodArguments;
import de.flapdoodle.embed.mongo.commands.ServerAddress;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.transitions.Mongod;
import de.flapdoodle.embed.mongo.transitions.RunningMongodProcess;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.TransitionWalker;
import de.flapdoodle.reverse.transitions.Start;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.quarkus.test.mongodb.MongoTestResource;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jboss.logging.Logger;

public class MongoReplicaSetTestResource
implements QuarkusTestResourceLifecycleManager {
    public static final String REPLICA_SET = "replicaSet";
    static final String DEFAULT_REPLICA_SET = "test001";
    private static final Logger LOGGER = Logger.getLogger(MongoReplicaSetTestResource.class);
    private Integer port;
    private IFeatureAwareVersion version;
    private String replicaSet;
    private List<TransitionWalker.ReachedState<RunningMongodProcess>> startedServers = Collections.emptyList();

    private static Net net(String hostName, int port) {
        return Net.builder().from(Net.defaults()).bindIp(hostName).port(port).build();
    }

    public static String setReplicaSet(Map<String, String> initArgs) {
        return Optional.ofNullable(initArgs.get(REPLICA_SET)).orElse(DEFAULT_REPLICA_SET);
    }

    private static List<TransitionWalker.ReachedState<RunningMongodProcess>> startReplicaSet(IFeatureAwareVersion version, int basePort, String replicaSet) {
        TransitionWalker.ReachedState firstStarted = MongoReplicaSetTestResource.mongodWithPort(basePort, replicaSet).start((Version)version, new Listener[0]);
        try {
            TransitionWalker.ReachedState secondStarted = MongoReplicaSetTestResource.mongodWithPort(basePort + 1, replicaSet).start((Version)version, new Listener[0]);
            try {
                ServerAddress firstAddress = ((RunningMongodProcess)firstStarted.current()).getServerAddress();
                ServerAddress secondAddress = ((RunningMongodProcess)secondStarted.current()).getServerAddress();
                MongoReplicaSetTestResource.initializeReplicaSet(Arrays.asList(firstAddress, secondAddress), replicaSet);
                LOGGER.infof("ReplicaSet initialized with servers - firstServer: %s , secondServer: %s", (Object)firstAddress, (Object)secondAddress);
                return Arrays.asList(secondStarted, firstStarted);
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Shutting down second Mongo Server.");
                secondStarted.close();
                LOGGER.errorv((Throwable)ex, "Error while initializing replicaSet. Error Message %s", (Object)ex.getMessage());
                throw new RuntimeException("Error starting second server and initializing replicaset.", ex);
            }
        }
        catch (RuntimeException rx) {
            LOGGER.error((Object)"Shutting down first Mongo Server.");
            firstStarted.close();
            throw rx;
        }
    }

    private static Mongod mongodWithPort(int port, String replicaSet) {
        return Mongod.instance().withNet((Transition)Start.to(Net.class).initializedWith((Object)MongoReplicaSetTestResource.net("localhost", port))).withProcessOutput((Transition)Start.to(ProcessOutput.class).initializedWith((Object)ProcessOutput.silent())).withMongodArguments((Transition)Start.to(MongodArguments.class).initializedWith((Object)MongodArguments.defaults().withArgs(Map.of("--replSet", replicaSet)).withSyncDelay(10).withUseSmallFiles(true).withUseNoJournal(false)));
    }

    private static void initializeReplicaSet(List<ServerAddress> mongodConfigList, String replicaSet) throws UnknownHostException {
        String arbitrerAddress = "mongodb://" + mongodConfigList.get(0).getHost() + ":" + mongodConfigList.get(0).getPort();
        MongoClientSettings mo = MongoClientSettings.builder().applyConnectionString(new ConnectionString(arbitrerAddress)).build();
        try (MongoClient mongo = MongoClients.create((MongoClientSettings)mo);){
            MongoDatabase mongoAdminDB = mongo.getDatabase("admin");
            Document cr = mongoAdminDB.runCommand((Bson)new Document("isMaster", (Object)1));
            LOGGER.infof("isMaster: %s", (Object)cr);
            Document rsConfiguration = MongoReplicaSetTestResource.buildReplicaSetConfiguration(mongodConfigList, replicaSet);
            LOGGER.infof("replSetSettings: %s", (Object)rsConfiguration);
            cr = mongoAdminDB.runCommand((Bson)new Document("replSetInitiate", (Object)rsConfiguration));
            LOGGER.infof("replSetInitiate: %s", (Object)cr);
            Awaitility.await().atMost(Durations.ONE_MINUTE).with().pollInterval(Durations.ONE_SECOND).until(() -> {
                Document result = mongoAdminDB.runCommand((Bson)new Document("replSetGetStatus", (Object)1));
                LOGGER.infof("replSetGetStatus: %s", (Object)result);
                boolean replicaSetStatus = MongoReplicaSetTestResource.isReplicaSetStarted(result);
                LOGGER.infof("replicaSet Readiness Status: %s", (Object)replicaSetStatus);
                return replicaSetStatus;
            });
            LOGGER.info((Object)"ReplicaSet is now ready with 2 cluster node.");
        }
    }

    private static Document buildReplicaSetConfiguration(List<ServerAddress> configList, String replicaSet) throws UnknownHostException {
        Document replicaSetSetting = new Document();
        replicaSetSetting.append("_id", (Object)replicaSet);
        ArrayList<Document> members = new ArrayList<Document>();
        int i = 0;
        for (ServerAddress mongoConfig : configList) {
            members.add(new Document().append("_id", (Object)i++).append("host", (Object)(mongoConfig.getHost() + ":" + mongoConfig.getPort())));
        }
        replicaSetSetting.append("members", members);
        LOGGER.infof("ReplicaSet Configuration settings: %s", (Object)replicaSetSetting);
        return replicaSetSetting;
    }

    private static boolean isReplicaSetStarted(Document setting) {
        if (!setting.containsKey((Object)"members")) {
            return false;
        }
        List members = (List)setting.get((Object)"members", List.class);
        for (Document member : members) {
            LOGGER.infof("replica set member %s", (Object)member);
            int state = member.getInteger((Object)"state");
            LOGGER.infof("state: %s", (Object)state);
            if (state == 1 || state == 2 || state == 7) continue;
            return false;
        }
        return true;
    }

    public void init(Map<String, String> initArgs) {
        this.port = MongoTestResource.port(initArgs);
        this.version = MongoTestResource.version(initArgs);
        this.replicaSet = MongoReplicaSetTestResource.setReplicaSet(initArgs);
    }

    public Map<String, String> start() {
        MongoTestResource.forceExtendedSocketOptionsClassInit();
        this.startedServers = MongoReplicaSetTestResource.startReplicaSet(this.version, this.port, this.replicaSet);
        return Collections.singletonMap("quarkus.mongodb.hosts", String.format("127.0.0.1:%d", this.port));
    }

    public void stop() {
        LOGGER.info((Object)"Shutting down embedded mongo severs...");
        for (TransitionWalker.ReachedState<RunningMongodProcess> startedServer : this.startedServers) {
            LOGGER.infof("Shutting down embedded mongo server : %s", startedServer);
            startedServer.close();
        }
        this.startedServers = Collections.emptyList();
    }
}

