/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.google.cloud.functions.test;

import io.quarkus.google.cloud.functions.test.CloudFunctionsInvoker;
import io.quarkus.google.cloud.functions.test.FunctionType;
import io.quarkus.google.cloud.functions.test.WithFunction;
import io.quarkus.test.common.QuarkusTestResourceConfigurableLifecycleManager;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.microprofile.config.ConfigProvider;

public class CloudFunctionTestResource
implements QuarkusTestResourceConfigurableLifecycleManager<WithFunction> {
    private FunctionType functionType;
    private String functionName;
    private CloudFunctionsInvoker invoker;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public void init(WithFunction withFunction) {
        this.functionType = withFunction.value();
        this.functionName = withFunction.functionName();
    }

    public Map<String, String> start() {
        return "".equals(this.functionName) ? Collections.emptyMap() : Map.of(this.functionType.getFunctionProperty(), this.functionName);
    }

    public void inject(QuarkusTestResourceLifecycleManager.TestInjector testInjector) {
        if (this.started.compareAndSet(false, true)) {
            int port = ConfigProvider.getConfig().getOptionalValue("quarkus.http.test-port", Integer.class).orElse(8081);
            this.invoker = new CloudFunctionsInvoker(this.functionType, port);
            try {
                this.invoker.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void stop() {
        try {
            this.invoker.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

