/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common.http;

import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.runtime.test.TestHttpEndpointProvider;
import io.quarkus.test.common.http.TestHTTPEndpoint;
import io.quarkus.test.common.http.TestHTTPResource;
import io.quarkus.test.common.http.TestHTTPResourceProvider;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.eclipse.microprofile.config.ConfigProvider;

public class TestHTTPResourceManager {
    public static String getUri() {
        try {
            return (String)ConfigProvider.getConfig().getValue("test.url", String.class);
        }
        catch (IllegalStateException e) {
            return "http://localhost:8080";
        }
    }

    public static String getManagementUri() {
        try {
            return (String)ConfigProvider.getConfig().getValue("test.management.url", String.class);
        }
        catch (IllegalStateException e) {
            return "http://localhost:9000";
        }
    }

    public static String getSslUri() {
        return (String)ConfigProvider.getConfig().getValue("test.url.ssl", String.class);
    }

    public static String getManagementSslUri() {
        return (String)ConfigProvider.getConfig().getValue("test.management.url.ssl", String.class);
    }

    public static String getUri(RunningQuarkusApplication application) {
        return (String)application.getConfigValue("test.url", String.class).get();
    }

    public static String getSslUri(RunningQuarkusApplication application) {
        return (String)application.getConfigValue("test.url.ssl", String.class).get();
    }

    public static void inject(Object testCase) {
        TestHTTPResourceManager.inject(testCase, TestHttpEndpointProvider.load());
    }

    public static void inject(Object testCase, List<Function<Class<?>, String>> endpointProviders) {
        Map<Class<?>, TestHTTPResourceProvider<?>> providers = TestHTTPResourceManager.getProviders();
        for (Class<?> c = testCase.getClass(); c != Object.class; c = c.getSuperclass()) {
            TestHTTPEndpoint classEndpointAnnotation = c.getAnnotation(TestHTTPEndpoint.class);
            for (Field f : c.getDeclaredFields()) {
                TestHTTPResource resource = f.getAnnotation(TestHTTPResource.class);
                if (resource == null) continue;
                TestHTTPResourceProvider<?> provider = providers.get(f.getType());
                if (provider == null) {
                    throw new RuntimeException("Unable to inject TestHTTPResource field " + String.valueOf(f) + " as no provider exists for the type");
                }
                Object path = resource.value();
                if (((String)path).startsWith("/")) {
                    path = ((String)path).substring(1);
                }
                String endpointPath = null;
                boolean management = resource.management();
                TestHTTPEndpoint fieldEndpointAnnotation = f.getAnnotation(TestHTTPEndpoint.class);
                if (fieldEndpointAnnotation != null) {
                    endpointPath = TestHTTPResourceManager.getEndpointPath(endpointProviders, f, fieldEndpointAnnotation);
                } else if (classEndpointAnnotation != null) {
                    endpointPath = TestHTTPResourceManager.getEndpointPath(endpointProviders, f, classEndpointAnnotation);
                }
                if (!((String)path).isEmpty() && endpointPath != null) {
                    path = endpointPath.endsWith("/") ? endpointPath + (String)path : endpointPath + "/" + (String)path;
                } else if (endpointPath != null) {
                    path = endpointPath;
                }
                String val = resource.ssl() || resource.tls() || ConfigProvider.getConfig().getOptionalValue("quarkus.http.test-ssl-enabled", Boolean.class).orElse(false).booleanValue() ? (management ? (((String)path).startsWith("/") ? TestHTTPResourceManager.getManagementSslUri() + (String)path : TestHTTPResourceManager.getManagementSslUri() + "/" + (String)path) : (((String)path).startsWith("/") ? TestHTTPResourceManager.getSslUri() + (String)path : TestHTTPResourceManager.getSslUri() + "/" + (String)path)) : (management ? (((String)path).startsWith("/") ? TestHTTPResourceManager.getManagementUri() + (String)path : TestHTTPResourceManager.getManagementUri() + "/" + (String)path) : (((String)path).startsWith("/") ? TestHTTPResourceManager.getUri() + (String)path : TestHTTPResourceManager.getUri() + "/" + (String)path));
                f.setAccessible(true);
                try {
                    f.set(testCase, provider.provide(val, f));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static Map<Class<?>, TestHTTPResourceProvider<?>> getProviders() {
        HashMap map = new HashMap();
        for (TestHTTPResourceProvider i : ServiceLoader.load(TestHTTPResourceProvider.class, TestHTTPResourceProvider.class.getClassLoader())) {
            map.put(i.getProvidedType(), i);
        }
        return Collections.unmodifiableMap(map);
    }

    private static String getEndpointPath(List<Function<Class<?>, String>> endpointProviders, Field field, TestHTTPEndpoint endpointAnnotation) {
        for (Function<Class<?>, String> func : endpointProviders) {
            String endpointPath = func.apply(endpointAnnotation.value());
            if (endpointPath == null) continue;
            return endpointPath;
        }
        throw new RuntimeException("Could not determine the endpoint path for " + String.valueOf(endpointAnnotation.value()) + " to inject " + String.valueOf(field));
    }
}

