/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.web.deployment;

import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.resteasy.common.deployment.ResteasyCommonProcessor;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.deployment.NonJaxRsClassBuildItem;
import io.quarkus.resteasy.runtime.NonJaxRsClassMappings;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentCustomizerBuildItem;
import io.quarkus.resteasy.server.common.spi.AdditionalJaxRsResourceDefiningAnnotationBuildItem;
import io.quarkus.resteasy.server.common.spi.AdditionalJaxRsResourceMethodParamAnnotations;
import io.quarkus.spring.web.runtime.common.ResponseStatusExceptionMapper;
import io.quarkus.undertow.deployment.IgnoredServletContainerInitializerBuildItem;
import io.quarkus.undertow.deployment.ServletInitParamBuildItem;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.metadata.SpringResourceBuilder;
import org.jboss.resteasy.spring.web.ResponseEntityFeature;
import org.jboss.resteasy.spring.web.ResponseStatusFeature;

public class SpringWebResteasyClassicProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)SpringWebResteasyClassicProcessor.class.getName());
    private static final DotName REQUEST_MAPPING = DotName.createSimple((String)"org.springframework.web.bind.annotation.RequestMapping");
    private static final DotName GET_MAPPING = DotName.createSimple((String)"org.springframework.web.bind.annotation.GetMapping");
    private static final DotName POST_MAPPING = DotName.createSimple((String)"org.springframework.web.bind.annotation.PostMapping");
    private static final DotName PUT_MAPPING = DotName.createSimple((String)"org.springframework.web.bind.annotation.PutMapping");
    private static final DotName DELETE_MAPPING = DotName.createSimple((String)"org.springframework.web.bind.annotation.DeleteMapping");
    private static final DotName PATCH_MAPPING = DotName.createSimple((String)"org.springframework.web.bind.annotation.PatchMapping");
    private static final List<DotName> MAPPING_ANNOTATIONS = List.of(REQUEST_MAPPING, GET_MAPPING, POST_MAPPING, PUT_MAPPING, DELETE_MAPPING, PATCH_MAPPING);
    private static final DotName REST_CONTROLLER_ANNOTATION = DotName.createSimple((String)"org.springframework.web.bind.annotation.RestController");
    private static final DotName PATH_VARIABLE = DotName.createSimple((String)"org.springframework.web.bind.annotation.PathVariable");

    @BuildStep
    public IgnoredServletContainerInitializerBuildItem ignoreSpringServlet() {
        return new IgnoredServletContainerInitializerBuildItem("org.springframework.web.SpringServletContainerInitializer");
    }

    @BuildStep
    public AdditionalJaxRsResourceDefiningAnnotationBuildItem additionalJaxRsResourceDefiningAnnotation() {
        return new AdditionalJaxRsResourceDefiningAnnotationBuildItem(REST_CONTROLLER_ANNOTATION);
    }

    @BuildStep
    public AdditionalJaxRsResourceMethodParamAnnotations additionalJaxRsResourceMethodParamAnnotations() {
        return new AdditionalJaxRsResourceMethodParamAnnotations(List.of(DotName.createSimple((String)"org.springframework.web.bind.annotation.RequestParam"), PATH_VARIABLE, DotName.createSimple((String)"org.springframework.web.bind.annotation.RequestBody"), DotName.createSimple((String)"org.springframework.web.bind.annotation.MatrixVariable"), DotName.createSimple((String)"org.springframework.web.bind.annotation.RequestHeader"), DotName.createSimple((String)"org.springframework.web.bind.annotation.CookieValue")));
    }

    @BuildStep
    public void registerStandardExceptionMappers(BuildProducer<ResteasyJaxrsProviderBuildItem> providersProducer) {
        providersProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(ResponseStatusExceptionMapper.class.getName()));
    }

    @BuildStep
    public void process(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ServletInitParamBuildItem> initParamProducer, BuildProducer<ResteasyDeploymentCustomizerBuildItem> deploymentCustomizerProducer) {
        this.validateControllers(beanArchiveIndexBuildItem);
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        Collection annotations = index.getAnnotations(REST_CONTROLLER_ANNOTATION);
        if (annotations.isEmpty()) {
            return;
        }
        final HashSet<String> classNames = new HashSet<String>();
        for (AnnotationInstance annotation : annotations) {
            classNames.add(annotation.target().asClass().toString());
        }
        initParamProducer.produce((BuildItem)new ServletInitParamBuildItem("resteasy.scanned.resource.classes.with.builder", SpringResourceBuilder.class.getName() + ":" + String.join((CharSequence)",", classNames)));
        deploymentCustomizerProducer.produce((BuildItem)new ResteasyDeploymentCustomizerBuildItem((Consumer)new Consumer<ResteasyDeployment>(){

            @Override
            public void accept(ResteasyDeployment resteasyDeployment) {
                resteasyDeployment.getScannedResourceClassesWithBuilder().put(SpringResourceBuilder.class.getName(), new ArrayList(classNames));
            }
        }));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{SpringResourceBuilder.class.getName()}).build());
    }

    private void validateControllers(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem) {
        HashSet<DotName> classesWithoutRestController = new HashSet<DotName>();
        for (DotName mappingAnnotation : MAPPING_ANNOTATIONS) {
            Collection annotations = beanArchiveIndexBuildItem.getIndex().getAnnotations(mappingAnnotation);
            for (AnnotationInstance annotation : annotations) {
                ClassInfo targetClass;
                if (annotation.target().kind() == AnnotationTarget.Kind.CLASS) {
                    targetClass = annotation.target().asClass();
                } else {
                    if (annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                    targetClass = annotation.target().asMethod().declaringClass();
                }
                if (targetClass.declaredAnnotation(REST_CONTROLLER_ANNOTATION) != null) continue;
                classesWithoutRestController.add(targetClass.name());
            }
        }
        if (!classesWithoutRestController.isEmpty()) {
            for (DotName dotName : classesWithoutRestController) {
                LOGGER.warn((Object)("Class '" + String.valueOf(dotName) + "' uses a mapping annotation but the class itself was not annotated with '@RestController'. The mappings will therefore be ignored."));
            }
        }
    }

    @BuildStep
    public void registerProviders(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BuildProducer<ResteasyJaxrsProviderBuildItem> providersProducer) throws IOException {
        Set availableProviders = ServiceUtil.classNamesNamedIn((ClassLoader)this.getClass().getClassLoader(), (String)("META-INF/services/" + Providers.class.getName()));
        MediaTypeMap categorizedReaders = new MediaTypeMap();
        MediaTypeMap categorizedWriters = new MediaTypeMap();
        MediaTypeMap categorizedContextResolvers = new MediaTypeMap();
        HashSet otherProviders = new HashSet();
        ResteasyCommonProcessor.categorizeProviders((Set)availableProviders, (MediaTypeMap)categorizedReaders, (MediaTypeMap)categorizedWriters, (MediaTypeMap)categorizedContextResolvers, otherProviders);
        boolean useAllAvailable = false;
        Set<String> providersToRegister = new HashSet();
        block0: for (DotName mappingClass : MAPPING_ANNOTATIONS) {
            Collection instances = beanArchiveIndexBuildItem.getIndex().getAnnotations(mappingClass);
            for (AnnotationInstance instance : instances) {
                if (this.collectProviders(providersToRegister, (MediaTypeMap<String>)categorizedWriters, instance, "produces")) {
                    useAllAvailable = true;
                    break block0;
                }
                if (this.collectProviders(providersToRegister, (MediaTypeMap<String>)categorizedContextResolvers, instance, "produces")) {
                    useAllAvailable = true;
                    break block0;
                }
                if (!this.collectProviders(providersToRegister, (MediaTypeMap<String>)categorizedReaders, instance, "consumes")) continue;
                useAllAvailable = true;
                break block0;
            }
        }
        if (useAllAvailable) {
            providersToRegister = availableProviders;
        } else {
            providersToRegister.addAll(categorizedWriters.getPossible(MediaType.APPLICATION_JSON_TYPE));
            providersToRegister.add(ResponseEntityFeature.class.getName());
            providersToRegister.add(ResponseStatusFeature.class.getName());
        }
        for (String provider : providersToRegister) {
            providersProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(provider));
        }
    }

    private boolean collectProviders(Set<String> providersToRegister, MediaTypeMap<String> categorizedProviders, AnnotationInstance instance, String annotationValueName) {
        AnnotationValue producesValue = instance.value(annotationValueName);
        if (producesValue != null) {
            for (String value : producesValue.asStringArray()) {
                MediaType mediaType = MediaType.valueOf((String)value);
                if (MediaType.WILDCARD_TYPE.equals((Object)mediaType)) {
                    return true;
                }
                providersToRegister.addAll(categorizedProviders.getPossible(mediaType));
            }
        }
        return false;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public void registerWithDevModeNotFoundMapper(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BuildProducer<NonJaxRsClassBuildItem> nonJaxRsClassProducer) {
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        Collection restControllerAnnotations = index.getAnnotations(REST_CONTROLLER_ANNOTATION);
        if (restControllerAnnotations.isEmpty()) {
            return;
        }
        HashMap<String, NonJaxRsClassMappings> nonJaxRsPaths = new HashMap<String, NonJaxRsClassMappings>();
        for (AnnotationInstance restControllerInstance : restControllerAnnotations) {
            String basePathFromAnnotation;
            String basePath = "/";
            ClassInfo restControllerAnnotatedClass = restControllerInstance.target().asClass();
            AnnotationInstance requestMappingInstance = restControllerAnnotatedClass.declaredAnnotation(REQUEST_MAPPING);
            if (requestMappingInstance != null && (basePathFromAnnotation = this.getMappingValue(requestMappingInstance)) != null) {
                basePath = basePathFromAnnotation;
            }
            HashMap<String, String> methodNameToPath = new HashMap<String, String>();
            NonJaxRsClassMappings nonJaxRsClassMappings = new NonJaxRsClassMappings();
            nonJaxRsClassMappings.setMethodNameToPath(methodNameToPath);
            nonJaxRsClassMappings.setBasePath(basePath);
            List methods = restControllerAnnotatedClass.methods();
            block1: for (MethodInfo method : methods) {
                String methodName = method.name();
                for (DotName mappingClass : MAPPING_ANNOTATIONS) {
                    AnnotationInstance mappingClassAnnotation = method.annotation(mappingClass);
                    if (mappingClassAnnotation == null) continue;
                    Object methodPath = this.getMappingValue(mappingClassAnnotation);
                    if (methodPath == null) {
                        methodPath = "";
                    } else if (!((String)methodPath).startsWith("/")) {
                        methodPath = "/" + (String)methodPath;
                    }
                    methodNameToPath.put(methodName, (String)methodPath);
                    continue block1;
                }
            }
            if (methodNameToPath.isEmpty()) continue;
            nonJaxRsPaths.put(restControllerAnnotatedClass.name().toString(), nonJaxRsClassMappings);
        }
        if (!nonJaxRsPaths.isEmpty()) {
            nonJaxRsClassProducer.produce((BuildItem)new NonJaxRsClassBuildItem(nonJaxRsPaths));
        }
    }

    private String getMappingValue(AnnotationInstance instance) {
        if (instance == null) {
            return null;
        }
        if (instance.value() != null) {
            return instance.value().asStringArray()[0];
        }
        if (instance.value("path") != null) {
            return instance.value("path").asStringArray()[0];
        }
        return null;
    }
}

