/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.web.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.spring.web.deployment.AbstractExceptionMapperGenerator;
import io.quarkus.spring.web.deployment.ResponseBuilder;
import io.quarkus.spring.web.deployment.TypesUtil;
import io.quarkus.spring.web.runtime.common.ResponseEntityConverter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class ControllerAdviceExceptionMapperGenerator
extends AbstractExceptionMapperGenerator {
    private static final DotName RESPONSE_ENTITY = DotName.createSimple((String)"org.springframework.http.ResponseEntity");
    private static final List<String> TEXT_MEDIA_TYPES = Arrays.asList("text/plain", "application/json", "application/xml", "text/xml");
    private static final List<String> OBJECT_MEDIA_TYPES = Arrays.asList("application/json", "application/xml", "text/xml", "text/plain");
    private final MethodInfo controllerAdviceMethod;
    private final TypesUtil typesUtil;
    private final Type returnType;
    private final List<Type> parameterTypes;
    private final String declaringClassName;
    private final Map<Type, FieldDescriptor> parameterTypeToField = new HashMap<Type, FieldDescriptor>();
    private FieldDescriptor httpHeadersField;
    private final boolean isResteasyClassic;

    ControllerAdviceExceptionMapperGenerator(MethodInfo controllerAdviceMethod, DotName exceptionDotName, ClassOutput classOutput, TypesUtil typesUtil, boolean isResteasyClassic) {
        super(exceptionDotName, classOutput, isResteasyClassic);
        this.controllerAdviceMethod = controllerAdviceMethod;
        this.typesUtil = typesUtil;
        this.returnType = controllerAdviceMethod.returnType();
        this.parameterTypes = controllerAdviceMethod.parameterTypes();
        this.declaringClassName = controllerAdviceMethod.declaringClass().name().toString();
        this.isResteasyClassic = isResteasyClassic;
    }

    @Override
    protected void preGenerateMethodBody(ClassCreator cc) {
        if (!this.isResteasyClassic) {
            return;
        }
        int notAllowedParameterIndex = -1;
        for (int i = 0; i < this.parameterTypes.size(); ++i) {
            FieldCreator httpRequestFieldCreator;
            Type parameterType = this.parameterTypes.get(i);
            DotName parameterTypeDotName = parameterType.name();
            if (this.typesUtil.isAssignable(Exception.class, parameterTypeDotName)) continue;
            if (this.typesUtil.isAssignable(HttpServletRequest.class, parameterTypeDotName)) {
                if (this.parameterTypeToField.containsKey(parameterType)) {
                    throw new IllegalArgumentException("Parameter type " + String.valueOf(this.parameterTypes.get(notAllowedParameterIndex).name()) + " is being used multiple times in method" + this.controllerAdviceMethod.name() + " of class" + String.valueOf(this.controllerAdviceMethod.declaringClass().name()));
                }
                httpRequestFieldCreator = (FieldCreator)cc.getFieldCreator("httpServletRequest", HttpServletRequest.class).setModifiers(2);
                httpRequestFieldCreator.addAnnotation(Context.class);
                this.parameterTypeToField.put(parameterType, httpRequestFieldCreator.getFieldDescriptor());
                continue;
            }
            if (this.typesUtil.isAssignable(HttpServletResponse.class, parameterTypeDotName)) {
                if (this.parameterTypeToField.containsKey(parameterType)) {
                    throw new IllegalArgumentException("Parameter type " + String.valueOf(this.parameterTypes.get(notAllowedParameterIndex).name()) + " is being used multiple times in method" + this.controllerAdviceMethod.name() + " of class" + String.valueOf(this.controllerAdviceMethod.declaringClass().name()));
                }
                httpRequestFieldCreator = (FieldCreator)cc.getFieldCreator("httpServletResponse", HttpServletResponse.class).setModifiers(2);
                httpRequestFieldCreator.addAnnotation(Context.class);
                this.parameterTypeToField.put(parameterType, httpRequestFieldCreator.getFieldDescriptor());
                continue;
            }
            notAllowedParameterIndex = i;
        }
        if (notAllowedParameterIndex >= 0) {
            throw new IllegalArgumentException("Parameter type " + String.valueOf(this.parameterTypes.get(notAllowedParameterIndex).name()) + " is not supported for method" + this.controllerAdviceMethod.name() + " of class" + String.valueOf(this.controllerAdviceMethod.declaringClass().name()));
        }
        this.createHttpHeadersField(cc);
    }

    private void createHttpHeadersField(ClassCreator classCreator) {
        FieldCreator httpHeadersFieldCreator = (FieldCreator)classCreator.getFieldCreator("httpHeaders", HttpHeaders.class).setModifiers(2);
        httpHeadersFieldCreator.addAnnotation(Context.class);
        this.httpHeadersField = httpHeadersFieldCreator.getFieldDescriptor();
    }

    @Override
    void generateMethodBody(MethodCreator toResponse) {
        if (this.isVoidType(this.returnType)) {
            this.generateVoidExceptionHandler(toResponse);
        } else if (this.isEntityType(this.returnType)) {
            this.generateResponseEntityExceptionHandler(toResponse);
        } else {
            this.generateGenericResponseExceptionHandler(toResponse);
        }
    }

    private void generateVoidExceptionHandler(MethodCreator methodCreator) {
        this.invokeExceptionHandlerMethod(methodCreator);
        int status = this.getAnnotationStatusOrDefault(Response.Status.NO_CONTENT.getStatusCode());
        ResultHandle result = new ResponseBuilder(methodCreator, status).withType(this.getResponseContentType(methodCreator, TEXT_MEDIA_TYPES)).build();
        methodCreator.returnValue(result);
    }

    private void generateResponseEntityExceptionHandler(MethodCreator methodCreator) {
        ResultHandle result = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod((String)ResponseEntityConverter.class.getName(), (String)"toResponse", (String)Response.class.getName(), (String[])new String[]{RESPONSE_ENTITY.toString(), MediaType.class.getName()}), new ResultHandle[]{this.invokeExceptionHandlerMethod(methodCreator), this.getResponseContentType(methodCreator, this.getSupportedMediaTypesForType(this.getResponseEntityType()))});
        methodCreator.returnValue(result);
    }

    private Type getResponseEntityType() {
        if (this.isParameterizedType(this.returnType) && this.returnType.asParameterizedType().arguments().size() == 1) {
            return (Type)this.returnType.asParameterizedType().arguments().get(0);
        }
        return this.returnType;
    }

    private void generateGenericResponseExceptionHandler(MethodCreator methodCreator) {
        int status = this.getAnnotationStatusOrDefault(Response.Status.OK.getStatusCode());
        ResultHandle result = new ResponseBuilder(methodCreator, status).withEntity(this.invokeExceptionHandlerMethod(methodCreator)).withType(this.getResponseContentType(methodCreator, this.getSupportedMediaTypesForType(this.returnType))).build();
        methodCreator.returnValue(result);
    }

    private List<String> getSupportedMediaTypesForType(Type type) {
        if (this.isStringType(type) || this.isPrimitiveType(type)) {
            return TEXT_MEDIA_TYPES;
        }
        return OBJECT_MEDIA_TYPES;
    }

    private ResultHandle getResponseContentType(MethodCreator methodCreator, List<String> supportedMediaTypeStrings) {
        ResultHandle[] supportedMediaTypes = (ResultHandle[])supportedMediaTypeStrings.stream().map(arg_0 -> ((MethodCreator)methodCreator).load(arg_0)).toArray(ResultHandle[]::new);
        String responseContentTypeResolverClassName = this.isResteasyClassic ? "io.quarkus.spring.web.runtime.ResteasyClassicResponseContentTypeResolver" : "io.quarkus.spring.web.runtime.ResteasyReactiveResponseContentTypeResolver";
        ResultHandle contentTypeResolver = methodCreator.newInstance(MethodDescriptor.ofConstructor((String)responseContentTypeResolverClassName, (String[])new String[0]), new ResultHandle[0]);
        if (this.isResteasyClassic) {
            return methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)responseContentTypeResolverClassName, (String)"resolve", MediaType.class, (Object[])new Object[]{HttpHeaders.class, String[].class}), contentTypeResolver, new ResultHandle[]{methodCreator.readInstanceField(this.httpHeadersField, methodCreator.getThis()), methodCreator.marshalAsArray(String.class, supportedMediaTypes)});
        }
        return methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)responseContentTypeResolverClassName, (String)"resolve", MediaType.class, (Object[])new Object[]{HttpHeaders.class, String[].class}), contentTypeResolver, new ResultHandle[]{this.getBeanFromArc(methodCreator, HttpHeaders.class.getName()), methodCreator.marshalAsArray(String.class, supportedMediaTypes)});
    }

    private ResultHandle invokeExceptionHandlerMethod(MethodCreator toResponse) {
        String returnTypeClassName;
        String string = returnTypeClassName = this.isVoidType(this.returnType) ? Void.TYPE.getName() : this.returnType.name().toString();
        if (this.parameterTypes.isEmpty()) {
            return toResponse.invokeVirtualMethod(MethodDescriptor.ofMethod((String)this.declaringClassName, (String)this.controllerAdviceMethod.name(), (String)returnTypeClassName, (String[])new String[0]), this.controllerAdviceInstance(toResponse), new ResultHandle[0]);
        }
        String[] parameterTypesStr = new String[this.parameterTypes.size()];
        ResultHandle[] parameterTypeHandles = new ResultHandle[this.parameterTypes.size()];
        if (this.isResteasyClassic) {
            for (int i = 0; i < this.parameterTypes.size(); ++i) {
                Type parameterType = this.parameterTypes.get(i);
                parameterTypesStr[i] = parameterType.name().toString();
                parameterTypeHandles[i] = this.typesUtil.isAssignable(Exception.class, parameterType.name()) ? toResponse.getMethodParam(i) : toResponse.readInstanceField(this.parameterTypeToField.get(parameterType), toResponse.getThis());
            }
        } else {
            for (int i = 0; i < this.parameterTypes.size(); ++i) {
                Type parameterType = this.parameterTypes.get(i);
                parameterTypesStr[i] = parameterType.name().toString();
                if (this.typesUtil.isAssignable(Exception.class, parameterType.name())) {
                    parameterTypeHandles[i] = toResponse.getMethodParam(i);
                    continue;
                }
                if (this.typesUtil.isAssignable(UriInfo.class, parameterType.name())) {
                    parameterTypeHandles[i] = this.getBeanFromArc(toResponse, UriInfo.class.getName());
                    continue;
                }
                if (this.typesUtil.isAssignable(Request.class, parameterType.name())) {
                    parameterTypeHandles[i] = this.getBeanFromArc(toResponse, Request.class.getName());
                    continue;
                }
                throw new IllegalArgumentException("Parameter type '" + String.valueOf(parameterType.name()) + "' is not supported for method '" + this.controllerAdviceMethod.name() + "' of class '" + String.valueOf(this.controllerAdviceMethod.declaringClass().name()) + "'");
            }
        }
        return toResponse.invokeVirtualMethod(MethodDescriptor.ofMethod((String)this.declaringClassName, (String)this.controllerAdviceMethod.name(), (String)returnTypeClassName, (String[])parameterTypesStr), this.controllerAdviceInstance(toResponse), parameterTypeHandles);
    }

    private ResultHandle controllerAdviceInstance(MethodCreator toResponse) {
        if (this.isResteasyClassic) {
            ResultHandle controllerAdviceClass = toResponse.loadClassFromTCCL(this.declaringClassName);
            ResultHandle container = toResponse.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle instance = toResponse.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), container, new ResultHandle[]{controllerAdviceClass, toResponse.loadNull()});
            ResultHandle bean = toResponse.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instance, new ResultHandle[0]);
            return toResponse.checkCast(bean, this.controllerAdviceMethod.declaringClass().name().toString());
        }
        return toResponse.checkCast(this.getBeanFromArc(toResponse, this.declaringClassName), this.controllerAdviceMethod.declaringClass().name().toString());
    }

    private ResultHandle getBeanFromArc(MethodCreator methodCreator, String beanClassName) {
        ResultHandle container = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle instance = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), container, new ResultHandle[]{methodCreator.loadClassFromTCCL(beanClassName), methodCreator.loadNull()});
        return methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instance, new ResultHandle[0]);
    }

    private int getAnnotationStatusOrDefault(int defaultValue) {
        AnnotationInstance annotation = this.controllerAdviceMethod.annotation(RESPONSE_STATUS);
        if (annotation == null) {
            return defaultValue;
        }
        return this.getHttpStatusFromAnnotation(annotation);
    }

    private boolean isVoidType(Type type) {
        return Type.Kind.VOID.equals((Object)type.kind());
    }

    private boolean isPrimitiveType(Type type) {
        return Type.Kind.PRIMITIVE.equals((Object)type.kind());
    }

    private boolean isStringType(Type type) {
        return DotName.createSimple((String)String.class.getName()).equals((Object)type.name());
    }

    private boolean isEntityType(Type type) {
        return RESPONSE_ENTITY.equals((Object)type.name());
    }

    private boolean isParameterizedType(Type type) {
        return Type.Kind.PARAMETERIZED_TYPE.equals((Object)type.kind());
    }
}

