/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.web.runtime.common;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;

public class ResponseEntityConverter {
    public static Response toResponse(ResponseEntity responseEntity, MediaType defaultMediaType) {
        Response.ResponseBuilder responseBuilder = Response.status((int)responseEntity.getStatusCodeValue()).entity(responseEntity.getBody());
        Map<String, List<String>> jaxRsHeaders = ResponseEntityConverter.toJaxRsHeaders(responseEntity.getHeaders());
        if (!jaxRsHeaders.containsKey("Content-Type") && defaultMediaType != null) {
            jaxRsHeaders.put("Content-Type", Collections.singletonList(defaultMediaType.toString()));
        }
        for (Map.Entry<String, List<String>> entry : jaxRsHeaders.entrySet()) {
            List<String> value = entry.getValue();
            if (value.size() == 1) {
                responseBuilder.header(entry.getKey(), (Object)entry.getValue().get(0));
                continue;
            }
            responseBuilder.header(entry.getKey(), entry.getValue());
        }
        return responseBuilder.build();
    }

    private static Map<String, List<String>> toJaxRsHeaders(HttpHeaders springHeaders) {
        return new HashMap<String, List<String>>((Map<String, List<String>>)springHeaders);
    }
}

