/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.rest.deployment.paging;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.panache.common.Sort;
import io.quarkus.spring.data.rest.deployment.crud.CrudMethodsImplementor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.IndexView;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;

public class PagingAndSortingMethodsImplementor
extends CrudMethodsImplementor {
    public static final MethodDescriptor LIST_PAGED = MethodDescriptor.ofMethod(PagingAndSortingRepository.class, (String)"findAll", Page.class, (Class[])new Class[]{Pageable.class});
    private static final Class<?> PANACHE_PAGE = io.quarkus.panache.common.Page.class;
    private static final Class<?> PANACHE_SORT = Sort.class;
    private static final Class<?> PANACHE_COLUMN = Sort.Column.class;
    private static final Class<?> PANACHE_DIRECTION = Sort.Direction.class;

    public PagingAndSortingMethodsImplementor(IndexView index) {
        super(index);
    }

    @Override
    public void implementList(ClassCreator classCreator, String repositoryInterface) {
        MethodCreator methodCreator = classCreator.getMethodCreator("list", List.class, new Class[]{io.quarkus.panache.common.Page.class, Sort.class, String.class, Map.class});
        ResultHandle page = methodCreator.getMethodParam(0);
        ResultHandle sort = methodCreator.getMethodParam(1);
        ResultHandle pageable = this.toPageable(methodCreator, page, sort);
        ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterface);
        ResultHandle resultPage = methodCreator.invokeInterfaceMethod(LIST_PAGED, repository, new ResultHandle[]{pageable});
        ResultHandle result = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Page.class, (String)"getContent", List.class, (Class[])new Class[0]), resultPage, new ResultHandle[0]);
        methodCreator.returnValue(result);
        methodCreator.close();
    }

    @Override
    public void implementListPageCount(ClassCreator classCreator, String repositoryInterface) {
        MethodCreator methodCreator = classCreator.getMethodCreator("$$_page_count_list", Integer.TYPE, new Class[]{io.quarkus.panache.common.Page.class});
        ResultHandle page = methodCreator.getMethodParam(0);
        ResultHandle pageable = this.toPageable(methodCreator, page);
        ResultHandle repository = this.getRepositoryInstance((BytecodeCreator)methodCreator, repositoryInterface);
        ResultHandle resultPage = methodCreator.invokeInterfaceMethod(LIST_PAGED, repository, new ResultHandle[]{pageable});
        ResultHandle pageCount = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Page.class, (String)"getTotalPages", Integer.TYPE, (Class[])new Class[0]), resultPage, new ResultHandle[0]);
        methodCreator.returnValue(pageCount);
        methodCreator.close();
    }

    private ResultHandle toPageable(MethodCreator creator, ResultHandle panachePage, ResultHandle panacheSort) {
        ResultHandle index = creator.readInstanceField(FieldDescriptor.of(PANACHE_PAGE, (String)"index", Integer.TYPE), panachePage);
        ResultHandle size = creator.readInstanceField(FieldDescriptor.of(PANACHE_PAGE, (String)"size", Integer.TYPE), panachePage);
        ResultHandle springSort = this.toSpringSort(creator, panacheSort);
        return creator.invokeStaticMethod(MethodDescriptor.ofMethod(PageRequest.class, (String)"of", PageRequest.class, (Class[])new Class[]{Integer.TYPE, Integer.TYPE, org.springframework.data.domain.Sort.class}), new ResultHandle[]{index, size, springSort});
    }

    private ResultHandle toPageable(MethodCreator creator, ResultHandle panachePage) {
        ResultHandle index = creator.readInstanceField(FieldDescriptor.of(PANACHE_PAGE, (String)"index", Integer.TYPE), panachePage);
        ResultHandle size = creator.readInstanceField(FieldDescriptor.of(PANACHE_PAGE, (String)"size", Integer.TYPE), panachePage);
        return creator.invokeStaticMethod(MethodDescriptor.ofMethod(PageRequest.class, (String)"of", PageRequest.class, (Class[])new Class[]{Integer.TYPE, Integer.TYPE}), new ResultHandle[]{index, size});
    }

    private ResultHandle toSpringSort(MethodCreator creator, ResultHandle panacheSort) {
        AssignableResultHandle springSort = creator.createVariable(org.springframework.data.domain.Sort.class);
        creator.assign(springSort, creator.invokeStaticMethod(MethodDescriptor.ofMethod(org.springframework.data.domain.Sort.class, (String)"unsorted", org.springframework.data.domain.Sort.class, (Class[])new Class[0]), new ResultHandle[0]));
        ResultHandle columns = creator.invokeVirtualMethod(MethodDescriptor.ofMethod(PANACHE_SORT, (String)"getColumns", List.class, (Class[])new Class[0]), panacheSort, new ResultHandle[0]);
        ResultHandle columnsIterator = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), columns, new ResultHandle[0]);
        BytecodeCreator loopCreator = creator.whileLoop(c -> this.iteratorHasNext((BytecodeCreator)c, columnsIterator)).block();
        ResultHandle column = loopCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), columnsIterator, new ResultHandle[0]);
        this.addColumn(loopCreator, springSort, column);
        return springSort;
    }

    private BranchResult iteratorHasNext(BytecodeCreator creator, ResultHandle iterator) {
        return creator.ifTrue(creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]), iterator, new ResultHandle[0]));
    }

    private void addColumn(BytecodeCreator creator, AssignableResultHandle springSort, ResultHandle column) {
        ResultHandle orderArray = creator.newArray(Sort.Order.class, 1);
        this.setOrder(creator, orderArray, column);
        ResultHandle subSort = creator.invokeStaticMethod(MethodDescriptor.ofMethod(org.springframework.data.domain.Sort.class, (String)"by", org.springframework.data.domain.Sort.class, (Class[])new Class[]{Sort.Order[].class}), new ResultHandle[]{orderArray});
        creator.assign(springSort, creator.invokeVirtualMethod(MethodDescriptor.ofMethod(org.springframework.data.domain.Sort.class, (String)"and", org.springframework.data.domain.Sort.class, (Class[])new Class[]{org.springframework.data.domain.Sort.class}), (ResultHandle)springSort, new ResultHandle[]{subSort}));
    }

    private void setOrder(BytecodeCreator creator, ResultHandle orderArray, ResultHandle column) {
        ResultHandle columnName = creator.invokeVirtualMethod(MethodDescriptor.ofMethod(PANACHE_COLUMN, (String)"getName", String.class, (Class[])new Class[0]), column, new ResultHandle[0]);
        ResultHandle direction = creator.invokeVirtualMethod(MethodDescriptor.ofMethod(PANACHE_COLUMN, (String)"getDirection", PANACHE_DIRECTION, (Class[])new Class[0]), column, new ResultHandle[0]);
        BranchResult isAscendingBranch = this.isAscending(creator, direction);
        isAscendingBranch.trueBranch().writeArrayValue(orderArray, 0, isAscendingBranch.trueBranch().invokeStaticMethod(MethodDescriptor.ofMethod(Sort.Order.class, (String)"asc", Sort.Order.class, (Class[])new Class[]{String.class}), new ResultHandle[]{columnName}));
        isAscendingBranch.falseBranch().writeArrayValue(orderArray, 0, isAscendingBranch.falseBranch().invokeStaticMethod(MethodDescriptor.ofMethod(Sort.Order.class, (String)"desc", Sort.Order.class, (Class[])new Class[]{String.class}), new ResultHandle[]{columnName}));
    }

    private BranchResult isAscending(BytecodeCreator creator, ResultHandle panacheDirection) {
        ResultHandle ascending = creator.invokeStaticMethod(MethodDescriptor.ofMethod(PANACHE_DIRECTION, (String)"valueOf", PANACHE_DIRECTION, (Class[])new Class[]{String.class}), new ResultHandle[]{creator.load("Ascending")});
        return creator.ifTrue(creator.invokeVirtualMethod(MethodDescriptor.ofMethod(PANACHE_DIRECTION, (String)"equals", Boolean.TYPE, (Class[])new Class[]{Object.class}), ascending, new ResultHandle[]{panacheDirection}));
    }
}

