/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.runtime;

import io.quarkus.hibernate.orm.panache.Panache;
import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.common.runtime.AbstractJpaOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class RepositorySupport {
    private RepositorySupport() {
    }

    public static List<?> findByIds(AbstractJpaOperations<PanacheQuery<?>> operations, Class<?> entityClass, Iterable<?> ids) {
        Objects.requireNonNull(ids);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object id : ids) {
            Object byId = operations.findById(entityClass, id);
            if (byId == null) continue;
            result.add(byId);
        }
        return result;
    }

    public static List<?> findByIds(AbstractJpaOperations<PanacheQuery<?>> operations, Class<?> entityClass, String idField, Iterable<Long> ids) {
        Objects.requireNonNull(ids);
        return ((PanacheQuery)operations.find(entityClass, String.format("%s in ?1", idField), new Object[]{ids})).list();
    }

    public static void deleteAll(AbstractJpaOperations<PanacheQuery<?>> operations, Iterable<?> entities) {
        for (Object entity : entities) {
            operations.delete(entity);
        }
    }

    @Deprecated
    public static Object getOne(AbstractJpaOperations<PanacheQuery<?>> operations, Class<?> entityClass, Object id) {
        return RepositorySupport.getReferenceById(operations, entityClass, id);
    }

    @Deprecated
    public static Object getById(AbstractJpaOperations<PanacheQuery<?>> operations, Class<?> entityClass, Object id) {
        return RepositorySupport.getReferenceById(operations, entityClass, id);
    }

    public static Object getReferenceById(AbstractJpaOperations<PanacheQuery<?>> operations, Class<?> entityClass, Object id) {
        return operations.getSession(entityClass).getReference(entityClass, id);
    }

    public static void clear(Class<?> clazz) {
        Panache.getSession(clazz).clear();
    }

    public static void flush(Class<?> clazz) {
        Panache.getSession(clazz).flush();
    }
}

