/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.deployment;

import io.quarkus.runtime.LaunchMode;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class SqlFileConfigBuilderCustomizer
implements SmallRyeConfigBuilderCustomizer {
    public void configBuilder(SmallRyeConfigBuilder builder) {
        if (!LaunchMode.current().isDevOrTest()) {
            return;
        }
        List<String> supportedSqlFiles = List.of("import.sql", "data.sql");
        ArrayList<String> sqlFilesThatExist = new ArrayList<String>();
        for (String sqlFile : supportedSqlFiles) {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(sqlFile);
            if (resource == null || resource.getProtocol().equals("jar")) continue;
            sqlFilesThatExist.add(sqlFile);
        }
        if (!sqlFilesThatExist.isEmpty()) {
            builder.withSources(new ConfigSource[]{new PropertiesConfigSource(Map.of("quarkus.hibernate-orm.sql-load-script", String.join((CharSequence)",", sqlFilesThatExist)), "quarkus-spring-data-jpa", 50)});
        }
    }
}

