/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.data.deployment.generate;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.panache.common.Page;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.spring.data.deployment.DotNames;
import io.quarkus.spring.data.runtime.RepositorySupport;
import io.quarkus.spring.data.runtime.TypesConverter;
import jakarta.persistence.NoResultException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;

public abstract class AbstractMethodsAdder {
    protected void handleLongReturnValue(BytecodeCreator methodCreator, ResultHandle resultHandle, DotName returnType) {
        if (DotNames.LONG.equals((Object)returnType)) {
            resultHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Long.class, (String)"valueOf", Long.class, (Class[])new Class[]{Long.TYPE}), new ResultHandle[]{resultHandle});
        }
        methodCreator.returnValue(resultHandle);
    }

    protected void handleIntegerReturnValue(BytecodeCreator methodCreator, ResultHandle resultHandle, DotName returnType) {
        if (DotNames.INTEGER.equals((Object)returnType)) {
            resultHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Integer.class, (String)"valueOf", Integer.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{resultHandle});
        }
        methodCreator.returnValue(resultHandle);
    }

    protected void handleBooleanReturnValue(BytecodeCreator methodCreator, ResultHandle resultHandle, DotName returnType) {
        if (DotNames.BOOLEAN.equals((Object)returnType)) {
            resultHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Boolean.class, (String)"valueOf", Boolean.class, (Class[])new Class[]{Boolean.TYPE}), new ResultHandle[]{resultHandle});
        }
        methodCreator.returnValue(resultHandle);
    }

    protected void generateFindQueryResultHandling(MethodCreator methodCreator, ResultHandle panacheQuery, Integer pageableParameterIndex, ClassInfo repositoryClassInfo, ClassInfo entityClassInfo, DotName returnType, Integer limit, String methodName, DotName customResultType, String originalResultType) {
        ResultHandle page = null;
        if (limit != null) {
            page = methodCreator.newInstance(MethodDescriptor.ofConstructor(Page.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{methodCreator.load(limit.intValue())});
        } else if (pageableParameterIndex != null) {
            page = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(TypesConverter.class, (String)"toPanachePage", Page.class, (Class[])new Class[]{Pageable.class}), new ResultHandle[]{methodCreator.getMethodParam(pageableParameterIndex.intValue())});
        }
        if (page != null) {
            panacheQuery = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), panacheQuery, new ResultHandle[]{page});
        }
        if (returnType.equals((Object)entityClassInfo.name())) {
            String panacheQueryMethodToUse = limit != null ? "firstResult" : "singleResult";
            TryBlock tryBlock = methodCreator.tryBlock();
            ResultHandle singleResult = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)panacheQueryMethodToUse, Object.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
            ResultHandle casted = tryBlock.checkCast(singleResult, entityClassInfo.name().toString());
            tryBlock.returnValue(casted);
            CatchBlockCreator catchBlock = tryBlock.addCatch(NoResultException.class);
            catchBlock.returnValue(catchBlock.loadNull());
        } else if (DotNames.OPTIONAL.equals((Object)returnType)) {
            String panacheQueryMethodToUse = limit != null ? "firstResult" : "singleResult";
            TryBlock tryBlock = methodCreator.tryBlock();
            ResultHandle singleResult = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)panacheQueryMethodToUse, Object.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
            if (customResultType == null) {
                ResultHandle casted = tryBlock.checkCast(singleResult, entityClassInfo.name().toString());
                optional = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"ofNullable", Optional.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{casted});
                tryBlock.returnValue(optional);
            } else {
                ResultHandle customResult = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod((String)customResultType.toString(), (String)("convert_" + methodName), (String)customResultType.toString(), (String[])new String[]{originalResultType}), new ResultHandle[]{singleResult});
                optional = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"ofNullable", Optional.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{customResult});
                tryBlock.returnValue(optional);
            }
            CatchBlockCreator catchBlock = tryBlock.addCatch(NoResultException.class);
            ResultHandle emptyOptional = catchBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"empty", Optional.class, (Class[])new Class[0]), new ResultHandle[0]);
            catchBlock.returnValue(emptyOptional);
        } else if (DotNames.LIST.equals((Object)returnType) || DotNames.COLLECTION.equals((Object)returnType) || DotNames.SET.equals((Object)returnType) || DotNames.ITERATOR.equals((Object)returnType) || DotNames.SPRING_DATA_PAGE.equals((Object)returnType) || DotNames.SPRING_DATA_SLICE.equals((Object)returnType)) {
            ResultHandle list;
            if (customResultType == null) {
                list = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", List.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
            } else {
                ResultHandle stream = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"stream", Stream.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
                FunctionCreator customResultMappingFunction = methodCreator.createFunction(Function.class);
                BytecodeCreator funcBytecode = customResultMappingFunction.getBytecode();
                ResultHandle obj = funcBytecode.invokeStaticMethod(MethodDescriptor.ofMethod((String)customResultType.toString(), (String)("convert_" + methodName), (String)customResultType.toString(), (String[])new String[]{originalResultType}), new ResultHandle[]{funcBytecode.getMethodParam(0)});
                funcBytecode.returnValue(obj);
                stream = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Stream.class, (String)"map", Stream.class, (Class[])new Class[]{Function.class}), stream, new ResultHandle[]{customResultMappingFunction.getInstance()});
                ResultHandle collector = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Collectors.class, (String)"toList", Collector.class, (Class[])new Class[0]), new ResultHandle[0]);
                list = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Stream.class, (String)"collect", Object.class, (Class[])new Class[]{Collector.class}), stream, new ResultHandle[]{collector});
            }
            if (DotNames.ITERATOR.equals((Object)returnType)) {
                ResultHandle iterator = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), list, new ResultHandle[0]);
                methodCreator.returnValue(iterator);
            } else if (DotNames.SET.equals((Object)returnType)) {
                ResultHandle set = methodCreator.newInstance(MethodDescriptor.ofConstructor(LinkedHashSet.class, (Class[])new Class[]{Collection.class}), new ResultHandle[]{list});
                methodCreator.returnValue(set);
            } else if (DotNames.SPRING_DATA_PAGE.equals((Object)returnType)) {
                ResultHandle pageResult;
                if (pageableParameterIndex != null) {
                    ResultHandle count = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"count", Long.TYPE, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
                    pageResult = methodCreator.newInstance(MethodDescriptor.ofConstructor(PageImpl.class, (Class[])new Class[]{List.class, Pageable.class, Long.TYPE}), new ResultHandle[]{list, methodCreator.getMethodParam(pageableParameterIndex.intValue()), count});
                } else {
                    pageResult = methodCreator.newInstance(MethodDescriptor.ofConstructor(PageImpl.class, (Class[])new Class[]{List.class}), new ResultHandle[]{list});
                }
                methodCreator.returnValue(pageResult);
            } else if (DotNames.SPRING_DATA_SLICE.equals((Object)returnType)) {
                ResultHandle sliceResult;
                if (pageableParameterIndex != null) {
                    ResultHandle hasNextPage = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"hasNextPage", Boolean.TYPE, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
                    sliceResult = methodCreator.newInstance(MethodDescriptor.ofConstructor(SliceImpl.class, (Class[])new Class[]{List.class, Pageable.class, Boolean.TYPE}), new ResultHandle[]{list, methodCreator.getMethodParam(pageableParameterIndex.intValue()), hasNextPage});
                } else {
                    sliceResult = methodCreator.newInstance(MethodDescriptor.ofConstructor(SliceImpl.class, (Class[])new Class[]{List.class}), new ResultHandle[]{list});
                }
                methodCreator.returnValue(sliceResult);
            }
            methodCreator.returnValue(list);
        } else if (DotNames.STREAM.equals((Object)returnType)) {
            ResultHandle stream = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"stream", Stream.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
            methodCreator.returnValue(stream);
        } else if (this.isHibernateSupportedReturnType(returnType)) {
            ResultHandle singleResult = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"singleResult", Object.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
            methodCreator.returnValue(singleResult);
        } else if (customResultType != null) {
            String panacheQueryMethodToUse = limit != null ? "firstResult" : "singleResult";
            TryBlock tryBlock = methodCreator.tryBlock();
            ResultHandle singleResult = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)panacheQueryMethodToUse, Object.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
            ResultHandle customResult = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod((String)customResultType.toString(), (String)("convert_" + methodName), (String)customResultType.toString(), (String[])new String[]{originalResultType}), new ResultHandle[]{singleResult});
            tryBlock.returnValue(customResult);
            CatchBlockCreator catchBlock = tryBlock.addCatch(NoResultException.class);
            catchBlock.returnValue(catchBlock.loadNull());
            tryBlock.returnValue(customResult);
        } else {
            throw new IllegalArgumentException("Return type of method " + methodName + " of Repository " + String.valueOf(repositoryClassInfo) + " does not match find query type");
        }
    }

    protected void handleFlushAutomatically(AnnotationInstance modifyingAnnotation, MethodCreator methodCreator, FieldDescriptor entityClassFieldDescriptor) {
        AnnotationValue flushAutomatically;
        AnnotationValue annotationValue = flushAutomatically = modifyingAnnotation != null ? modifyingAnnotation.value("flushAutomatically") : null;
        if (flushAutomatically != null && flushAutomatically.asBoolean()) {
            methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(RepositorySupport.class, (String)"flush", Void.TYPE, (Class[])new Class[]{Class.class}), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis())});
        }
    }

    protected void handleClearAutomatically(AnnotationInstance modifyingAnnotation, MethodCreator methodCreator, FieldDescriptor entityClassFieldDescriptor) {
        AnnotationValue clearAutomatically;
        AnnotationValue annotationValue = clearAutomatically = modifyingAnnotation != null ? modifyingAnnotation.value("clearAutomatically") : null;
        if (clearAutomatically != null && clearAutomatically.asBoolean()) {
            methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(RepositorySupport.class, (String)"clear", Void.TYPE, (Class[])new Class[]{Class.class}), new ResultHandle[]{methodCreator.readInstanceField(entityClassFieldDescriptor, methodCreator.getThis())});
        }
    }

    protected boolean isHibernateSupportedReturnType(DotName dotName) {
        return dotName.equals((Object)DotNames.OBJECT) || DotNames.HIBERNATE_PROVIDED_BASIC_TYPES.contains(dotName);
    }

    protected Type verifyQueryResultType(Type t, IndexView index) {
        if (this.isHibernateSupportedReturnType(t.name())) {
            return t;
        }
        if (t.kind() == Type.Kind.ARRAY) {
            return this.verifyQueryResultType(t.asArrayType().constituent(), index);
        }
        if (t.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            List types = t.asParameterizedType().arguments();
            if (types.size() == 1) {
                return this.verifyQueryResultType((Type)types.get(0), index);
            }
            for (Type type : types) {
                this.verifyQueryResultType(type, index);
            }
        } else {
            ClassInfo typeClass = index.getClassByName(t.name());
            if (typeClass == null) {
                throw new IllegalStateException(String.valueOf(t.name()) + " was not part of the Quarkus index");
            }
        }
        return t;
    }

    protected DotName createSimpleInterfaceImpl(DotName ifaceName, DotName entityName) {
        String fullName = ifaceName.toString();
        int index = fullName.lastIndexOf(46);
        Object packageName = "";
        if (index > 0 && index < fullName.length() - 1) {
            packageName = fullName.substring(0, index) + ".";
        }
        return DotName.createSimple((String)((String)packageName + (ifaceName.isInner() ? ifaceName.local() : ifaceName.withoutPackagePrefix()) + "_" + HashUtil.sha1((String)ifaceName.toString()) + "_" + HashUtil.sha1((String)entityName.toString())));
    }

    protected DotName getPrimitiveTypeName(DotName returnTypeName) {
        if (DotNames.LONG.equals((Object)returnTypeName)) {
            return DotNames.PRIMITIVE_LONG;
        }
        if (DotNames.INTEGER.equals((Object)returnTypeName)) {
            return DotNames.PRIMITIVE_INTEGER;
        }
        if (DotNames.BOOLEAN.equals((Object)returnTypeName)) {
            return DotNames.PRIMITIVE_BOOLEAN;
        }
        return returnTypeName;
    }
}

