/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import org.springframework.core.io.InputStreamSource;
import org.springframework.lang.Nullable;
import org.springframework.util.FileCopyUtils;

public interface Resource
extends InputStreamSource {
    public boolean exists();

    default public boolean isReadable() {
        return this.exists();
    }

    default public boolean isOpen() {
        return false;
    }

    default public boolean isFile() {
        return false;
    }

    public URL getURL() throws IOException;

    public URI getURI() throws IOException;

    public File getFile() throws IOException;

    default public ReadableByteChannel readableChannel() throws IOException {
        return Channels.newChannel(this.getInputStream());
    }

    default public byte[] getContentAsByteArray() throws IOException {
        return FileCopyUtils.copyToByteArray((InputStream)this.getInputStream());
    }

    default public String getContentAsString(Charset charset) throws IOException {
        return FileCopyUtils.copyToString((Reader)new InputStreamReader(this.getInputStream(), charset));
    }

    public long contentLength() throws IOException;

    public long lastModified() throws IOException;

    public Resource createRelative(String var1) throws IOException;

    @Nullable
    public String getFilename();

    public String getDescription();
}

