/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.smallrye.graphql.runtime.SmallRyeAuthGraphQLTransportWSSubprotocolHandler;
import io.quarkus.smallrye.graphql.runtime.SmallRyeAuthGraphQLWSSubprotocolHandler;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLAbstractHandler;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.smallrye.graphql.websocket.GraphQLWebSocketSession;
import io.smallrye.graphql.websocket.GraphQLWebsocketHandler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;

public class SmallRyeGraphQLOverWebSocketHandler
extends SmallRyeGraphQLAbstractHandler {
    private static final Logger log = Logger.getLogger(SmallRyeGraphQLOverWebSocketHandler.class);
    private final Optional<String> authorizationClientInitPayloadName;

    public SmallRyeGraphQLOverWebSocketHandler(CurrentIdentityAssociation currentIdentityAssociation, CurrentVertxRequest currentVertxRequest, boolean runBlocking, Optional<String> authorizationClientInitPayloadName) {
        super(currentIdentityAssociation, currentVertxRequest, runBlocking);
        this.authorizationClientInitPayloadName = authorizationClientInitPayloadName;
    }

    @Override
    protected void doHandle(RoutingContext ctx) {
        if (ctx.request().headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true) && !ctx.request().isEnded()) {
            Map<String, Object> metaData = this.getMetaData(ctx);
            ctx.request().toWebSocket(event -> {
                if (event.succeeded()) {
                    Object handler;
                    ServerWebSocket serverWebSocket = (ServerWebSocket)event.result();
                    String subprotocol = serverWebSocket.subProtocol();
                    if (subprotocol == null) {
                        log.warn((Object)"Websocket subprotocol is null");
                        serverWebSocket.close();
                        return;
                    }
                    switch (subprotocol) {
                        case "graphql-transport-ws": {
                            handler = new SmallRyeAuthGraphQLTransportWSSubprotocolHandler(new QuarkusVertxWebSocketSession(serverWebSocket), metaData, ctx, this, this.authorizationClientInitPayloadName);
                            break;
                        }
                        case "graphql-ws": {
                            handler = new SmallRyeAuthGraphQLWSSubprotocolHandler(new QuarkusVertxWebSocketSession(serverWebSocket), metaData, ctx, this, this.authorizationClientInitPayloadName);
                            break;
                        }
                        default: {
                            log.warn((Object)("Unknown graphql-over-websocket protocol: " + subprotocol));
                            serverWebSocket.close();
                            return;
                        }
                    }
                    log.debugf("Starting websocket with subprotocol = %s", (Object)subprotocol);
                    Object finalHandler = handler;
                    serverWebSocket.closeHandler(arg_0 -> SmallRyeGraphQLOverWebSocketHandler.lambda$doHandle$0((GraphQLWebsocketHandler)finalHandler, arg_0));
                    serverWebSocket.endHandler(arg_0 -> SmallRyeGraphQLOverWebSocketHandler.lambda$doHandle$1((GraphQLWebsocketHandler)finalHandler, arg_0));
                    serverWebSocket.exceptionHandler(arg_0 -> ((GraphQLWebsocketHandler)finalHandler).onThrowable(arg_0));
                    serverWebSocket.textMessageHandler(arg_0 -> ((GraphQLWebsocketHandler)finalHandler).onMessage(arg_0));
                } else {
                    log.warn((Object)"Websocket failed", event.cause());
                }
            });
        } else {
            ctx.next();
        }
    }

    private static /* synthetic */ void lambda$doHandle$1(GraphQLWebsocketHandler finalHandler, Void v) {
        finalHandler.onEnd();
    }

    private static /* synthetic */ void lambda$doHandle$0(GraphQLWebsocketHandler finalHandler, Void v) {
        finalHandler.onClose();
    }

    private static class QuarkusVertxWebSocketSession
    implements GraphQLWebSocketSession {
        private final ServerWebSocket webSocket;
        private final String peer;

        QuarkusVertxWebSocketSession(ServerWebSocket webSocket) {
            this.webSocket = webSocket;
            this.peer = webSocket.remoteAddress() != null ? webSocket.remoteAddress().host() + ":" + webSocket.remoteAddress().port() : "unknown";
        }

        public void sendMessage(String message) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(">>> " + message));
            }
            this.webSocket.writeTextMessage(message);
        }

        public void close(short statusCode, String reason) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Closing graphql websocket connection with code=" + statusCode + " and reason " + reason));
            }
            this.webSocket.close(statusCode, reason);
        }

        public boolean isClosed() {
            return this.webSocket.isClosed();
        }

        public String toString() {
            return "{peer=" + this.peer + "}";
        }
    }
}

